/*
 * Decompiled with CFR 0.152.
 */
package core.stats;

import core.lattice.Lattice;
import core.lattice.LatticeNode;
import java.util.BitSet;
import java.util.HashMap;
import org.apache.commons.math3.util.FastMath;

public class MessageLengthFactorialComputer {
    public long nbCellsEverParsed;
    HashMap<BitSet, Double> lookup = new HashMap();
    double[] logs;
    double[] logFactorials;
    Lattice lattice;
    int nbInstances;
    double lnN;

    @Deprecated
    public MessageLengthFactorialComputer(int nbInstances, Lattice lattice) {
        this.lattice = lattice;
        this.nbInstances = nbInstances;
        int nbFactorials = this.nbInstances + 2;
        int nbVariables = lattice.getNbVariables();
        int nbMaxEdges = nbVariables * (nbVariables - 1) / 2;
        if (nbMaxEdges + 2 > nbFactorials) {
            nbFactorials = nbMaxEdges + 3;
        }
        this.logs = new double[nbFactorials];
        int i = 0;
        while (i < this.logs.length) {
            this.logs[i] = FastMath.log((double)i);
            ++i;
        }
        this.lnN = this.logs[nbInstances];
        this.logFactorials = new double[nbFactorials];
        this.logFactorials[0] = this.logs[1];
        this.logFactorials[1] = this.logs[1];
        i = 2;
        while (i < this.logFactorials.length) {
            this.logFactorials[i] = this.logFactorials[i - 1] + this.logs[i];
            ++i;
        }
        this.nbCellsEverParsed = 0L;
        this.lookup.put(new BitSet(lattice.getNbVariables()), 0.0);
    }

    public MessageLengthFactorialComputer(Lattice lattice) {
        this.lattice = lattice;
        this.nbInstances = this.lattice.getNbInstances();
        int nbFactorials = this.nbInstances + 2;
        int nbVariables = lattice.getNbVariables();
        int nbMaxEdges = nbVariables * (nbVariables - 1) / 2;
        if (nbMaxEdges + 2 > nbFactorials) {
            nbFactorials = nbMaxEdges + 3;
        }
        this.logs = new double[nbFactorials];
        int i = 0;
        while (i < this.logs.length) {
            this.logs[i] = FastMath.log((double)i);
            ++i;
        }
        this.lnN = this.logs[this.nbInstances];
        this.logFactorials = new double[nbFactorials];
        this.logFactorials[0] = this.logs[1];
        this.logFactorials[1] = this.logs[1];
        i = 2;
        while (i < this.logFactorials.length) {
            this.logFactorials[i] = this.logFactorials[i - 1] + this.logs[i];
            ++i;
        }
        this.nbCellsEverParsed = 0L;
        this.lookup.put(new BitSet(lattice.getNbVariables()), 0.0);
    }

    public double computeLengthData(BitSet clique) {
        Double computedLength = this.lookup.get(clique);
        if (computedLength != null) {
            return computedLength;
        }
        LatticeNode node = this.lattice.getNode(clique);
        int nbCells = node.getNbCells();
        this.nbCellsEverParsed += (long)nbCells;
        double length = 0.0;
        length += this.logFactorials[this.nbInstances];
        int i = 0;
        while (i < nbCells) {
            int O = node.getMatrixCell(i);
            length -= this.logFactorials[O];
            ++i;
        }
        this.lookup.put(clique, length);
        return length;
    }

    public int getNbInstances() {
        return this.nbInstances;
    }

    public int getNbVariables() {
        return this.lattice.getNbVariables();
    }

    public double[] getLogFactorials() {
        return this.logFactorials;
    }

    public double[] getLogs() {
        return this.logs;
    }

    public final double getLogFromTable(int i) {
        return this.logs[i];
    }
}

