[comment {# RCS: @(#) $Id: ctext.man,v 1.8 2011/04/18 19:49:48 andreas_kupries Exp $}]
[comment {-*- tcl -*- doctools manpage}]
[manpage_begin ctext n 3.3]
[see_also re_syntax]
[see_also text]
[keywords {syntax highlighting}]
[keywords text]
[keywords widget]
[copyright {George Peter Staplin <GeorgePS@XMission.com>}]
[moddesc   {Ctext a text widget with highlighting support}]
[titledesc {Ctext a text widget with highlighting support}]
[require Tk]
[require ctext [opt 3.3]]
[description]

The [package ctext] package provides the ctext widget which
is an enhanced text widget with support for configurable syntax
highlighting and some extra commands.

[para]

Ctext overloads the text widget and provides
new commands, named [method highlight], [method copy], [method paste],[method cut],
[method append], and [method edit].  It also provides several
commands that allow you to define classes.
Each class corresponds to a tag in the widget.

[section COMMANDS]

[list_begin definitions]
[call [cmd ctext] [arg pathName] [opt [arg options]]]

Creates and configures a ctext widget.

[list_end]

[section {HIGHLIGHTING}]

Highlighting is controlled with text widget tags, that are called highlight classes.
The [arg class] is a tag name and can be configured like any text widget tag.
Four types of highlight classes are supported. All highlight classes are automatically used
by the [method highlight] method of the widget.

[list_begin definitions]

[call [cmd ::ctext::addHighlightClass] [arg pathName] [arg class] [arg color] [arg keywordlist]]

Add a highlighting class [arg class] to the ctext widget [arg pathName].
The highlighting will be done with the color [arg color]. All words in the [arg keywordlist] will be
highlighted.

[example {
	# highlight some tcl keywords
	::ctext::addHighlightClass .t tclkeywords red [list set info interp uplevel upvar]
 }]

[call [cmd ::ctext::addHighlightClassWithOnlyCharStart] [arg pathName] [arg class] [arg color] [arg char]]

Add a highlighting class [arg class] to the ctext widget [arg pathName].
The highlighting will be done with the color [arg color]. All words starting with [arg char] will be
highlighted.

[example {
	::ctext::addHighlightClassWithOnlyCharStart .t vars blue \$
 }]

[call [cmd ::ctext::addHighlightClassForSpecialChars] [arg pathName] [arg class] [arg color] [arg charstring]]

Add a highlighting class [arg class] to the ctext widget [arg pathName].
The highlighting will be done with the color [arg color]. All chars in [arg charstring] will be
highlighted.

[call [cmd ::ctext::addHighlightClassForRegexp] [arg pathName] [arg class] [arg color] [arg pattern]]

Add a highlighting class [arg class] to the ctext widget [arg pathName].
The highlighting will be done with the color [arg color]. All text parts matching the regexp [arg pattern]
will be highlighted.

[call [cmd ::ctext::clearHighlightClasses] [arg pathName]]

Remove all highlight classes from the widget [arg pathName].

[call [cmd ::ctext::getHighlightClasses] [arg pathName]]

List all highlight classes for the widget [arg pathName].

[call [cmd ::ctext::deleteHighlightClass] [arg pathName] [arg class]]

Delete the highlight class [arg class] from the widget [arg pathName]

[call [cmd ::ctext::enableComments] [arg enable]]

Enable C comment highlighting. The [arg class] for c-style comments is [const _cComment].
The C comment highlighting is disabled by default.

[call [cmd ::ctext::disableComments] [arg enable]]

Disable C comment highlighting.

[list_end]

[section {WIDGET COMMANDS}]

Each ctext widget created with the above command supports the following
commands and options in addition to the standard text widget commands and
options.

[list_begin definitions]

[call [arg pathName] [method highlight] [arg startIndex] [arg endIndex]]

Highlight the text between [arg startIndex] and [arg endIndex].

[call [arg pathName] [method fastdelete] [arg index1] [opt [arg index2]]]

Delete text range without updating the highlighting. Arguments
are identical to the [arg pathName] [method delete] command inherited from
the standard text widget.

[call [arg pathName] [method fastinsert] ]

Insert text without updating the highlighting. Arguments
are identical to the [arg pathName] [method insert] command inherited from
the standard text widget.

[call [arg pathName] [method copy] ]

Call [cmd tk_textCopy] for the ctext instance.

[call [arg pathName] [method cut] ]

Call [cmd tk_textCut] for the ctext instance.

[call [arg pathName] [method paste] ]

Call [cmd tk_textPaste] for the ctext instance.

[call [arg pathName] [method append] ]

Append the current selection to the clipboard.

[call [arg pathName] [method configure] [arg option] [arg value] [opt ...]]

Set the options for the ctext widget. Each option name must be followed
the new value.

[list_end]

[section {WIDGET OPTIONS}]

[list_begin tkoptions]

[tkoption_def -linemap "" ""]

Creates (-linemap 1) or deletes (-linemap 0) a line number list on the
left of the widget. The default is to have a linemap displayed.

[tkoption_def -linemapfg "" ""]

Changes the foreground of the linemap.
The default is the same color as the main text
widget.

[tkoption_def -linemapbg "" ""]

Changes the background of the linemap.
The default is the same color as the main text
widget.

[tkoption_def -linemap_select_fg "" ""]

Changes the selected
line foreground.  The default is black.

[tkoption_def -linemap_select_bg "" ""]

Changes the selected line
background.  The default is yellow.

[tkoption_def -linemap_mark_command "" ""]

Calls a procedure or command
with the [arg pathName] of the ctext window, the [arg type] which is
either [const marked] or [const unmarked], and finally the line
number selected.

The proc prototype is:
[example {
proc linemark_cmd {win type line}.
}]

See also
ctext_test_interactive.tcl

[tkoption_def -highlight "" ""]

Takes a boolean value which defines
whether or not to highlight text which is inserted
or deleted.  The default is 1.

[tkoption_def -linemap_markable "" ""]

Takes a boolean value which
specifies whether or not lines in the linemap
are markable with the mouse.  The default is 1.

[list_end]

[section EXAMPLE]
[example {
	package require Tk
	package require ctext

	proc main {} {
	pack [frame .f] -fill both -expand 1
	pack [scrollbar .f.s -command {.f.t yview}] -side right -fill y

	pack [ctext .f.t -bg black -fg white -insertbackground yellow \
		-yscrollcommand {.f.s set}] -fill both -expand 1

	ctext::addHighlightClass .f.t widgets purple \
		[list ctext button label text frame toplevel \
			scrollbar checkbutton canvas listbox menu menubar menubutton \
			radiobutton scale entry message tk_chooseDir tk_getSaveFile \
			tk_getOpenFile tk_chooseColor tk_optionMenu]

	ctext::addHighlightClass .f.t flags orange \
		[list -text -command -yscrollcommand \
			-xscrollcommand -background -foreground -fg -bg \
			-highlightbackground -y -x -highlightcolor -relief -width \
			-height -wrap -font -fill -side -outline -style -insertwidth \
			-textvariable -activebackground -activeforeground -insertbackground \
			-anchor -orient -troughcolor -nonewline -expand -type -message \
			-title -offset -in -after -yscroll -xscroll -forward -regexp -count \
			-exact -padx -ipadx -filetypes -all -from -to -label -value -variable \
			-regexp -backwards -forwards -bd -pady -ipady -state -row -column \
			-cursor -highlightcolors -linemap -menu -tearoff -displayof -cursor \
			-underline -tags -tag]

	ctext::addHighlightClass .f.t stackControl red \
		{proc uplevel namespace while for foreach if else}
	ctext::addHighlightClassWithOnlyCharStart .f.t vars mediumspringgreen "\$"
	ctext::addHighlightClass .f.t variable_funcs gold {set global variable unset}
	ctext::addHighlightClassForSpecialChars .f.t brackets green {[]{}}
	ctext::addHighlightClassForRegexp .f.t paths lightblue {\.[a-zA-Z0-9\_\-]+}
	ctext::addHighlightClassForRegexp .f.t comments khaki {#[^\n\r]*}
	.f.t fastinsert end [info body main]

	pack [frame .f1] -fill x

	.f.t highlight 1.0 end

	pack [button .f1.exit -text Exit -command exit] -side left

	pack [entry .e] -side bottom -fill x
	.e insert end "ctext::deleteHighlightClass .f.t "
	bind .e <Return> {eval [.e get]}
	}
	main

}]

Further examples are in the source package for ctext.

[section THANKS]
Kevin Kenny, Neil Madden, Jeffrey Hobbs, Richard Suchenwirth,
Johan Bengtsson, Mac Cody, Günther, Andreas Sievers, and Michael Schlenker.
[vset CATEGORY ctext]
[include ../../support/devel/doc/feedback.inc]
[manpage_end]
