/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv.bean;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.bean.MappingStrategy;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CsvToBean<T> {
    private Map<Class<?>, PropertyEditor> editorMap = null;

    public List<T> parse(MappingStrategy<T> mappingStrategy, Reader reader) {
        return this.parse(mappingStrategy, new CSVReader(reader));
    }

    public List<T> parse(MappingStrategy<T> mappingStrategy, CSVReader cSVReader) {
        try {
            String[] stringArray;
            mappingStrategy.captureHeader(cSVReader);
            ArrayList<T> arrayList = new ArrayList<T>();
            while (null != (stringArray = cSVReader.readNext())) {
                T t = this.processLine(mappingStrategy, stringArray);
                arrayList.add(t);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error parsing CSV!", exception);
        }
    }

    protected T processLine(MappingStrategy<T> mappingStrategy, String[] stringArray) throws IllegalAccessException, InvocationTargetException, InstantiationException, IntrospectionException {
        T t = mappingStrategy.createBean();
        for (int i = 0; i < stringArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = mappingStrategy.findDescriptor(i);
            if (null == propertyDescriptor) continue;
            String string = this.checkForTrim(stringArray[i], propertyDescriptor);
            Object object = this.convertValue(string, propertyDescriptor);
            propertyDescriptor.getWriteMethod().invoke(t, object);
        }
        return t;
    }

    private String checkForTrim(String string, PropertyDescriptor propertyDescriptor) {
        return this.trimmableProperty(propertyDescriptor) ? string.trim() : string;
    }

    private boolean trimmableProperty(PropertyDescriptor propertyDescriptor) {
        return !propertyDescriptor.getPropertyType().getName().contains("String");
    }

    protected Object convertValue(String string, PropertyDescriptor propertyDescriptor) throws InstantiationException, IllegalAccessException {
        PropertyEditor propertyEditor = this.getPropertyEditor(propertyDescriptor);
        Object object = string;
        if (null != propertyEditor) {
            propertyEditor.setAsText(string);
            object = propertyEditor.getValue();
        }
        return object;
    }

    private PropertyEditor getPropertyEditorValue(Class<?> clazz) {
        PropertyEditor propertyEditor;
        if (this.editorMap == null) {
            this.editorMap = new HashMap();
        }
        if ((propertyEditor = this.editorMap.get(clazz)) == null) {
            propertyEditor = PropertyEditorManager.findEditor(clazz);
            this.addEditorToMap(clazz, propertyEditor);
        }
        return propertyEditor;
    }

    private void addEditorToMap(Class<?> clazz, PropertyEditor propertyEditor) {
        if (propertyEditor != null) {
            this.editorMap.put(clazz, propertyEditor);
        }
    }

    protected PropertyEditor getPropertyEditor(PropertyDescriptor propertyDescriptor) throws InstantiationException, IllegalAccessException {
        Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
        if (null != clazz) {
            return (PropertyEditor)clazz.newInstance();
        }
        return this.getPropertyEditorValue(propertyDescriptor.getPropertyType());
    }
}

