/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleaner$CleanerThread$;
import kafka.log.LogCleanerManager;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u00151{wm\u00117fC:,'O\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0003\u0001\u0011A1B\u0004\u0005\u0002\n\u001d5\t!B\u0003\u0002\f\u0019\u0005!A.\u00198h\u0015\u0005i\u0011\u0001\u00026bm\u0006L!a\u0004\u0006\u0003\r=\u0013'.Z2u!\t\tB#D\u0001\u0013\u0015\t\u0019B!A\u0003vi&d7/\u0003\u0002\u0016%\t9Aj\\4hS:<\u0007CA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\u001diW\r\u001e:jGNL!a\u0007\r\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcDA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u0012\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\u0002\r\r|gNZ5h+\u0005)\u0003C\u0001\u0014(\u001b\u0005\u0011\u0011B\u0001\u0015\u0003\u00055\u0019E.Z1oKJ\u001cuN\u001c4jO\"A!\u0006\u0001B\u0001B\u0003%Q%A\u0004d_:4\u0017n\u001a\u0011\t\u00111\u0002!Q1A\u0005\u00025\nq\u0001\\8h\t&\u00148/F\u0001/!\rir&M\u0005\u0003ay\u0011Q!\u0011:sCf\u0004\"AM\u001b\u000e\u0003MR!\u0001\u000e\u0007\u0002\u0005%|\u0017B\u0001\u001c4\u0005\u00111\u0015\u000e\\3\t\u0011a\u0002!\u0011!Q\u0001\n9\n\u0001\u0002\\8h\t&\u00148\u000f\t\u0005\tu\u0001\u0011)\u0019!C\u0001w\u0005!An\\4t+\u0005a\u0004\u0003B\t>\u007f\u0015K!A\u0010\n\u0003\tA{w\u000e\u001c\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u0012\taaY8n[>t\u0017B\u0001#B\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\t\u0003M\u0019K!a\u0012\u0002\u0003\u00071{w\r\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003=\u0003\u0015awnZ:!\u0011!Y\u0005A!A!\u0002\u0013a\u0015\u0001\u0002;j[\u0016\u0004\"!E'\n\u00059\u0013\"\u0001\u0002+j[\u0016DQ\u0001\u0015\u0001\u0005\u0002E\u000ba\u0001P5oSRtD#\u0002*T)V3\u0006C\u0001\u0014\u0001\u0011\u0015\u0019s\n1\u0001&\u0011\u0015as\n1\u0001/\u0011\u0015Qt\n1\u0001=\u0011\u001dYu\n%AA\u00021Cq\u0001\u0017\u0001C\u0002\u0013%\u0011,\u0001\bdY\u0016\fg.\u001a:NC:\fw-\u001a:\u0016\u0003i\u0003\"AJ.\n\u0005q\u0013!!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe\"1a\f\u0001Q\u0001\ni\u000bqb\u00197fC:,'/T1oC\u001e,'\u000f\t\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0003%!\bN]8ui2,'/F\u0001c!\t\t2-\u0003\u0002e%\tIA\u000b\u001b:piRdWM\u001d\u0005\u0007M\u0002\u0001\u000b\u0011\u00022\u0002\u0015QD'o\u001c;uY\u0016\u0014\b\u0005C\u0004i\u0001\t\u0007I\u0011B5\u0002\u0011\rdW-\u00198feN,\u0012A\u001b\t\u0004WB\u0014X\"\u00017\u000b\u00055t\u0017!C5n[V$\u0018M\u00197f\u0015\tyg$\u0001\u0006d_2dWm\u0019;j_:L!!\u001d7\u0003\u0015%sG-\u001a=fIN+\u0017\u000f\u0005\u0002ti6\t\u0001A\u0002\u0005v\u0001\u0011\u0005\t\u0011!\u0003w\u00055\u0019E.Z1oKJ$\u0006N]3bIN\u0019Ao\u001e\u000f\u0011\u0005EA\u0018BA=\u0013\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\t\u0011m$(\u0011!Q\u0001\nq\f\u0001\u0002\u001e5sK\u0006$\u0017\n\u001a\t\u0003;uL!A \u0010\u0003\u0007%sG\u000f\u0003\u0004Qi\u0012\u0005\u0011\u0011\u0001\u000b\u0004e\u0006\r\u0001\"B>\u0000\u0001\u0004a\b\"CA\u0004i\n\u0007I\u0011IA\u0005\u0003)awnZ4fe:\u000bW.Z\u000b\u0003\u0003\u0017\u00012!CA\u0007\u0013\r\tyA\u0003\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005MA\u000f)A\u0005\u0003\u0017\t1\u0002\\8hO\u0016\u0014h*Y7fA!I\u0011q\u0003;C\u0002\u0013\u0005\u0011\u0011D\u0001\bG2,\u0017M\\3s+\t\tY\u0002E\u0002'\u0003;I1!a\b\u0003\u0005\u001d\u0019E.Z1oKJD\u0001\"a\tuA\u0003%\u00111D\u0001\tG2,\u0017M\\3sA!I\u0011q\u0005;A\u0002\u0013\u0005\u0011\u0011F\u0001\nY\u0006\u001cHo\u0015;biN,\"!a\u000b\u0011\u0007\u0019\ni#C\u0002\u00020\t\u0011Ab\u00117fC:,'o\u0015;biND\u0011\"a\ru\u0001\u0004%\t!!\u000e\u0002\u001b1\f7\u000f^*uCR\u001cx\fJ3r)\u0011\t9$!\u0010\u0011\u0007u\tI$C\u0002\u0002<y\u0011A!\u00168ji\"Q\u0011qHA\u0019\u0003\u0003\u0005\r!a\u000b\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002DQ\u0004\u000b\u0015BA\u0016\u0003)a\u0017m\u001d;Ti\u0006$8\u000f\t\u0015\u0005\u0003\u0003\n9\u0005E\u0002\u001e\u0003\u0013J1!a\u0013\u001f\u0005!1x\u000e\\1uS2,\u0007bBA(i\u0012%\u0011\u0011K\u0001\nG\",7m\u001b#p]\u0016$B!a\u000e\u0002T!9\u0011QKA'\u0001\u0004y\u0014!\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\"9\u0011\u0011\f;\u0005B\u0005m\u0013A\u00023p/>\u00148\u000e\u0006\u0002\u00028!9\u0011q\f;\u0005\n\u0005m\u0013\u0001D2mK\u0006twJ]*mK\u0016\u0004\bbBA2i\u0012\u0005\u0011QM\u0001\fe\u0016\u001cwN\u001d3Ti\u0006$8\u000f\u0006\u0007\u00028\u0005\u001d\u00141NA>\u0003\u000b\u000bI\tC\u0004\u0002j\u0005\u0005\u0004\u0019\u0001?\u0002\u0005%$\u0007\u0002CA7\u0003C\u0002\r!a\u001c\u0002\t9\fW.\u001a\t\u0005\u0003c\n9HD\u0002\u001e\u0003gJ1!!\u001e\u001f\u0003\u0019\u0001&/\u001a3fM&!\u0011qBA=\u0015\r\t)H\b\u0005\t\u0003{\n\t\u00071\u0001\u0002\u0000\u0005!aM]8n!\ri\u0012\u0011Q\u0005\u0004\u0003\u0007s\"\u0001\u0002'p]\u001eD\u0001\"a\"\u0002b\u0001\u0007\u0011qP\u0001\u0003i>D\u0001\"a#\u0002b\u0001\u0007\u00111F\u0001\u0006gR\fGo\u001d\u0005\b\u0003\u001f\u0003\u0001\u0015!\u0003k\u0003%\u0019G.Z1oKJ\u001c\b\u0005C\u0004\u0002\u0014\u0002!\t!a\u0017\u0002\u000fM$\u0018M\u001d;va\"9\u0011q\u0013\u0001\u0005\u0002\u0005m\u0013\u0001C:ikR$wn\u001e8\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\u0006i\u0011MY8si\u000ecW-\u00198j]\u001e$B!a\u000e\u0002 \"9\u0011QKAM\u0001\u0004y\u0004bBAR\u0001\u0011\u0005\u0011QU\u0001\u0016C\n|'\u000f^!oIB\u000bWo]3DY\u0016\fg.\u001b8h)\u0011\t9$a*\t\u000f\u0005U\u0013\u0011\u0015a\u0001\u007f!9\u00111\u0016\u0001\u0005\u0002\u00055\u0016A\u0004:fgVlWm\u00117fC:Lgn\u001a\u000b\u0005\u0003o\ty\u000bC\u0004\u0002V\u0005%\u0006\u0019A \t\u000f\u0005M\u0006\u0001\"\u0001\u00026\u0006a\u0011m^1ji\u000ecW-\u00198fIRQ\u0011qGA\\\u0003w\u000by,a1\t\u0011\u0005e\u0016\u0011\u0017a\u0001\u0003_\nQ\u0001^8qS\u000eDq!!0\u00022\u0002\u0007A0\u0001\u0003qCJ$\b\u0002CAa\u0003c\u0003\r!a \u0002\r=4gm]3u\u0011)\t)-!-\u0011\u0002\u0003\u0007\u0011qP\u0001\bi&lWm\\;u\u0011%\tI\rAI\u0001\n\u0003\tY-\u0001\fbo\u0006LGo\u00117fC:,G\r\n3fM\u0006,H\u000e\u001e\u00135+\t\tiM\u000b\u0003\u0002\u0000\u0005=7FAAi!\u0011\t\u0019.!8\u000e\u0005\u0005U'\u0002BAl\u00033\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005mg$\u0001\u0006b]:|G/\u0019;j_:LA!a8\u0002V\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u0013\u0005\r(!!A\t\u0006\u0005\u0015\u0018A\u0003'pO\u000ecW-\u00198feB\u0019a%a:\u0007\u0013\u0005\u0011A1!A\t\u0006\u0005%8\u0003BAt\u0011qAq\u0001UAt\t\u0003\ti\u000f\u0006\u0002\u0002f\"Q\u0011\u0011_At#\u0003%\t!a=\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u001f\u0016\u0004\u0019\u0006=\u0007")
public class LogCleaner
implements Logging,
KafkaMetricsGroup,
ScalaObject {
    private final CleanerConfig config;
    private final File[] logDirs;
    private final Pool<TopicAndPartition, Log> logs;
    public final Time kafka$log$LogCleaner$$time;
    private final LogCleanerManager kafka$log$LogCleaner$$cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final IndexedSeq kafka$log$LogCleaner$$cleaners;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Time init$default$4() {
        return LogCleaner$.MODULE$.init$default$4();
    }

    public Gauge newGauge(String name, Gauge metric) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit);
    }

    @Override
    public /* synthetic */ boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public /* synthetic */ long awaitCleaned$default$4() {
        return 30000L;
    }

    public CleanerConfig config() {
        return this.config;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicAndPartition, Log> logs() {
        return this.logs;
    }

    public final LogCleanerManager kafka$log$LogCleaner$$cleanerManager() {
        return this.kafka$log$LogCleaner$$cleanerManager;
    }

    public final Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public final IndexedSeq kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)new $anonfun$startup$1(this));
        this.kafka$log$LogCleaner$$cleaners().foreach(new $anonfun$startup$2(this));
    }

    public void shutdown() {
        this.info((Function0<String>)new $anonfun$shutdown$1(this));
        this.kafka$log$LogCleaner$$cleaners().foreach(new $anonfun$shutdown$2(this));
    }

    public void abortCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().abortCleaning(topicAndPartition);
    }

    public void abortAndPauseCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().abortAndPauseCleaning(topicAndPartition);
    }

    public void resumeCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().resumeCleaning(topicAndPartition);
    }

    public void awaitCleaned(String topic, int part, long offset, long timeout) {
        while (!this.kafka$log$LogCleaner$$cleanerManager().allCleanerCheckpoints().contains(new TopicAndPartition(topic, part))) {
            Thread.sleep(10L);
        }
        return;
    }

    public LogCleaner(CleanerConfig config, File[] logDirs, Pool<TopicAndPartition, Log> logs, Time time) {
        this.config = config;
        this.logDirs = logDirs;
        this.logs = logs;
        this.kafka$log$LogCleaner$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.kafka$log$LogCleaner$$cleanerManager = new LogCleanerManager(logDirs, logs);
        this.kafka$log$LogCleaner$$throttler = new Throttler(config.maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = ((TraversableLike)((Object)Predef$.MODULE$.intWrapper(0).until(config.numThreads()))).map(new $anonfun$1(this), IndexedSeq$.MODULE$.canBuildFrom());
        this.newGauge("max-buffer-utilization-percent", new $anon$1(this));
        this.newGauge("cleaner-recopy-percent", new $anon$2(this));
        this.newGauge("max-clean-time-secs", new $anon$3(this));
    }

    public class CleanerThread
    extends ShutdownableThread
    implements ScalaObject {
        private final String loggerName;
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;

        public String loggerName() {
            return this.loggerName;
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats cleanerStats) {
            this.lastStats = cleanerStats;
        }

        public final void kafka$log$LogCleaner$CleanerThread$$checkDone(TopicAndPartition topicAndPartition) {
            if (this.isRunning().get()) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().checkCleaningAborted(topicAndPartition);
                return;
            }
            throw new ThreadShutdownException();
        }

        public void doWork() {
            this.cleanOrSleep();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void cleanOrSleep() {
            LogToClean logToClean;
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().grabFilthiestLog();
            None$ none$ = None$.MODULE$;
            Option<LogToClean> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time.sleep(this.kafka$log$LogCleaner$CleanerThread$$$outer().config().backOffMs());
                return;
            }
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some = (Some)option;
            LogToClean cleanable = logToClean = (LogToClean)some.x();
            long endOffset = cleanable.firstDirtyOffset();
            try {
                endOffset = this.cleaner().clean(cleanable);
                this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, this.cleaner().stats());
                return;
            }
            catch (LogCleaningAbortedException logCleaningAbortedException) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
            return;
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from2, long to2, CleanerStats stats) {
            this.lastStats_$eq(stats);
            this.cleaner().statsUnderlying().swap();
            String message$1 = new StringBuilder().append((Object)Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id), name, BoxesRunTime.boxToLong(from2), BoxesRunTime.boxToLong(to2)}))).append((Object)Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble(stats.elapsedSecs()), BoxesRunTime.boxToDouble(this.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append((Object)Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble(stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble(this.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs())}))).append((Object)Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble((double)100 * stats.bufferUtilization())}))).append((Object)Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble(stats.elapsedSecs() - stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble(this.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs())}))).append((Object)Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong(stats.messagesRead())}))).append((Object)Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong(stats.messagesWritten())}))).append((Object)Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead())), BoxesRunTime.boxToDouble(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead()))}))).toString();
            this.info((Function0<String>)new CleanerThread$$anonfun$recordStats$1(this, message$1));
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        private final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw new NullPointerException();
            }
            super(new StringBuilder().append((Object)"kafka-log-cleaner-thread-").append(BoxesRunTime.boxToInteger(threadId)).toString(), false);
            this.loggerName = LogCleaner.class.getName();
            if (LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)new CleanerThread$$anonfun$5(this));
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads(), (long)Integer.MAX_VALUE), LogCleaner.this.config().hashAlgorithm()), LogCleaner.this.config().ioBufferSize() / LogCleaner.this.config().numThreads() / 2, LogCleaner.this.config().maxMessageSize(), LogCleaner.this.config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, new CleanerThread$$anonfun$6(this));
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.init$default$1());
        }
    }
}

