/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.grid.neighborhood.regular.square;

import java.util.stream.IntStream;
import org.flsgen.grid.neighborhood.INeighborhood;
import org.flsgen.grid.regular.square.RegularSquareGrid;

public class FourConnected<T extends RegularSquareGrid>
implements INeighborhood<T> {
    @Override
    public int[] getNeighbors(T grid, int i) {
        int nbCols = ((RegularSquareGrid)grid).getNbCols();
        int nbRows = ((RegularSquareGrid)grid).getNbRows();
        int left = i % nbCols != 0 ? i - 1 : -1;
        int right = (i + 1) % nbCols != 0 ? i + 1 : -1;
        int top = i >= nbCols ? i - nbCols : -1;
        int bottom = i < nbCols * (nbRows - 1) ? i + nbCols : -1;
        return IntStream.of(left, right, top, bottom).filter(x -> x >= 0).toArray();
    }

    public int getTopNeighbor(T grid, int i) {
        int nbCols = ((RegularSquareGrid)grid).getNbCols();
        if (i >= nbCols) {
            return i - nbCols;
        }
        return -1;
    }

    public int getBottomNeighbor(T grid, int i) {
        int nbRows;
        int nbCols = ((RegularSquareGrid)grid).getNbCols();
        if (i < nbCols * ((nbRows = ((RegularSquareGrid)grid).getNbRows()) - 1)) {
            return i + nbCols;
        }
        return -1;
    }

    public int getLeftNeighbor(T grid, int i) {
        int nbCols = ((RegularSquareGrid)grid).getNbCols();
        if (i % nbCols != 0) {
            return i - 1;
        }
        return -1;
    }

    public int getRightNeighbor(T grid, int i) {
        int nbCols = ((RegularSquareGrid)grid).getNbCols();
        if ((i + 1) % nbCols != 0) {
            return i + 1;
        }
        return -1;
    }
}

