/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import java.util.Iterator;
import java.util.function.Consumer;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IDelta;
import org.chocosolver.solver.variables.delta.IntDelta;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.siglit.SignedLiteral;
import org.chocosolver.solver.variables.view.AbstractView;
import org.chocosolver.util.iterators.DisposableRangeBoundIterator;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueBoundIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.IntVarValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSetUtils;

public abstract class IntView<I extends IntVar>
extends AbstractView<I>
implements IntVar {
    protected final I var;
    protected IntDelta delta;
    protected DisposableValueIterator _viterator;
    protected DisposableRangeIterator _riterator;
    private final IntVarValueIterator _javaIterator = new IntVarValueIterator(this);
    protected SignedLiteral literal;

    protected IntView(String name, I var) {
        super(name, (Variable[])new IntVar[]{var});
        this.var = var;
        this.delta = NoDelta.singleton;
    }

    protected boolean doInstantiateVar(int value) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    protected boolean doUpdateLowerBoundOfVar(int value) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    protected boolean doUpdateUpperBoundOfVar(int value) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    protected boolean doRemoveValueFromVar(int value) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    protected boolean doRemoveIntervalFromVar(int from, int to) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int inf = this.getLB();
        int sup = this.getUB();
        if (inf <= value && value <= sup) {
            IntEventType e = IntEventType.REMOVE;
            this.model.getSolver().getEventObserver().removeValue(this, value, cause);
            if (this.doRemoveValueFromVar(value)) {
                if (value == inf) {
                    e = IntEventType.INCLOW;
                } else if (value == sup) {
                    e = IntEventType.DECUPP;
                }
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                return true;
            }
            this.model.getSolver().getEventObserver().undo();
        }
        return false;
    }

    @Override
    public boolean removeValues(IntIterableSet values, ICause cause) throws ContradictionException {
        assert (cause != null);
        int olb = this.getLB();
        int oub = this.getUB();
        int nlb = values.nextValue(olb - 1);
        int nub = values.previousValue(oub + 1);
        if (nlb > oub || nub < olb) {
            return false;
        }
        if (nlb == olb) {
            do {
                olb = this.nextValue(olb);
                nlb = values.nextValue(olb - 1);
            } while (olb < Integer.MAX_VALUE && oub < Integer.MAX_VALUE && nlb == olb);
        }
        if (nub == oub) {
            do {
                oub = this.previousValue(oub);
                nub = values.previousValue(oub + 1);
            } while (olb > Integer.MIN_VALUE && oub > Integer.MIN_VALUE && nub == oub);
        }
        boolean hasChanged = this.updateBounds(olb, oub, cause);
        int value = nlb;
        int to = nub;
        boolean hasRemoved = false;
        while (value <= to) {
            this.model.getSolver().getEventObserver().removeValue(this, value, cause);
            if (this.doRemoveValueFromVar(value)) {
                hasRemoved = true;
            } else {
                this.model.getSolver().getEventObserver().undo();
            }
            value = values.nextValue(value);
        }
        if (hasRemoved) {
            IntEventType e = IntEventType.REMOVE;
            if (this.var.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            this.notifyPropagators(e, cause);
        }
        return hasRemoved || hasChanged;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        if (this.var.hasEnumeratedDomain()) {
            for (int v = from; v <= to; ++v) {
                if (!this.contains(v)) continue;
                this.model.getSolver().getEventObserver().removeValue(this, v, cause);
            }
            boolean done = this.doRemoveIntervalFromVar(from, to);
            if (done) {
                this.notifyPropagators(IntEventType.REMOVE, cause);
            }
            return done;
        }
        return false;
    }

    @Override
    public boolean removeAllValuesBut(IntIterableSet values, ICause cause) throws ContradictionException {
        int olb = this.getLB();
        int oub = this.getUB();
        int nlb = values.nextValue(olb - 1);
        int nub = values.previousValue(oub + 1);
        boolean hasChanged = this.updateBounds(nlb, nub, cause);
        int to = this.previousValue(nub);
        boolean hasRemoved = false;
        int value = this.nextValue(nlb);
        while (value <= to) {
            if (!values.contains(value)) {
                this.model.getSolver().getEventObserver().removeValue(this, value, cause);
                if (this.doRemoveValueFromVar(value)) {
                    hasRemoved = true;
                } else {
                    this.model.getSolver().getEventObserver().undo();
                }
            }
            value = this.nextValue(value);
        }
        if (hasRemoved) {
            IntEventType e = IntEventType.REMOVE;
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            this.notifyPropagators(e, cause);
        }
        return hasRemoved || hasChanged;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        this.model.getSolver().getEventObserver().instantiateTo(this, value, cause, this.getLB(), this.getUB());
        boolean done = this.doInstantiateVar(value);
        if (done) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        this.model.getSolver().getEventObserver().undo();
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getLB();
        if (old < value) {
            this.model.getSolver().getEventObserver().updateLowerBound(this, value, this.getLB(), cause);
            IntEventType e = IntEventType.INCLOW;
            boolean done = this.doUpdateLowerBoundOfVar(value);
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (done) {
                this.notifyPropagators(e, cause);
                return true;
            }
            this.model.getSolver().getEventObserver().undo();
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getUB();
        if (old > value) {
            this.model.getSolver().getEventObserver().updateUpperBound(this, value, this.getUB(), cause);
            IntEventType e = IntEventType.DECUPP;
            boolean done = this.doUpdateUpperBoundOfVar(value);
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (done) {
                this.notifyPropagators(e, cause);
                return true;
            }
            this.model.getSolver().getEventObserver().undo();
        }
        return false;
    }

    @Override
    public boolean updateBounds(int lb, int ub, ICause cause) throws ContradictionException {
        assert (cause != null);
        int olb = this.getLB();
        int oub = this.getUB();
        boolean hasChanged = false;
        if (olb < lb || oub > ub) {
            IntEventType e = null;
            if (olb < lb) {
                this.model.getSolver().getEventObserver().updateLowerBound(this, lb, this.getLB(), cause);
                e = IntEventType.INCLOW;
                if (this.doUpdateLowerBoundOfVar(lb)) {
                    hasChanged = true;
                } else {
                    this.model.getSolver().getEventObserver().undo();
                }
            }
            if (oub > ub) {
                e = e == null ? IntEventType.DECUPP : IntEventType.BOUND;
                this.model.getSolver().getEventObserver().updateUpperBound(this, ub, this.getUB(), cause);
                if (this.doUpdateUpperBoundOfVar(ub)) {
                    hasChanged = true;
                } else {
                    this.model.getSolver().getEventObserver().undo();
                }
            }
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (hasChanged) {
                this.notifyPropagators(e, cause);
            }
        }
        return hasChanged;
    }

    @Override
    public int getTypeAndKind() {
        return 12;
    }

    public I getVariable() {
        return this.var;
    }

    @Override
    public int getDomainSize() {
        return this.var.getDomainSize();
    }

    @Override
    public int getRange() {
        return this.var.getRange();
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return this.var.hasEnumeratedDomain();
    }

    @Override
    public boolean isInstantiated() {
        return this.getVariable().isInstantiated();
    }

    @Override
    public IDelta getDelta() {
        return this.var.getDelta();
    }

    @Override
    public void createDelta() {
        this.var.createDelta();
    }

    @Override
    public void notify(IEventType event, int variableIdx) throws ContradictionException {
        super.notifyPropagators(this.transformEvent(event), this);
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueBoundIterator(this);
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = new DisposableRangeBoundIterator(this);
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public Iterator<Integer> iterator() {
        this._javaIterator.reset();
        return this._javaIterator;
    }

    @Override
    public void forEachIntVar(Consumer<IntVar> action) {
        action.accept((IntVar)this.var);
        action.accept(this);
    }

    @Override
    public void createLit(IntIterableRangeSet rootDomain) {
        if (this.literal != null) {
            throw new IllegalStateException("createLit(Implications) called twice");
        }
        this.literal = new SignedLiteral.Set(rootDomain);
    }

    @Override
    public SignedLiteral getLit() {
        if (this.literal == null) {
            throw new NullPointerException("getLit() called on null, a call to createLit(Implications) is required");
        }
        return this.literal;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        IntVar pivot = explanation.readVar(p);
        IntView<I> other = this == pivot ? this.getVariable() : this;
        IntIterableRangeSet dom = explanation.complement(other);
        other.unionLit(dom, explanation);
        dom = explanation.complement(pivot);
        IntIterableSetUtils.unionOf(dom, explanation.readDom(p));
        pivot.intersectLit(dom, explanation);
    }
}

