/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.AtomImpl;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.Topology;

final class ToTrigonalTopology
extends AbstractFunction<Graph, Graph> {
    ToTrigonalTopology() {
    }

    public Graph apply(Graph g) {
        int u;
        Graph h = new Graph(g.order());
        for (int u2 = 0; u2 < g.order(); ++u2) {
            h.addTopology(g.topologyOf(u2));
        }
        HashMap<Edge, Edge> replacements = new HashMap<Edge, Edge>();
        for (int u3 = 0; u3 < g.order(); ++u3) {
            for (Edge e : g.edges(u3)) {
                if ((e.other(u3) <= u3 || e.bond() != Bond.UP) && e.bond() != Bond.DOWN) continue;
                replacements.put(e, new Edge(u3, e.other(u3), Bond.IMPLICIT));
            }
        }
        List<Edge> es = this.doubleBondLabelledEdges(g);
        for (Edge e : es) {
            int u4 = e.either();
            int v = e.other(u4);
            h.addTopology(this.toTrigonal(g, e, u4));
            h.addTopology(this.toTrigonal(g, e, v));
        }
        for (u = 0; u < g.order(); ++u) {
            Atom a = g.atom(u);
            if (a.subset() && h.topologyOf(u) != Topology.unknown()) {
                h.addAtom(this.asBracketAtom(u, g));
                continue;
            }
            h.addAtom(a);
        }
        for (u = 0; u < g.order(); ++u) {
            for (Edge e : g.edges(u)) {
                if (e.other(u) <= u) continue;
                Edge replacement = (Edge)replacements.get(e);
                if (replacement != null) {
                    e = replacement;
                }
                h.addEdge(e);
            }
        }
        return h;
    }

    private Atom asBracketAtom(int u, Graph g) {
        Atom a = g.atom(u);
        int sum = a.aromatic() ? 1 : 0;
        for (Edge e : g.edges(u)) {
            sum += e.bond().order();
        }
        return new AtomImpl.BracketAtom(-1, a.element(), a.aromatic() ? a.element().aromaticImplicitHydrogens(sum) : a.element().implicitHydrogens(sum), 0, 0, a.aromatic());
    }

    private Topology toTrigonal(Graph g, Edge e, int u) {
        Edge e1;
        List es = g.edges(u);
        int offset = es.indexOf(e);
        boolean parity = false;
        boolean j = false;
        int[] vs = new int[]{e.other(u), u, u};
        if (es.size() == 2) {
            e1 = (Edge)es.get((offset + 1) % 2);
            Bond b = e1.bond(u);
            if (ToTrigonalTopology.isUp(b)) {
                vs[1] = e1.other(u);
            } else if (ToTrigonalTopology.isDown(b)) {
                vs[2] = e1.other(u);
            }
        } else if (es.size() == 3) {
            e1 = (Edge)es.get((offset + 1) % 3);
            Edge e2 = (Edge)es.get((offset + 2) % 3);
            Bond b1 = e1.bond(u);
            Bond b2 = e2.bond(u);
            if (b1 == Bond.SINGLE || b1 == Bond.IMPLICIT) {
                if (ToTrigonalTopology.isUp(b2)) {
                    vs[1] = e2.other(u);
                    vs[2] = e1.other(u);
                } else if (ToTrigonalTopology.isDown(b2)) {
                    vs[1] = e1.other(u);
                    vs[2] = e2.other(u);
                }
            } else if (ToTrigonalTopology.isUp(b1)) {
                vs[1] = e1.other(u);
                vs[2] = e2.other(u);
            } else if (ToTrigonalTopology.isDown(b1)) {
                vs[1] = e2.other(u);
                vs[2] = e1.other(u);
            }
        }
        if (vs[1] == vs[2]) {
            return Topology.unknown();
        }
        Configuration c = ((Edge)es.get(offset)).other(u) < u ? Configuration.DB1 : Configuration.DB2;
        return Topology.trigonal((int)u, (int[])vs, (Configuration)c);
    }

    static boolean isUp(Bond b) {
        return b == Bond.UP;
    }

    static boolean isDown(Bond b) {
        return b == Bond.DOWN;
    }

    private List<Edge> doubleBondLabelledEdges(Graph g) {
        ArrayList<Edge> es = new ArrayList<Edge>();
        for (int u = 0; u < g.order(); ++u) {
            for (Edge e : g.edges(u)) {
                if (e.other(u) <= u || e.bond() != Bond.DOUBLE) continue;
                es.add(e);
            }
        }
        return es;
    }
}

