/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.AtomImpl;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;

final class FromSubsetAtoms
extends AbstractFunction<Graph, Graph> {
    FromSubsetAtoms() {
    }

    public Graph apply(Graph g) {
        Graph h = new Graph(g.order());
        for (int u = 0; u < g.order(); ++u) {
            h.addAtom(FromSubsetAtoms.fromSubset(g.atom(u), g.bondedValence(u), g.degree(u)));
            h.addTopology(g.topologyOf(u));
        }
        for (Edge e : g.edges()) {
            h.addEdge(e);
        }
        return h;
    }

    static Atom fromSubset(Atom a, int sum, int deg) {
        if (!a.subset()) {
            return a;
        }
        Element e = a.element();
        if (a.aromatic() && deg <= sum) {
            ++sum;
        }
        int hCount = a.aromatic() ? Element.implicitAromHydrogenCount((Element)e, (int)sum) : Element.implicitHydrogenCount((Element)e, (int)sum);
        return new AtomImpl.BracketAtom(-1, a.element(), hCount, 0, 0, a.aromatic());
    }
}

