/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import org.openscience.cdk.formula.FullEnumerationFormulaGenerator;
import org.openscience.cdk.formula.IFormulaGenerator;
import org.openscience.cdk.formula.MolecularFormulaRange;
import org.openscience.cdk.formula.RoundRobinFormulaGenerator;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;

public class MolecularFormulaGenerator
implements IFormulaGenerator {
    protected final IFormulaGenerator formulaGenerator;

    public MolecularFormulaGenerator(IChemObjectBuilder builder, double minMass, double maxMass, MolecularFormulaRange mfRange) {
        this.checkInputParameters(builder, minMass, maxMass, mfRange);
        this.formulaGenerator = MolecularFormulaGenerator.isIllPosed(minMass, maxMass, mfRange) ? new FullEnumerationFormulaGenerator(builder, minMass, maxMass, mfRange) : new RoundRobinFormulaGenerator(builder, minMass, maxMass, mfRange);
    }

    private static boolean isIllPosed(double minMass, double maxMass, MolecularFormulaRange mfRange) {
        if (maxMass - minMass >= 1.0) {
            return true;
        }
        if (maxMass > 400000.0) {
            return true;
        }
        if (mfRange.getIsotopeCount() <= 2) {
            return true;
        }
        double smallestMass = Double.POSITIVE_INFINITY;
        for (IIsotope i : mfRange.isotopes()) {
            smallestMass = Math.min(smallestMass, i.getExactMass());
        }
        return smallestMass > 5.0;
    }

    @Override
    public IMolecularFormula getNextFormula() {
        return this.formulaGenerator.getNextFormula();
    }

    @Override
    public IMolecularFormulaSet getAllFormulas() {
        return this.formulaGenerator.getAllFormulas();
    }

    @Override
    public double getFinishedPercentage() {
        return this.formulaGenerator.getFinishedPercentage();
    }

    @Override
    public void cancel() {
        this.formulaGenerator.cancel();
    }

    protected void checkInputParameters(IChemObjectBuilder builder, double minMass, double maxMass, MolecularFormulaRange mfRange) {
        if (minMass < 0.0 || maxMass < 0.0) {
            throw new IllegalArgumentException("The minimum and maximum mass values must be >=0");
        }
        if (minMass > maxMass) {
            throw new IllegalArgumentException("Minimum mass must be <= maximum mass");
        }
        if (mfRange == null || mfRange.getIsotopeCount() == 0) {
            throw new IllegalArgumentException("The MolecularFormulaRange parameter must be non-null and must contain at least one isotope");
        }
        for (IIsotope isotope : mfRange.isotopes()) {
            if (isotope.getExactMass() != null) continue;
            throw new IllegalArgumentException("The exact mass value of isotope " + isotope + " is not set");
        }
    }
}

