/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.structgen.maygen;

class BoundaryConditions {
    private BoundaryConditions() {
    }

    public static boolean detectTripleBonds(int[][] mat) {
        int length = mat.length;
        for (int[] ints : mat) {
            for (int j = 0; j < length; ++j) {
                if (ints[j] != 3) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean detectAdjacentDoubleBonds(int[][] mat) {
        boolean check = false;
        for (int[] ints : mat) {
            int count = 0;
            for (int j = 0; j < mat.length; ++j) {
                if (ints[j] != 2) continue;
                ++count;
            }
            if (count < 2) continue;
            check = true;
            break;
        }
        return check;
    }

    public static boolean detectAllenes(int[][] mat, String[] symbols) {
        boolean check = false;
        for (int i = 0; i < mat.length; ++i) {
            int count = 0;
            if (!symbols[i].equals("C")) continue;
            for (int j = 0; j < mat.length; ++j) {
                if (mat[i][j] != 2 || !symbols[j].equals("C")) continue;
                ++count;
            }
            if (count < 2) continue;
            check = true;
            break;
        }
        return check;
    }

    public static boolean boundaryConditionCheck(int[][] mat, String[] symbolArray) {
        boolean check = true;
        if (BoundaryConditions.detectAllenes(mat, symbolArray)) {
            check = false;
        }
        if (BoundaryConditions.detectAdjacentDoubleBonds(mat)) {
            check = false;
        }
        if (BoundaryConditions.detectTripleBonds(mat)) {
            check = false;
        }
        return check;
    }
}

