/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class PartialSigmaChargeDescriptor
extends AbstractAtomicDescriptor {
    private static final String[] NAMES = new String[]{"partialSigmaCharge"};
    private GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
    private int maxIterations;

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#partialSigmaCharge", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("PartialSigmaChargeDescriptor only expects one parameter");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter 1 must be of type Integer");
        }
        this.maxIterations = (Integer)params[0];
    }

    public Object[] getParameters() {
        Object[] params = new Object[]{this.maxIterations};
        return params;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    public DescriptorValue calculate(IAtom atom, IAtomContainer ac) {
        if (!this.isCachedAtomContainer(ac)) {
            int i;
            Double[] org = new Double[ac.getAtomCount()];
            for (int i2 = 0; i2 < org.length; ++i2) {
                org[i2] = ac.getAtom(i2).getCharge();
            }
            IAtomContainer mol = (IAtomContainer)atom.getBuilder().newInstance(IAtomContainer.class, new Object[]{ac});
            if (this.maxIterations != 0) {
                this.peoe.setMaxGasteigerIters((double)this.maxIterations);
            }
            try {
                this.peoe.assignGasteigerMarsiliSigmaPartialCharges(mol, true);
                for (i = 0; i < ac.getAtomCount(); ++i) {
                    this.cacheDescriptorValue(ac.getAtom(i), ac, (IDescriptorResult)new DoubleResult(mol.getAtom(i).getCharge().doubleValue()));
                }
            }
            catch (Exception e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), NAMES, e);
            }
            for (i = 0; i < org.length; ++i) {
                mol.getAtom(i).setCharge(org[i]);
            }
        }
        return this.getCachedDescriptorValue(atom) != null ? new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), this.getCachedDescriptorValue(atom), NAMES) : null;
    }

    public String[] getParameterNames() {
        String[] params = new String[]{"maxIterations"};
        return params;
    }

    public Object getParameterType(String name) {
        if ("maxIterations".equals(name)) {
            return Integer.MAX_VALUE;
        }
        return null;
    }
}

