/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

public class BoundsGenerator
implements IGenerator<IReaction> {
    private final IGeneratorParameter<Color> boundsColor = new BoundsColor();

    public IRenderingElement generate(IReaction reaction, RendererModel model) {
        IAtomContainerSet products;
        ElementGroup elementGroup = new ElementGroup();
        IAtomContainerSet reactants = reaction.getReactants();
        if (reactants != null) {
            elementGroup.add(this.generate(reactants));
        }
        if ((products = reaction.getProducts()) != null) {
            elementGroup.add(this.generate(products));
        }
        return elementGroup;
    }

    private IRenderingElement generate(IAtomContainerSet moleculeSet) {
        Rectangle2D totalBounds = BoundsCalculator.calculateBounds((IAtomContainerSet)moleculeSet);
        return new RectangleElement(totalBounds.getMinX(), totalBounds.getMinY(), totalBounds.getMaxX(), totalBounds.getMaxY(), (Color)this.boundsColor.getValue());
    }

    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.boundsColor);
    }

    public static class BoundsColor
    extends AbstractGeneratorParameter<Color> {
        public Color getDefault() {
            return Color.LIGHT_GRAY;
        }
    }
}

