/*
 * Decompiled with CFR 0.152.
 */
package signature;

import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetryClass
implements Comparable<SymmetryClass>,
Iterable<Integer> {
    private final String signatureString;
    private final SortedSet<Integer> vertexIndices;

    public SymmetryClass(String signatureString) {
        this.signatureString = signatureString;
        this.vertexIndices = new TreeSet<Integer>();
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.vertexIndices.iterator();
    }

    public int size() {
        return this.vertexIndices.size();
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public boolean hasSignature(String otherSignatureString) {
        return this.signatureString.equals(otherSignatureString);
    }

    public void addIndex(int vertexIndex) {
        this.vertexIndices.add(vertexIndex);
    }

    public int getMinimal(int vertexIndex, List<Integer> used) {
        int min = -1;
        Iterator i$ = this.vertexIndices.iterator();
        while (i$.hasNext()) {
            int classIndex = (Integer)i$.next();
            if (classIndex == vertexIndex) {
                if (min == -1) {
                    return vertexIndex;
                }
                return min;
            }
            if (used.contains(classIndex)) continue;
            min = classIndex;
        }
        return -1;
    }

    @Override
    public int compareTo(SymmetryClass o) {
        return this.signatureString.compareTo(o.signatureString);
    }

    public String toString() {
        return this.signatureString + " " + this.vertexIndices;
    }
}

