/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.raw;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import org.freehep.graphicsbase.util.images.ImageUtilities;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.graphicsio.raw.RawImageWriterSpi;

public class RawImageWriter
extends ImageWriter {
    public RawImageWriter(RawImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        if (image == null) {
            throw new IllegalArgumentException("image == null");
        }
        if (image.hasRaster()) {
            throw new UnsupportedOperationException("Cannot write rasters");
        }
        Object output = this.getOutput();
        if (output == null) {
            throw new IllegalStateException("output was not set");
        }
        if (param == null) {
            param = this.getDefaultWriteParam();
        }
        ImageOutputStream ios = (ImageOutputStream)output;
        RenderedImage ri = image.getRenderedImage();
        RawImageWriteParam rawParam = (RawImageWriteParam)param;
        byte[] bytes = ImageUtilities.getBytes((RenderedImage)ri, (Color)rawParam.getBackground(), (String)rawParam.getCode(), (int)rawParam.getPad());
        ios.write(bytes);
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new RawImageWriteParam(this.getLocale());
    }
}

