/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.util;

import java.util.Stack;

public class FibonacciHeap {
    private Node m_min;
    private int m_n;

    public boolean isEmpty() {
        return this.m_min == null;
    }

    public void clear() {
        this.m_min = null;
        this.m_n = 0;
    }

    public void decreaseKey(Node node, double d) {
        if (d > node.m_key) {
            throw new IllegalArgumentException("decreaseKey() got larger key value");
        }
        node.m_key = d;
        Node node2 = node.m_parent;
        if (node2 != null && node.m_key < node2.m_key) {
            this.cut(node, node2);
            this.cascadingCut(node2);
        }
        if (node.m_key < this.m_min.m_key) {
            this.m_min = node;
        }
    }

    public void delete(Node node) {
        this.decreaseKey(node, Double.NEGATIVE_INFINITY);
        this.removeMin();
    }

    public void insert(Node node, double d) {
        node.m_key = d;
        if (this.m_min != null) {
            node.m_left = this.m_min;
            node.m_right = this.m_min.m_right;
            this.m_min.m_right = node;
            node.m_right.m_left = node;
            if (d < this.m_min.m_key) {
                this.m_min = node;
            }
        } else {
            this.m_min = node;
        }
        ++this.m_n;
    }

    public Node min() {
        return this.m_min;
    }

    public Node removeMin() {
        Node node = this.m_min;
        if (node != null) {
            Node node2 = node.m_child;
            for (int i = node.m_degree; i > 0; --i) {
                Node node3 = node2.m_right;
                node2.m_left.m_right = node2.m_right;
                node2.m_right.m_left = node2.m_left;
                node2.m_left = this.m_min;
                node2.m_right = this.m_min.m_right;
                this.m_min.m_right = node2;
                node2.m_right.m_left = node2;
                node2.m_parent = null;
                node2 = node3;
            }
            node.m_left.m_right = node.m_right;
            node.m_right.m_left = node.m_left;
            if (node == node.m_right) {
                this.m_min = null;
            } else {
                this.m_min = node.m_right;
                this.consolidate();
            }
            --this.m_n;
        }
        return node;
    }

    public int size() {
        return this.m_n;
    }

    public static FibonacciHeap union(FibonacciHeap fibonacciHeap, FibonacciHeap fibonacciHeap2) {
        FibonacciHeap fibonacciHeap3 = new FibonacciHeap();
        if (fibonacciHeap != null && fibonacciHeap2 != null) {
            fibonacciHeap3.m_min = fibonacciHeap.m_min;
            if (fibonacciHeap3.m_min != null) {
                if (fibonacciHeap2.m_min != null) {
                    fibonacciHeap3.m_min.m_right.m_left = fibonacciHeap2.m_min.m_left;
                    fibonacciHeap2.m_min.m_left.m_right = fibonacciHeap3.m_min.m_right;
                    fibonacciHeap3.m_min.m_right = fibonacciHeap2.m_min;
                    fibonacciHeap2.m_min.m_left = fibonacciHeap3.m_min;
                    if (fibonacciHeap2.m_min.m_key < fibonacciHeap.m_min.m_key) {
                        fibonacciHeap3.m_min = fibonacciHeap2.m_min;
                    }
                }
            } else {
                fibonacciHeap3.m_min = fibonacciHeap2.m_min;
            }
            fibonacciHeap3.m_n = fibonacciHeap.m_n + fibonacciHeap2.m_n;
        }
        return fibonacciHeap3;
    }

    public String toString() {
        if (this.m_min == null) {
            return "FibonacciHeap=[]";
        }
        Stack<Node> stack = new Stack<Node>();
        stack.push(this.m_min);
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("FibonacciHeap=[");
        while (!stack.empty()) {
            Node node = (Node)stack.pop();
            stringBuffer.append(node);
            stringBuffer.append(", ");
            if (node.m_child != null) {
                stack.push(node.m_child);
            }
            Node node2 = node;
            node = node.m_right;
            while (node != node2) {
                stringBuffer.append(node);
                stringBuffer.append(", ");
                if (node.m_child != null) {
                    stack.push(node.m_child);
                }
                node = node.m_right;
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected void cascadingCut(Node node) {
        Node node2 = node.m_parent;
        if (node2 != null) {
            if (!node.m_mark) {
                node.m_mark = true;
            } else {
                this.cut(node, node2);
                this.cascadingCut(node2);
            }
        }
    }

    protected void consolidate() {
        int n;
        int n2;
        int n3 = this.m_n + 1;
        Node[] nodeArray = new Node[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nodeArray[n2] = null;
        }
        n2 = 0;
        Node node = this.m_min;
        if (node != null) {
            ++n2;
            node = node.m_right;
            while (node != this.m_min) {
                ++n2;
                node = node.m_right;
            }
        }
        while (n2 > 0) {
            n = node.m_degree;
            Node node2 = node.m_right;
            while (nodeArray[n] != null) {
                Node node3 = nodeArray[n];
                if (node.m_key > node3.m_key) {
                    Node node4 = node3;
                    node3 = node;
                    node = node4;
                }
                this.link(node3, node);
                nodeArray[n] = null;
                ++n;
            }
            nodeArray[n] = node;
            node = node2;
            --n2;
        }
        this.m_min = null;
        for (n = 0; n < n3; ++n) {
            if (nodeArray[n] == null) continue;
            if (this.m_min != null) {
                nodeArray[n].m_left.m_right = nodeArray[n].m_right;
                nodeArray[n].m_right.m_left = nodeArray[n].m_left;
                nodeArray[n].m_left = this.m_min;
                nodeArray[n].m_right = this.m_min.m_right;
                this.m_min.m_right = nodeArray[n];
                nodeArray[n].m_right.m_left = nodeArray[n];
                if (!(nodeArray[n].m_key < this.m_min.m_key)) continue;
                this.m_min = nodeArray[n];
                continue;
            }
            this.m_min = nodeArray[n];
        }
    }

    protected void cut(Node node, Node node2) {
        node.m_left.m_right = node.m_right;
        node.m_right.m_left = node.m_left;
        --node2.m_degree;
        if (node2.m_child == node) {
            node2.m_child = node.m_right;
        }
        if (node2.m_degree == 0) {
            node2.m_child = null;
        }
        node.m_left = this.m_min;
        node.m_right = this.m_min.m_right;
        this.m_min.m_right = node;
        node.m_right.m_left = node;
        node.m_parent = null;
        node.m_mark = false;
    }

    protected void link(Node node, Node node2) {
        node.m_left.m_right = node.m_right;
        node.m_right.m_left = node.m_left;
        node.m_parent = node2;
        if (node2.m_child == null) {
            node2.m_child = node;
            node.m_right = node;
            node.m_left = node;
        } else {
            node.m_left = node2.m_child;
            node.m_right = node2.m_child.m_right;
            node2.m_child.m_right = node;
            node.m_right.m_left = node;
        }
        ++node2.m_degree;
        node.m_mark = false;
    }

    public static class Node {
        Node m_child;
        Node m_left;
        Node m_parent;
        Node m_right = this;
        boolean m_mark;
        double m_key;
        int m_degree;

        public Node(double d) {
            this.m_left = this;
            this.m_key = d;
        }

        public final double getKey() {
            return this.m_key;
        }

        public String toString() {
            return Double.toString(this.m_key);
        }
    }
}

