/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.pharmacophore;

import org.openscience.cdk.Bond;
import org.openscience.cdk.BondRef;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.pharmacophore.PharmacophoreBond;
import org.openscience.cdk.pharmacophore.PharmacophoreQueryAtom;

public class PharmacophoreQueryBond
extends Bond
implements IQueryBond {
    private double upper;
    private double lower;

    public PharmacophoreQueryBond() {
    }

    public PharmacophoreQueryBond(PharmacophoreQueryAtom atom1, PharmacophoreQueryAtom atom2, double lower, double upper) {
        super((IAtom)atom1, (IAtom)atom2);
        this.upper = this.round(upper, 2);
        this.lower = this.round(lower, 2);
    }

    public PharmacophoreQueryBond(PharmacophoreQueryAtom atom1, PharmacophoreQueryAtom atom2, double distance) {
        super((IAtom)atom1, (IAtom)atom2);
        this.upper = this.round(distance, 2);
        this.lower = this.round(distance, 2);
    }

    public boolean matches(IBond bond) {
        if ((bond = BondRef.deref((IBond)bond)) instanceof PharmacophoreBond) {
            PharmacophoreBond pbond = (PharmacophoreBond)bond;
            double bondLength = this.round(pbond.getBondLength(), 2);
            return bondLength >= this.lower && bondLength <= this.upper;
        }
        return false;
    }

    public double getUpper() {
        return this.upper;
    }

    public double getLower() {
        return this.lower;
    }

    private double round(double val, int places) {
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(val *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DC::" + this.getAtom(0) + "::" + this.getAtom(1) + "::[" + this.getLower() + " - " + this.getUpper() + "] ");
        return sb.toString();
    }
}

