/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SMILESFormat;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class SMILESReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private SmilesParser sp = null;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(SMILESReader.class);

    public SMILESReader(Reader input) {
        this.input = new BufferedReader(input);
    }

    public SMILESReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public SMILESReader() {
        this(new StringReader(""));
    }

    public IResourceFormat getFormat() {
        return SMILESFormat.getInstance();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IAtomContainerSet.class.equals(classObject)) {
            return true;
        }
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IChemFile.class.equals(anInterface)) {
                return true;
            }
            if (!IAtomContainerSet.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        this.sp = new SmilesParser(object.getBuilder());
        if (object instanceof IAtomContainerSet) {
            return (T)this.readAtomContainerSet((IAtomContainerSet)object);
        }
        if (object instanceof IChemFile) {
            IChemFile file = (IChemFile)object;
            IChemSequence sequence = (IChemSequence)file.getBuilder().newInstance(IChemSequence.class, new Object[0]);
            IChemModel chemModel = (IChemModel)file.getBuilder().newInstance(IChemModel.class, new Object[0]);
            chemModel.setMoleculeSet(this.readAtomContainerSet((IAtomContainerSet)file.getBuilder().newInstance(IAtomContainerSet.class, new Object[0])));
            sequence.addChemModel(chemModel);
            file.addChemSequence(sequence);
            return (T)file;
        }
        throw new CDKException("Only supported is reading of MoleculeSet objects.");
    }

    private IAtomContainerSet readAtomContainerSet(IAtomContainerSet som) {
        try {
            String line = this.input.readLine().trim();
            while (line != null) {
                logger.debug((Object)"Line: ", new Object[]{line});
                String name = this.suffix(line);
                try {
                    IAtomContainer molecule = this.sp.parseSmiles(line);
                    molecule.setProperty((Object)"SMIdbNAME", (Object)name);
                    som.addAtomContainer(molecule);
                }
                catch (CDKException exception) {
                    logger.warn((Object)"This SMILES could not be parsed: ", new Object[]{line});
                    logger.warn((Object)"Because of: ", new Object[]{exception.getMessage()});
                    logger.debug((Object)exception);
                    IAtomContainer empty = (IAtomContainer)som.getBuilder().newInstance(IAtomContainer.class, new Object[]{0, 0, 0, 0});
                    empty.setProperty((Object)"bad.smiles.input", (Object)line);
                    som.addAtomContainer(empty);
                }
                if (this.input.ready()) {
                    line = this.input.readLine();
                    continue;
                }
                line = null;
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Error while reading SMILES line: ", new Object[]{exception.getMessage()});
            logger.debug((Object)exception);
        }
        return som;
    }

    public void close() throws IOException {
        this.input.close();
    }

    private String suffix(String line) {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c != ' ' && c != '\t') continue;
            return line.substring(i + 1);
        }
        return null;
    }
}

