/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.Gaussian03Format;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class Gaussian03Reader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(Gaussian03Reader.class);

    public Gaussian03Reader(Reader reader) {
        this.input = new BufferedReader(reader);
    }

    public Gaussian03Reader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public Gaussian03Reader() {
        this(new StringReader(""));
    }

    public IResourceFormat getFormat() {
        return Gaussian03Format.getInstance();
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = new BufferedReader(reader);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IChemFile.class.equals(anInterface)) {
                return true;
            }
            if (!IChemSequence.class.equals(anInterface)) continue;
            return true;
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemSequence) {
            return (T)this.readChemSequence((IChemSequence)object);
        }
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        throw new CDKException("Object " + object.getClass().getName() + " is not supported");
    }

    public void close() throws IOException {
        this.input.close();
    }

    private IChemFile readChemFile(IChemFile chemFile) throws CDKException {
        IChemSequence sequence = this.readChemSequence((IChemSequence)chemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]));
        chemFile.addChemSequence(sequence);
        return chemFile;
    }

    private IChemSequence readChemSequence(IChemSequence sequence) throws CDKException {
        IChemModel model = null;
        try {
            String line = this.input.readLine();
            while (this.input.ready() && line != null) {
                if (line.contains("Standard orientation:")) {
                    model = (IChemModel)sequence.getBuilder().newInstance(IChemModel.class, new Object[0]);
                    try {
                        this.readCoordinates(model);
                        break;
                    }
                    catch (IOException exception) {
                        throw new CDKException("Error while reading coordinates: " + exception, (Throwable)exception);
                    }
                }
                line = this.input.readLine();
            }
            if (model != null) {
                line = this.input.readLine();
                while (this.input.ready() && line != null) {
                    if (line.contains("Standard orientation:")) {
                        sequence.addChemModel(model);
                        this.fireFrameRead();
                        model = (IChemModel)sequence.getBuilder().newInstance(IChemModel.class, new Object[0]);
                        this.readCoordinates(model);
                    } else if (line.contains("SCF Done:")) {
                        model.setProperty((Object)"org.openscience.cdk.io.Gaussian03Reaer:SCF Done", (Object)line.trim());
                    } else if (!line.contains("Harmonic frequencies")) {
                        if (line.contains("Mulliken atomic charges")) {
                            this.readPartialCharges(model);
                        } else if (line.contains("Magnetic shielding") || line.contains("GINC")) {
                            // empty if block
                        }
                    }
                    line = this.input.readLine();
                }
                sequence.addChemModel(model);
                this.fireFrameRead();
            }
        }
        catch (IOException exception) {
            throw new CDKException("Error while reading general structure: " + exception, (Throwable)exception);
        }
        return sequence;
    }

    private void readCoordinates(IChemModel model) throws CDKException, IOException {
        IAtomContainer container = (IAtomContainer)model.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        String line = this.input.readLine();
        line = this.input.readLine();
        line = this.input.readLine();
        line = this.input.readLine();
        while (this.input.ready() && (line = this.input.readLine()) != null && !line.contains("-----")) {
            int atomicNumber;
            StringReader sr = new StringReader(line);
            StreamTokenizer token = new StreamTokenizer(sr);
            token.nextToken();
            if (token.nextToken() == -2) {
                atomicNumber = (int)token.nval;
                if (atomicNumber == 0) {
                    continue;
                }
            } else {
                throw new IOException("Error reading coordinates");
            }
            token.nextToken();
            if (token.nextToken() != -2) {
                throw new IOException("Error reading coordinates");
            }
            double x = token.nval;
            if (token.nextToken() != -2) {
                throw new IOException("Error reading coordinates");
            }
            double y = token.nval;
            if (token.nextToken() != -2) {
                throw new IOException("Error reading coordinates");
            }
            double z = token.nval;
            String symbol = PeriodicTable.getSymbol((int)atomicNumber);
            IAtom atom = (IAtom)model.getBuilder().newInstance(IAtom.class, new Object[]{symbol});
            atom.setPoint3d(new Point3d(x, y, z));
            container.addAtom(atom);
        }
        IAtomContainerSet moleculeSet = (IAtomContainerSet)model.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        moleculeSet.addAtomContainer((IAtomContainer)model.getBuilder().newInstance(IAtomContainer.class, new Object[]{container}));
        model.setMoleculeSet(moleculeSet);
    }

    private void readPartialCharges(IChemModel model) throws CDKException, IOException {
        logger.info((Object)"Reading partial atomic charges");
        IAtomContainerSet moleculeSet = model.getMoleculeSet();
        IAtomContainer molecule = moleculeSet.getAtomContainer(0);
        String line = this.input.readLine();
        while (this.input.ready()) {
            line = this.input.readLine();
            logger.debug((Object)("Read charge block line: " + line));
            if (line == null || line.contains("Sum of Mulliken charges")) {
                logger.debug((Object)"End of charge block found");
                break;
            }
            StringReader sr = new StringReader(line);
            StreamTokenizer tokenizer = new StreamTokenizer(sr);
            if (tokenizer.nextToken() != -2) continue;
            int atomCounter = (int)tokenizer.nval;
            tokenizer.nextToken();
            if (tokenizer.nextToken() != -2) {
                throw new CDKException("Error while reading charge: expected double.");
            }
            double charge = tokenizer.nval;
            logger.debug((Object)("Found charge for atom " + atomCounter + ": " + charge));
            IAtom atom = molecule.getAtom(atomCounter - 1);
            atom.setCharge(Double.valueOf(charge));
        }
    }
}

