/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;

public class ReactionSet
extends ChemObject
implements Serializable,
IReactionSet,
IChemObjectListener,
Cloneable {
    private static final long serialVersionUID = 1555749911904585204L;
    private IReaction[] reactions = new IReaction[this.growArraySize];
    private int reactionCount = 0;
    private int growArraySize = 5;

    public void addReaction(IReaction reaction) {
        if (this.reactionCount + 1 >= this.reactions.length) {
            this.growReactionArray();
        }
        this.reactions[this.reactionCount] = reaction;
        ++this.reactionCount;
        this.notifyChanged();
    }

    public void removeReaction(int pos) {
        this.reactions[pos].removeListener((IChemObjectListener)this);
        for (int i = pos; i < this.reactionCount - 1; ++i) {
            this.reactions[i] = this.reactions[i + 1];
        }
        this.reactions[this.reactionCount - 1] = null;
        --this.reactionCount;
        this.notifyChanged();
    }

    public IReaction getReaction(int number) {
        return this.reactions[number];
    }

    public Iterable<IReaction> reactions() {
        return () -> new ReactionIterator();
    }

    private void growReactionArray() {
        this.growArraySize = this.reactions.length;
        IReaction[] newreactions = new IReaction[this.reactions.length + this.growArraySize];
        System.arraycopy(this.reactions, 0, newreactions, 0, this.reactions.length);
        this.reactions = newreactions;
    }

    public int getReactionCount() {
        return this.reactionCount;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(32);
        buffer.append("ReactionSet(");
        buffer.append(this.hashCode());
        buffer.append(", R=").append(this.getReactionCount()).append(", ");
        for (IReaction reaction : this.reactions()) {
            buffer.append(reaction.toString());
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ReactionSet clone = (ReactionSet)super.clone();
        clone.reactionCount = this.reactionCount;
        clone.reactions = new IReaction[clone.reactionCount];
        for (int f = 0; f < clone.reactionCount; ++f) {
            clone.reactions[f] = (IReaction)this.reactions[f].clone();
        }
        return clone;
    }

    public void removeAllReactions() {
        for (int pos = this.reactionCount - 1; pos >= 0; --pos) {
            this.reactions[pos] = null;
        }
        this.reactionCount = 0;
        this.notifyChanged();
    }

    public void stateChanged(IChemObjectChangeEvent event) {
        this.notifyChanged(event);
    }

    public void removeReaction(IReaction relevantReaction) {
        for (int i = this.reactionCount - 1; i >= 0; --i) {
            if (this.reactions[i] != relevantReaction) continue;
            this.removeReaction(i);
        }
    }

    public boolean isEmpty() {
        return this.reactionCount == 0;
    }

    private class ReactionIterator
    implements Iterator<IReaction> {
        private int pointer = 0;

        private ReactionIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < ReactionSet.this.reactionCount;
        }

        @Override
        public IReaction next() {
            if (this.pointer >= ReactionSet.this.reactionCount) {
                throw new NoSuchElementException();
            }
            return ReactionSet.this.reactions[this.pointer++];
        }

        @Override
        public void remove() {
            ReactionSet.this.removeReaction(--this.pointer);
        }
    }
}

