/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Nodes;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractTorsion;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLAtomSet;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLScalar;
import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Util;

public class CMLTorsion
extends AbstractTorsion {
    static final Logger logger = Logger.getLogger((String)CMLTorsion.class.getName());
    public static final String NS = "cml:torsion";

    public CMLTorsion() {
    }

    public CMLTorsion(CMLTorsion old) {
        super(old);
    }

    @Override
    public Element copy() {
        return new CMLTorsion(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLTorsion();
    }

    public List<String> getAtomIds() {
        ArrayList<String> idList = null;
        String[] atomRefs4 = this.getAtomRefs4();
        if (atomRefs4 != null) {
            idList = new ArrayList<String>();
            for (String s : atomRefs4) {
                idList.add(s);
            }
        }
        return idList;
    }

    public List<CMLAtom> getAtoms(CMLMolecule molecule) {
        ArrayList<CMLAtom> atomList = null;
        String[] atomRefs4 = this.getAtomRefs4();
        if (atomRefs4 == null || molecule == null) {
            throw new RuntimeException("torsion must have molecule (" + molecule + ") and atomRefs4 (" + atomRefs4 + ") to get atoms: " + this.toXML());
        }
        atomList = new ArrayList<CMLAtom>();
        for (String atomRef : atomRefs4) {
            CMLAtom atom = molecule.getAtomById(atomRef);
            if (atom == null) {
                throw new RuntimeException("cannot find atom " + atomRef);
            }
            atomList.add(atom);
        }
        return atomList;
    }

    public List<CMLAtom> getAtoms(CMLAtomSet atomSet) {
        ArrayList<CMLAtom> atomList = null;
        String[] atomRefs4 = this.getAtomRefs4();
        if (atomRefs4 == null || atomSet == null) {
            throw new RuntimeException("torsion must have atomSet and atomRefs4 to get atoms");
        }
        atomList = new ArrayList<CMLAtom>();
        for (String atomRef : atomRefs4) {
            CMLAtom atom = atomSet.getAtomById(atomRef);
            if (atom == null) {
                throw new RuntimeException("cannot find atom " + atomRef);
            }
            atomList.add(atom);
        }
        return atomList;
    }

    public String atomHash() {
        String[] a = this.getAtomRefs4();
        return a == null ? null : CMLTorsion.atomHash(a[0], a[1], a[2], a[3]);
    }

    public Double getCalculatedTorsion() {
        CMLMolecule molecule = CMLMolecule.getAncestorMolecule(this);
        return molecule == null ? null : Double.valueOf(this.getCalculatedTorsion(molecule));
    }

    public Double getCalculatedTorsionRadians() {
        Double ang = this.getCalculatedTorsion();
        return ang == null ? null : Double.valueOf(ang * 57.29577951308232);
    }

    public double getCalculatedTorsion(CMLMolecule molecule) {
        List<CMLAtom> atomList = this.getAtoms(molecule);
        return this.getCalculatedTorsion(atomList);
    }

    public double getCalculatedTorsion(List<CMLAtom> atomList) {
        double calculatedTorsion = Double.NaN;
        if (atomList == null || atomList.size() != 4) {
            throw new RuntimeException("atom list must have 4 elements");
        }
        Point3[] coord = new Point3[4];
        for (int i = 0; i < 4; ++i) {
            coord[i] = atomList.get(i).getXYZ3();
            if (coord[i] == null) break;
        }
        try {
            Angle torsion = Point3.getTorsion((Point3)coord[0], (Point3)coord[1], (Point3)coord[2], (Point3)coord[3]);
            calculatedTorsion = torsion.getDegrees();
        }
        catch (Exception e) {
            throw new RuntimeException("ERROR in torsion " + e);
        }
        return calculatedTorsion;
    }

    public static String atomHash(String atomId1, String atomId2, String atomId3, String atomId4) {
        if (atomId1 == null || atomId2 == null || atomId3 == null || atomId4 == null) {
            return null;
        }
        if (atomId1.compareTo(atomId4) < 0) {
            String temp = atomId4;
            atomId4 = atomId1;
            atomId1 = temp;
            temp = atomId3;
            atomId3 = atomId2;
            atomId2 = temp;
        }
        return atomId1 + "__" + atomId2 + "__" + atomId3 + "__" + atomId4;
    }

    public static List<CMLTorsion> getList(CMLElements<CMLTorsion> torsionElements) {
        ArrayList<CMLTorsion> torsionList = new ArrayList<CMLTorsion>();
        for (CMLTorsion torsion : torsionElements) {
            torsionList.add(torsion);
        }
        return torsionList;
    }

    public static Map<String, CMLTorsion> getIndexedTorsions(List<CMLTorsion> torsions) {
        HashMap<String, CMLTorsion> torsionTable = new HashMap<String, CMLTorsion>();
        for (CMLTorsion torsion : torsions) {
            String[] id = torsion.getAtomRefs4();
            String key = CMLTorsion.atomHash(id[0], id[1], id[2], id[3]);
            torsionTable.put(key, torsion);
        }
        return torsionTable;
    }

    public void setAtomRefs4(CMLAtom rGroup0, CMLAtom atom0, CMLAtom atom1, CMLAtom rGroup1) {
        this.setAtomRefs4(new String[]{rGroup0.getId(), atom0.getId(), atom1.getId(), rGroup1.getId()});
    }

    public static void outputHTML(Writer w, List<CMLTorsion> torsionList, CMLMolecule molecule) throws IOException {
        if (torsionList.size() > 0) {
            w.write("<table border='1'>\n");
            w.write("<tr>");
            w.write("<th>");
            w.write("atom1 (id)");
            w.write("</th>");
            w.write("<th>");
            w.write("atom2 (id)");
            w.write("</th>");
            w.write("<th>");
            w.write("atom3 (id)");
            w.write("</th>");
            w.write("<th>");
            w.write("atom4 (id)");
            w.write("</th>");
            w.write("<th>");
            w.write("torsion");
            w.write("</th>");
            w.write("</tr>\n");
            for (CMLTorsion torsion : torsionList) {
                List<CMLAtom> atoms = torsion.getAtoms(molecule);
                w.write("<tr>");
                for (int i = 0; i < 4; ++i) {
                    w.write("<td>");
                    CMLAtom atom = atoms.get(i);
                    Nodes labelNodes = atom.query("cml:scalar[@dictRef='iucr:_atom_site_label']", CMLConstants.CML_XPATH);
                    String label = ((CMLScalar)labelNodes.get(0)).getXMLContent() + " (" + atom.getId() + ")";
                    w.write(label == null ? atom.getId() : label);
                    w.write("</td>");
                }
                String s = "UNSET";
                try {
                    s = "" + torsion.getXMLContent();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                w.write("<td>" + s.substring(0, Math.min(6, s.length())) + "</td>");
                w.write("</tr>\n");
            }
            w.write("</table>\n");
        }
    }

    public String getString() {
        String s = "";
        String[] aa = this.getAtomRefs4();
        if (aa != null) {
            s = s + Util.concatenate((String[])aa, (String)"-");
        }
        String ss = "UNSET";
        try {
            double dd = this.getXMLContent();
            ss = ss + dd;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        s = s + ": " + ss;
        return s;
    }
}

