/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.io.IOException;
import java.io.Writer;
import nu.xom.Element;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.element.AbstractTableRow;
import org.xmlcml.cml.element.CMLTableCell;

public class CMLTableRow
extends AbstractTableRow {
    public static final String NS = "cml:tableRow";

    public CMLTableRow() {
    }

    public CMLTableRow(CMLTableRow old) {
        super(old);
    }

    @Override
    public Element copy() {
        return new CMLTableRow(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLTableRow();
    }

    @Override
    public void writeHTML(Writer w) throws IOException {
        w.write("\n<tr>");
        CMLElements<CMLTableCell> tableCells = this.getTableCellElements();
        for (CMLTableCell tableCell : tableCells) {
            tableCell.writeHTML(w);
        }
        w.write("</tr>");
    }

    public String getDelimitedString(String delimiter) {
        String delim = delimiter == null || "".equals(delimiter) ? " " : delimiter;
        boolean trim = " ".equals(delim);
        StringBuilder sb = new StringBuilder();
        CMLElements<CMLTableCell> tableCells = this.getTableCellElements();
        int count = 0;
        int last = tableCells.size();
        for (CMLTableCell tableCell : tableCells) {
            String s = CMLUtil.getXMLContent(tableCell);
            if (trim) {
                s.trim();
            }
            sb.append(s);
            if (count++ >= last - 1) continue;
            sb.append(delim);
        }
        return sb.toString();
    }
}

