/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SimpleChemFormatMatcher;

public class MDLV2000Format
extends SimpleChemFormatMatcher
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new MDLV2000Format();
        }
        return myself;
    }

    public String getFormatName() {
        return "MDL Molfile V2000";
    }

    public String getMIMEType() {
        return "chemical/x-mdl-molfile";
    }

    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    public String[] getNameExtensions() {
        return new String[]{"mol"};
    }

    public String getReaderClassName() {
        return "org.openscience.cdk.io.MDLV2000Reader";
    }

    public String getWriterClassName() {
        return "org.openscience.cdk.io.MDLV2000Writer";
    }

    @Override
    public boolean matches(int lineNumber, String line) {
        return lineNumber == 4 && (line.contains("v2000") || line.contains("V2000"));
    }

    public boolean isXMLBased() {
        return false;
    }

    public int getSupportedDataFeatures() {
        return this.getRequiredDataFeatures() | 1 | 2 | 0x200;
    }

    public int getRequiredDataFeatures() {
        return 8;
    }
}

