/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.similarity;

import java.util.BitSet;
import java.util.Map;
import java.util.TreeSet;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IntArrayFingerprint;

public class Tanimoto {
    public static final String EMPTY_FINGERPRINTS_PROVIDED = "Cannot compute Tanimoto of two empty fingerprints!";

    private Tanimoto() {
    }

    public static float calculate(BitSet bitset1, BitSet bitset2) throws CDKException {
        float _bitset1_cardinality = bitset1.cardinality();
        float _bitset2_cardinality = bitset2.cardinality();
        if (bitset1.size() != bitset2.size()) {
            throw new CDKException("Bitsets must have the same bit length");
        }
        BitSet one_and_two = (BitSet)bitset1.clone();
        one_and_two.and(bitset2);
        float _common_bit_count = one_and_two.cardinality();
        return _common_bit_count / (_bitset1_cardinality + _bitset2_cardinality - _common_bit_count);
    }

    public static double calculate(IBitFingerprint fingerprint1, IBitFingerprint fingerprint2) {
        if (fingerprint1.size() != fingerprint2.size()) {
            throw new IllegalArgumentException("Fingerprints must have the same size");
        }
        int cardinality1 = fingerprint1.cardinality();
        int cardinality2 = fingerprint2.cardinality();
        IntArrayFingerprint one_and_two = fingerprint1 instanceof IntArrayFingerprint ? new IntArrayFingerprint(fingerprint1) : new BitSetFingerprint(fingerprint1);
        one_and_two.and(fingerprint2);
        double cardinalityCommon = one_and_two.cardinality();
        return cardinalityCommon / ((double)(cardinality1 + cardinality2) - cardinalityCommon);
    }

    public static float calculate(double[] features1, double[] features2) throws CDKException {
        if (features1.length != features2.length) {
            throw new CDKException("Features vectors must be of the same length");
        }
        int n = features1.length;
        double ab = 0.0;
        double a2 = 0.0;
        double b2 = 0.0;
        for (int i = 0; i < n; ++i) {
            ab += features1[i] * features2[i];
            a2 += features1[i] * features1[i];
            b2 += features2[i] * features2[i];
        }
        double union = a2 + b2 - ab;
        if (union == 0.0) {
            throw new IllegalArgumentException(EMPTY_FINGERPRINTS_PROVIDED);
        }
        return (float)ab / (float)union;
    }

    public static float calculate(Map<String, Integer> features1, Map<String, Integer> features2) {
        TreeSet<String> common = new TreeSet<String>(features1.keySet());
        common.retainAll(features2.keySet());
        double xy = 0.0;
        double x = 0.0;
        double y = 0.0;
        for (String s : common) {
            int c1 = features1.get(s);
            int c2 = features2.get(s);
            xy += (double)(c1 * c2);
        }
        for (Integer c : features1.values()) {
            x += (double)(c * c);
        }
        for (Integer c : features2.values()) {
            y += (double)(c * c);
        }
        double union = x + y - xy;
        if (union == 0.0) {
            throw new IllegalArgumentException(EMPTY_FINGERPRINTS_PROVIDED);
        }
        return (float)(xy / union);
    }

    public static double calculate(ICountFingerprint fp1, ICountFingerprint fp2) {
        return Tanimoto.method2(fp1, fp2);
    }

    public static double method1(ICountFingerprint fp1, ICountFingerprint fp2) {
        long xy = 0L;
        long x = 0L;
        long y = 0L;
        for (int i = 0; i < fp1.numOfPopulatedbins(); ++i) {
            int hash = fp1.getHash(i);
            for (int j = 0; j < fp2.numOfPopulatedbins(); ++j) {
                if (hash != fp2.getHash(j)) continue;
                xy += (long)fp1.getCount(i) * (long)fp2.getCount(j);
            }
            x += (long)fp1.getCount(i) * (long)fp1.getCount(i);
        }
        for (int j = 0; j < fp2.numOfPopulatedbins(); ++j) {
            y += (long)fp2.getCount(j) * (long)fp2.getCount(j);
        }
        long union = x + y - xy;
        if (union == 0L) {
            throw new IllegalArgumentException(EMPTY_FINGERPRINTS_PROVIDED);
        }
        return (double)xy / (double)union;
    }

    public static double method2(ICountFingerprint fp1, ICountFingerprint fp2) {
        long maxSum = 0L;
        long minSum = 0L;
        int i = 0;
        int j = 0;
        while (i < fp1.numOfPopulatedbins() && j < fp2.numOfPopulatedbins()) {
            int hash1 = fp1.getHash(i);
            int count1 = fp1.getCount(i);
            int hash2 = fp2.getHash(j);
            int count2 = fp2.getCount(j);
            if (hash1 < hash2) {
                maxSum += (long)count1;
                ++i;
                continue;
            }
            if (hash1 > hash2) {
                maxSum += (long)count2;
                ++j;
                continue;
            }
            maxSum += (long)Math.max(count1, count2);
            minSum += (long)Math.min(count1, count2);
            ++i;
            ++j;
        }
        while (i < fp1.numOfPopulatedbins()) {
            maxSum += (long)fp1.getCount(i);
            ++i;
        }
        while (j < fp2.numOfPopulatedbins()) {
            maxSum += (long)fp2.getCount(i);
            ++j;
        }
        return (double)minSum / (double)maxSum;
    }
}

