/*
 * Decompiled with CFR 0.152.
 */
package blogspot.software_and_algorithms.stern_library.data_structure;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RedBlackTree<T>
implements Iterable<T> {
    private Comparator<? super T> comparator;
    private Node<T> root;
    private int size;

    public RedBlackTree() {
        this(null);
    }

    public RedBlackTree(Comparator<? super T> comparator) {
        this.comparator = comparator;
        this.root = null;
        this.size = 0;
    }

    public void clear() {
        this.root = null;
        this.size = 0;
    }

    private int compare(T val1, T val2) {
        return this.comparator == null ? ((Comparable)val1).compareTo(val2) : this.comparator.compare(val1, val2);
    }

    public boolean contains(T value) {
        return this.getNode(value) != null;
    }

    protected Node<T> createNewNode(T value) {
        return new Node<T>(value);
    }

    public Node<T> delete(T value) {
        Node<T> swap;
        if (value == null) {
            return null;
        }
        Node<T> node = this.getNode(value);
        if (node == null) {
            return null;
        }
        if (node.getLeft() != null && node.getRight() != null) {
            Node<T> successor = this.getSuccessor(node);
            this.exchangeValues(node, successor);
            node = successor;
        }
        if ((swap = node.getLeft() != null ? node.getLeft() : node.getRight()) != null) {
            swap.setParent(node.getParent());
        }
        if (node.getParent() == null) {
            this.root = swap;
        } else if (node == node.getParent().getLeft()) {
            node.getParent().setLeft(swap);
        } else {
            node.getParent().setRight(swap);
        }
        if (node.getColor() == Node.NodeColor.BLACK && this.root != null) {
            this.fixAfterDeletion(swap == null ? node : swap);
        }
        --this.size;
        return node;
    }

    protected void exchangeValues(Node<T> node, Node<T> successor) {
        T tempValue = successor.getValue();
        successor.setValue(node.getValue());
        node.setValue(tempValue);
    }

    protected void fixAfterDeletion(Node<T> node) {
        while (node != this.root && this.getColor(node) == Node.NodeColor.BLACK) {
            Node<T> temp;
            if (node == node.getParent().getLeft() || node.getParent().getRight() != null && node != node.getParent().getRight()) {
                temp = node.getParent().getRight();
                if (this.getColor(temp) == Node.NodeColor.RED) {
                    this.setColor(temp, Node.NodeColor.BLACK);
                    this.setColor(node.getParent(), Node.NodeColor.RED);
                    this.leftRotate(node.getParent());
                    temp = node.getParent().getRight();
                }
                if (this.getColor(temp.getLeft()) == Node.NodeColor.BLACK && this.getColor(temp.getRight()) == Node.NodeColor.BLACK) {
                    this.setColor(temp, Node.NodeColor.RED);
                    node = node.getParent();
                    continue;
                }
                if (this.getColor(temp.getRight()) == Node.NodeColor.BLACK) {
                    this.setColor(temp.getLeft(), Node.NodeColor.BLACK);
                    this.setColor(temp, Node.NodeColor.RED);
                    this.rightRotate(temp);
                    temp = node.getParent().getRight();
                }
                this.setColor(temp, this.getColor(node.getParent()));
                this.setColor(node.getParent(), Node.NodeColor.BLACK);
                this.setColor(temp.getRight(), Node.NodeColor.BLACK);
                this.leftRotate(node.getParent());
                node = this.root;
                continue;
            }
            temp = node.getParent().getLeft();
            if (this.getColor(temp) == Node.NodeColor.RED) {
                this.setColor(temp, Node.NodeColor.BLACK);
                this.setColor(node.getParent(), Node.NodeColor.RED);
                this.rightRotate(node.getParent());
                temp = node.getParent().getLeft();
            }
            if (this.getColor(temp.getRight()) == Node.NodeColor.BLACK && this.getColor(temp.getLeft()) == Node.NodeColor.BLACK) {
                this.setColor(temp, Node.NodeColor.RED);
                node = node.getParent();
                continue;
            }
            if (this.getColor(temp.getLeft()) == Node.NodeColor.BLACK) {
                this.setColor(temp.getRight(), Node.NodeColor.BLACK);
                this.setColor(temp, Node.NodeColor.RED);
                this.leftRotate(temp);
                temp = node.getParent().getLeft();
            }
            this.setColor(temp, this.getColor(node.getParent()));
            this.setColor(node.getParent(), Node.NodeColor.BLACK);
            this.setColor(temp.getLeft(), Node.NodeColor.BLACK);
            this.rightRotate(node.getParent());
            node = this.root;
        }
        this.setColor(node, Node.NodeColor.BLACK);
    }

    protected void fixAfterInsertion(Node<T> node) {
        while (this.getColor(node.getParent()) == Node.NodeColor.RED) {
            Node<T> temp;
            if (node.getParent() == node.getParent().getParent().getLeft()) {
                temp = node.getParent().getParent().getRight();
                if (this.getColor(temp) == Node.NodeColor.RED) {
                    this.setColor(node.getParent(), Node.NodeColor.BLACK);
                    this.setColor(temp, Node.NodeColor.BLACK);
                    this.setColor(node.getParent().getParent(), Node.NodeColor.RED);
                    node = node.getParent().getParent();
                    continue;
                }
                if (node == node.getParent().getRight()) {
                    node = node.getParent();
                    this.leftRotate(node);
                }
                this.setColor(node.getParent(), Node.NodeColor.BLACK);
                this.setColor(node.getParent().getParent(), Node.NodeColor.RED);
                this.rightRotate(node.getParent().getParent());
                continue;
            }
            temp = node.getParent().getParent().getLeft();
            if (this.getColor(temp) == Node.NodeColor.RED) {
                this.setColor(node.getParent(), Node.NodeColor.BLACK);
                this.setColor(temp, Node.NodeColor.BLACK);
                this.setColor(node.getParent().getParent(), Node.NodeColor.RED);
                node = node.getParent().getParent();
                continue;
            }
            if (node == node.getParent().getLeft()) {
                node = node.getParent();
                this.rightRotate(node);
            }
            this.setColor(node.getParent(), Node.NodeColor.BLACK);
            this.setColor(node.getParent().getParent(), Node.NodeColor.RED);
            this.leftRotate(node.getParent().getParent());
        }
        this.setColor(this.root, Node.NodeColor.BLACK);
    }

    private Node.NodeColor getColor(Node<T> node) {
        return node == null ? Node.NodeColor.BLACK : node.getColor();
    }

    public Node<T> getFirstNode() {
        Node<T> result = this.root;
        if (result != null) {
            while (result.getLeft() != null) {
                result = result.getLeft();
            }
        }
        return result;
    }

    public Node<T> getNode(T value) {
        if (value == null) {
            return null;
        }
        Node<T> node = this.root;
        while (node != null) {
            int delta = this.compare(node.getValue(), value);
            if (delta < 0) {
                node = node.getRight();
                continue;
            }
            if (delta <= 0) break;
            node = node.getLeft();
        }
        return node;
    }

    public Node<T> getPredecessor(Node<T> node) {
        Node<T> temp;
        if (node.getLeft() != null) {
            node = node.getLeft();
            while (node.getRight() != null) {
                node = node.getRight();
            }
            return node;
        }
        for (temp = node.getParent(); temp != null && node == temp.getLeft(); temp = temp.getParent()) {
            node = temp;
        }
        return temp;
    }

    public Node<T> getRoot() {
        return this.root;
    }

    public int getSize() {
        return this.size;
    }

    public Node<T> getSuccessor(Node<T> node) {
        Node<T> temp;
        if (node.getRight() != null) {
            node = node.getRight();
            while (node.getLeft() != null) {
                node = node.getLeft();
            }
            return node;
        }
        for (temp = node.getParent(); temp != null && node == temp.getRight(); temp = temp.getParent()) {
            node = temp;
        }
        return temp;
    }

    public Node<T> insert(T value) {
        Node<T> node = null;
        Node<T> parent = this.root;
        while (parent != null) {
            int delta = this.compare(parent.getValue(), value);
            if (delta < 0) {
                if (parent.getRight() == null) {
                    node = this.createNewNode(value);
                    parent.setRight(node);
                    node.setParent(parent);
                    parent = null;
                    continue;
                }
                parent = parent.getRight();
                continue;
            }
            if (delta > 0) {
                if (parent.getLeft() == null) {
                    node = this.createNewNode(value);
                    parent.setLeft(node);
                    node.setParent(parent);
                    parent = null;
                    continue;
                }
                parent = parent.getLeft();
                continue;
            }
            return null;
        }
        if (node == null) {
            node = this.createNewNode(value);
            this.root = node;
        }
        this.setColor(node, Node.NodeColor.RED);
        this.fixAfterInsertion(node);
        ++this.size;
        return node;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Node<T> cursor;
            private T lastReturn;
            {
                this.cursor = RedBlackTree.this.getFirstNode();
            }

            @Override
            public boolean hasNext() {
                return this.cursor != null;
            }

            @Override
            public T next() {
                if (this.cursor == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturn = this.cursor.getValue();
                this.cursor = RedBlackTree.this.getSuccessor(this.cursor);
                return this.lastReturn;
            }

            @Override
            public void remove() {
                if (this.lastReturn == null) {
                    throw new NoSuchElementException();
                }
                Object currentValue = this.cursor == null ? null : (Object)this.cursor.getValue();
                RedBlackTree.this.delete(this.lastReturn);
                this.cursor = currentValue == null ? null : RedBlackTree.this.getNode(currentValue);
                this.lastReturn = null;
            }
        };
    }

    protected void leftRotate(Node<T> node) {
        Node<T> temp = node.getRight();
        node.setRight(temp.getLeft());
        if (temp.getLeft() != null) {
            temp.getLeft().setParent(node);
        }
        temp.setParent(node.getParent());
        if (node.getParent() == null) {
            this.root = temp;
        } else if (node == node.getParent().getLeft()) {
            node.getParent().setLeft(temp);
        } else {
            node.getParent().setRight(temp);
        }
        temp.setLeft(node);
        node.setParent(temp);
    }

    protected void rightRotate(Node<T> node) {
        Node<T> temp = node.getLeft();
        node.setLeft(temp.getRight());
        if (temp.getRight() != null) {
            temp.getRight().setParent(node);
        }
        temp.setParent(node.getParent());
        if (node.getParent() == null) {
            this.root = temp;
        } else if (node == node.getParent().getRight()) {
            node.getParent().setRight(temp);
        } else {
            node.getParent().setLeft(temp);
        }
        temp.setRight(node);
        node.setParent(temp);
    }

    private void setColor(Node<T> node, Node.NodeColor color) {
        if (node != null) {
            node.setColor(color);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        if (!this.isEmpty()) {
            Iterator<T> i = this.iterator();
            while (true) {
                builder.append(i.next());
                if (!i.hasNext()) break;
                builder.append(", ");
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public static class Node<T> {
        private NodeColor color;
        private Node<T> left;
        private Node<T> right;
        private Node<T> parent;
        private T value;

        public Node(T value) {
            if (value == null) {
                throw new NullPointerException("value is null");
            }
            this.value = value;
        }

        public NodeColor getColor() {
            return this.color;
        }

        public Node<T> getLeft() {
            return this.left;
        }

        public Node<T> getParent() {
            return this.parent;
        }

        public Node<T> getRight() {
            return this.right;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isLeaf() {
            return this.left == null && this.right == null;
        }

        protected void setColor(NodeColor color) {
            this.color = color;
        }

        protected void setLeft(Node<T> node) {
            this.left = node;
        }

        protected void setParent(Node<T> node) {
            this.parent = node;
        }

        protected void setRight(Node<T> node) {
            this.right = node;
        }

        protected void setValue(T value) {
            if (value == null) {
                throw new IllegalArgumentException("value is null");
            }
            this.value = value;
        }

        public static enum NodeColor {
            BLACK,
            RED;

        }
    }
}

