/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.intlincomb.policy;

import choco.cp.solver.constraints.integer.intlincomb.policy.CoeffPolicy;
import choco.kernel.common.util.tools.MathUtils;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class ForScalar
extends CoeffPolicy {
    static CoeffPolicy get(IntDomainVar[] vars, int[] coeffs, int nbPosVars, int cste) {
        return new ForScalar(vars, coeffs, nbPosVars, cste);
    }

    private ForScalar(IntDomainVar[] vars, int[] coeffs, int nbPosVars, int cste) {
        super(vars, coeffs, nbPosVars, cste);
    }

    @Override
    public int getInfNV(int i, int mylb) {
        return MathUtils.divCeil(mylb, -this.coeffs[i]) + this.vars[i].getSup();
    }

    @Override
    public int getSupNV(int i, int myub) {
        return MathUtils.divFloor(myub, -this.coeffs[i]) + this.vars[i].getInf();
    }

    @Override
    public int getInfPV(int i, int myub) {
        return MathUtils.divCeil(-myub, this.coeffs[i]) + this.vars[i].getSup();
    }

    @Override
    public int getSupPV(int i, int mylb) {
        return MathUtils.divFloor(-mylb, this.coeffs[i]) + this.vars[i].getInf();
    }

    @Override
    public int computeLowerBound() {
        int i;
        int lb = this.cste;
        for (i = 0; i < this.nbPosVars; ++i) {
            lb += this.coeffs[i] * this.vars[i].getInf();
        }
        for (i = this.nbPosVars; i < this.vars.length; ++i) {
            lb += this.coeffs[i] * this.vars[i].getSup();
        }
        return lb;
    }

    @Override
    public int computeUpperBound() {
        int i;
        int ub = this.cste;
        for (i = 0; i < this.nbPosVars; ++i) {
            ub += this.coeffs[i] * this.vars[i].getSup();
        }
        for (i = this.nbPosVars; i < this.vars.length; ++i) {
            ub += this.coeffs[i] * this.vars[i].getInf();
        }
        return ub;
    }
}

