/*
 * Decompiled with CFR 0.152.
 */
package keel.Dataset;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.ErrorInfo;
import keel.Dataset.InstanceAttributes;
import keel.Dataset.InstanceParser;
import keel.Dataset.InstanceSet;

public class Instance {
    private String[][] nominalValues;
    private int[][] intNominalValues;
    private double[][] realValues;
    private boolean[][] missingValues;
    private boolean isTrain;
    private int numInputAttributes;
    private int numOutputAttributes;
    private int numUndefinedAttributes;
    private boolean[] anyMissingValue;
    public static final int ATT_INPUT = 0;
    public static final int ATT_OUTPUT = 1;
    public static final int ATT_NONDEF = 2;

    public Instance(String def, boolean _isTrain, int instanceNum) {
        int currentClass = -1;
        StringTokenizer st = new StringTokenizer(def, ",");
        this.initClassAttributes();
        this.isTrain = _isTrain;
        int count = 0;
        int inAttCount = 0;
        int outAttCount = 0;
        int indefCount = 0;
        int inputOutput = 0;
        while (st.hasMoreTokens()) {
            int curCount;
            String att = st.nextToken().trim();
            Attribute curAt = Attributes.getAttribute(count);
            switch (curAt.getDirectionAttribute()) {
                case 1: {
                    inputOutput = 0;
                    curCount = inAttCount++;
                    break;
                }
                case 2: {
                    inputOutput = 1;
                    if (curAt.getType() == 0) {
                        currentClass = curAt.convertNominalValue(att);
                    }
                    curCount = outAttCount++;
                    break;
                }
                default: {
                    inputOutput = 2;
                    curCount = indefCount++;
                }
            }
            this.processReadValue(curAt, def, att, inputOutput, count, curCount, instanceNum);
            ++count;
        }
        if (count != Attributes.getNumAttributes()) {
            ErrorInfo er = new ErrorInfo(0, instanceNum, InstanceParser.lineCounter, 0, 0, this.isTrain, "Instance " + def + " has a different number of attributes than defined\n   > Number of attributes defined: " + Attributes.getNumAttributes() + "   > Number of attributes read:    " + count);
            InstanceSet.errorLogger.setError(er);
        }
        if (this.isTrain) {
            Attribute[] atts = Attributes.getInputAttributes();
            for (int i = 0; i < atts.length; ++i) {
                if (this.missingValues[0][i]) continue;
                if (atts[i].getType() == 0 && Attributes.getOutputNumAttributes() == 1) {
                    atts[i].increaseClassFrequency(currentClass, this.nominalValues[0][i]);
                    continue;
                }
                if (atts[i].getType() != 1 && atts[i].getType() != 2 || this.missingValues[0][i]) continue;
                atts[i].addInMeanValue(currentClass, this.realValues[0][i]);
            }
        }
    }

    public Instance(Instance inst) {
        int i;
        this.isTrain = inst.isTrain;
        this.numInputAttributes = inst.numInputAttributes;
        this.numOutputAttributes = inst.numOutputAttributes;
        this.numUndefinedAttributes = inst.numUndefinedAttributes;
        this.anyMissingValue = Arrays.copyOf(inst.anyMissingValue, inst.anyMissingValue.length);
        this.nominalValues = new String[inst.nominalValues.length][];
        for (i = 0; i < this.nominalValues.length; ++i) {
            this.nominalValues[i] = Arrays.copyOf(inst.nominalValues[i], inst.nominalValues[i].length);
        }
        this.intNominalValues = new int[inst.intNominalValues.length][];
        for (i = 0; i < this.nominalValues.length; ++i) {
            this.intNominalValues[i] = Arrays.copyOf(inst.intNominalValues[i], inst.intNominalValues[i].length);
        }
        this.realValues = new double[inst.realValues.length][];
        for (i = 0; i < this.realValues.length; ++i) {
            this.realValues[i] = Arrays.copyOf(inst.realValues[i], inst.realValues[i].length);
        }
        this.missingValues = new boolean[inst.missingValues.length][];
        for (i = 0; i < this.missingValues.length; ++i) {
            this.missingValues[i] = Arrays.copyOf(inst.missingValues[i], inst.missingValues[i].length);
        }
    }

    public Instance(double[] values, InstanceAttributes ats) {
        int i;
        this.anyMissingValue = new boolean[3];
        this.anyMissingValue[0] = false;
        this.anyMissingValue[1] = false;
        this.anyMissingValue[2] = false;
        if (ats == null) {
            this.numInputAttributes = Attributes.getInputNumAttributes();
            this.numOutputAttributes = Attributes.getOutputNumAttributes();
            this.numUndefinedAttributes = Attributes.getNumAttributes() - (this.numInputAttributes + this.numOutputAttributes);
        } else {
            this.numInputAttributes = ats.getInputNumAttributes();
            this.numOutputAttributes = ats.getOutputNumAttributes();
            this.numUndefinedAttributes = ats.getNumAttributes() - (this.numInputAttributes + this.numOutputAttributes);
        }
        this.intNominalValues = new int[3][];
        this.nominalValues = new String[3][];
        this.realValues = new double[3][];
        this.missingValues = new boolean[3][];
        this.nominalValues[0] = new String[this.numInputAttributes];
        this.nominalValues[1] = new String[this.numOutputAttributes];
        this.nominalValues[2] = new String[this.numUndefinedAttributes];
        this.intNominalValues[0] = new int[this.numInputAttributes];
        this.intNominalValues[1] = new int[this.numOutputAttributes];
        this.intNominalValues[2] = new int[this.numUndefinedAttributes];
        this.realValues[0] = new double[this.numInputAttributes];
        this.realValues[1] = new double[this.numOutputAttributes];
        this.realValues[2] = new double[this.numUndefinedAttributes];
        this.missingValues[0] = new boolean[this.numInputAttributes];
        this.missingValues[1] = new boolean[this.numOutputAttributes];
        this.missingValues[2] = new boolean[this.numUndefinedAttributes];
        for (i = 0; i < this.numInputAttributes; ++i) {
            this.missingValues[0][i] = false;
        }
        for (i = 0; i < this.numOutputAttributes; ++i) {
            this.missingValues[1][i] = false;
        }
        for (i = 0; i < this.numUndefinedAttributes; ++i) {
            this.missingValues[2][i] = false;
        }
        Attribute[] allat = ats != null ? ats.getAttributes() : Attributes.getAttributes();
        int undef = 0;
        int out = 0;
        int in = 0;
        for (i = 0; i < values.length; ++i) {
            Attribute curAt = allat[i];
            int inOut = 2;
            if (curAt.getDirectionAttribute() == 1) {
                inOut = 0;
            } else if (curAt.getDirectionAttribute() == 2) {
                inOut = 1;
            }
            if (new Double(values[i]).isNaN()) {
                if (inOut == 0) {
                    this.missingValues[inOut][in] = true;
                    this.anyMissingValue[inOut] = true;
                    ++in;
                    continue;
                }
                if (inOut == 1) {
                    this.missingValues[inOut][out] = true;
                    this.anyMissingValue[inOut] = true;
                    ++out;
                    continue;
                }
                this.missingValues[inOut][undef] = true;
                this.anyMissingValue[inOut] = true;
                ++undef;
                continue;
            }
            if (curAt.getType() != 0) {
                if (inOut == 0) {
                    this.realValues[inOut][in] = values[i];
                    ++in;
                    continue;
                }
                if (inOut == 1) {
                    this.realValues[inOut][out] = values[i];
                    ++out;
                    continue;
                }
                this.realValues[inOut][undef] = values[i];
                ++undef;
                continue;
            }
            if (inOut == 0) {
                this.intNominalValues[inOut][in] = (int)values[i];
                this.realValues[inOut][in] = values[i];
                this.nominalValues[inOut][in] = curAt.getNominalValue((int)values[i]);
                ++in;
                continue;
            }
            if (inOut == 1) {
                this.intNominalValues[inOut][out] = (int)values[i];
                this.realValues[inOut][out] = values[i];
                this.nominalValues[inOut][out] = curAt.getNominalValue((int)values[i]);
                ++out;
                continue;
            }
            this.intNominalValues[inOut][undef] = (int)values[i];
            this.realValues[inOut][undef] = values[i];
            this.nominalValues[inOut][undef] = curAt.getNominalValue((int)values[i]);
            ++undef;
        }
    }

    private void processReadValue(Attribute curAtt, String def, String att, int inOut, int count, int curCount, int instanceNum) {
        if (att.equalsIgnoreCase("<null>") || att.equalsIgnoreCase("?")) {
            Attributes.hasMissing = true;
            this.missingValues[inOut][curCount] = true;
            this.anyMissingValue[inOut] = true;
            if (inOut == 1) {
                ErrorInfo er = new ErrorInfo(1, instanceNum, InstanceParser.lineCounter, curCount, 2, this.isTrain, "Output attribute " + count + " of " + def + " with missing value.");
                InstanceSet.errorLogger.setError(er);
            }
        } else if (Attributes.getAttribute(count).getType() == 1 || Attributes.getAttribute(count).getType() == 2) {
            try {
                this.realValues[inOut][curCount] = Double.parseDouble(att);
            }
            catch (NumberFormatException e) {
                ErrorInfo er = new ErrorInfo(2, instanceNum, InstanceParser.lineCounter, curCount, 1 + inOut, this.isTrain, "Attribute " + count + " of " + def + " is not an integer or real value.");
                InstanceSet.errorLogger.setError(er);
            }
            if (this.isTrain && inOut != 2) {
                if (curAtt.getFixedBounds() && !curAtt.isInBounds(this.realValues[inOut][curCount])) {
                    ErrorInfo er = new ErrorInfo(5, instanceNum, InstanceParser.lineCounter, curCount, 1 + inOut, this.isTrain, "ERROR READING TRAIN FILE. Value " + this.realValues[inOut][curCount] + " read for a numeric attribute that is not in the bounds fixed in the attribute '" + curAtt.getName() + "' definition.");
                    InstanceSet.errorLogger.setError(er);
                }
                curAtt.enlargeBounds(this.realValues[inOut][curCount]);
            } else if (inOut != 2) {
                this.realValues[inOut][curCount] = curAtt.rectifyValueInBounds(this.realValues[inOut][curCount]);
            }
        } else if (Attributes.getAttribute(count).getType() == 0) {
            this.nominalValues[inOut][curCount] = att;
            if (this.isTrain && inOut != 2) {
                if (curAtt.getFixedBounds() && !curAtt.isNominalValue(this.nominalValues[inOut][curCount])) {
                    ErrorInfo er = new ErrorInfo(3, instanceNum, InstanceParser.lineCounter, curCount, 1 + inOut, this.isTrain, "ERROR READING TRAIN FILE. Value '" + this.nominalValues[inOut][curCount] + "' read for a nominal attribute that is not in the possible list of values fixed in the attribute '" + curAtt.getName() + "' definition.");
                    InstanceSet.errorLogger.setError(er);
                }
                curAtt.addNominalValue(this.nominalValues[inOut][curCount]);
            } else if (inOut != 2 && curAtt.addTestNominalValue(this.nominalValues[inOut][curCount])) {
                ErrorInfo er = new ErrorInfo(4, instanceNum, InstanceParser.lineCounter, curCount, 1 + inOut, this.isTrain, "ERROR READING TEST FILE. Value '" + this.nominalValues[inOut][curCount] + "' read for a nominal attribute that is not in the possible list of values fixed in the attribute '" + curAtt.getName() + "' definition.");
                InstanceSet.errorLogger.setError(er);
            }
            if (inOut != -2) {
                this.intNominalValues[inOut][curCount] = curAtt.convertNominalValue(this.nominalValues[inOut][curCount]);
                this.realValues[inOut][curCount] = this.intNominalValues[inOut][curCount];
            }
        }
    }

    private void initClassAttributes() {
        int i;
        this.anyMissingValue = new boolean[3];
        this.anyMissingValue[0] = false;
        this.anyMissingValue[1] = false;
        this.anyMissingValue[2] = false;
        this.numInputAttributes = Attributes.getInputNumAttributes();
        this.numOutputAttributes = Attributes.getOutputNumAttributes();
        this.numUndefinedAttributes = Attributes.getNumAttributes() - (this.numInputAttributes + this.numOutputAttributes);
        this.intNominalValues = new int[3][];
        this.nominalValues = new String[3][];
        this.realValues = new double[3][];
        this.missingValues = new boolean[3][];
        this.nominalValues[0] = new String[this.numInputAttributes];
        this.nominalValues[1] = new String[this.numOutputAttributes];
        this.nominalValues[2] = new String[this.numUndefinedAttributes];
        this.intNominalValues[0] = new int[this.numInputAttributes];
        this.intNominalValues[1] = new int[this.numOutputAttributes];
        this.intNominalValues[2] = new int[this.numUndefinedAttributes];
        this.realValues[0] = new double[this.numInputAttributes];
        this.realValues[1] = new double[this.numOutputAttributes];
        this.realValues[2] = new double[this.numUndefinedAttributes];
        this.missingValues[0] = new boolean[this.numInputAttributes];
        this.missingValues[1] = new boolean[this.numOutputAttributes];
        this.missingValues[2] = new boolean[this.numUndefinedAttributes];
        for (i = 0; i < this.numInputAttributes; ++i) {
            this.missingValues[0][i] = false;
        }
        for (i = 0; i < this.numOutputAttributes; ++i) {
            this.missingValues[1][i] = false;
        }
        for (i = 0; i < this.numUndefinedAttributes; ++i) {
            this.missingValues[2][i] = false;
        }
    }

    public void print(PrintWriter out) {
        int i;
        out.print("    > Inputs: ");
        block15: for (i = 0; i < this.numInputAttributes; ++i) {
            switch (Attributes.getInputAttribute(i).getType()) {
                case 0: {
                    out.print(this.nominalValues[0][i]);
                    continue block15;
                }
                case 1: {
                    out.print(this.realValues[0][i]);
                    continue block15;
                }
                case 2: {
                    out.print(this.realValues[0][i]);
                }
            }
        }
        out.print("\n    > Outputs: ");
        block16: for (i = 0; i < this.numOutputAttributes; ++i) {
            switch (Attributes.getOutputAttribute(i).getType()) {
                case 0: {
                    out.print(this.nominalValues[1][i]);
                    continue block16;
                }
                case 1: {
                    out.print(this.realValues[1][i]);
                    continue block16;
                }
                case 2: {
                    out.print(this.realValues[1][i]);
                }
            }
        }
        out.print("\n    > Undefined: ");
        block17: for (i = 0; i < this.numUndefinedAttributes; ++i) {
            switch (Attributes.getOutputAttribute(i).getType()) {
                case 0: {
                    out.print(this.nominalValues[1][i]);
                    continue block17;
                }
                case 1: {
                    out.print(this.realValues[1][i]);
                    continue block17;
                }
                case 2: {
                    out.print(this.realValues[1][i]);
                }
            }
        }
    }

    public void printAsOriginal(PrintWriter out) {
        int inCount = 0;
        int outCount = 0;
        int undefCount = 0;
        int numAttributes = Attributes.getNumAttributes();
        for (int count = 0; count < numAttributes; ++count) {
            Attribute at = Attributes.getAttribute(count);
            switch (at.getDirectionAttribute()) {
                case 1: {
                    this.printAttribute(out, 0, inCount, at.getType());
                    ++inCount;
                    break;
                }
                case 2: {
                    this.printAttribute(out, 1, outCount, at.getType());
                    ++outCount;
                    break;
                }
                case -1: {
                    this.printAttribute(out, 2, undefCount, at.getType());
                    ++undefCount;
                }
            }
            if (count + 1 >= numAttributes) continue;
            out.print(",");
        }
    }

    private void printAttribute(PrintWriter out, int inOut, int ct, int type) {
        if (this.missingValues[inOut][ct]) {
            out.print("<null>");
        } else {
            switch (type) {
                case 0: {
                    out.print(this.nominalValues[inOut][ct]);
                    break;
                }
                case 1: {
                    out.print((int)this.realValues[inOut][ct]);
                    break;
                }
                case 2: {
                    out.print(this.realValues[inOut][ct]);
                }
            }
        }
    }

    public void print() {
        int i;
        System.out.print("  > Inputs (" + this.numInputAttributes + "): ");
        for (i = 0; i < this.numInputAttributes; ++i) {
            if (this.missingValues[0][i]) {
                System.out.print("?");
            } else {
                switch (Attributes.getInputAttribute(i).getType()) {
                    case 0: {
                        System.out.print(this.nominalValues[0][i]);
                        break;
                    }
                    case 1: {
                        System.out.print((int)this.realValues[0][i]);
                        break;
                    }
                    case 2: {
                        System.out.print(this.realValues[0][i]);
                    }
                }
            }
            System.out.print("  ");
        }
        System.out.print("  > Outputs (" + this.numOutputAttributes + "): ");
        for (i = 0; i < this.numOutputAttributes; ++i) {
            if (this.missingValues[1][i]) {
                System.out.print("?");
            } else {
                switch (Attributes.getOutputAttribute(i).getType()) {
                    case 0: {
                        System.out.print(this.nominalValues[1][i]);
                        break;
                    }
                    case 1: {
                        System.out.print((int)this.realValues[1][i]);
                        break;
                    }
                    case 2: {
                        System.out.print(this.realValues[1][i]);
                    }
                }
            }
            System.out.print("  ");
        }
        System.out.print("  > Undefined (" + this.numUndefinedAttributes + "): ");
        for (i = 0; i < this.numUndefinedAttributes; ++i) {
            if (this.missingValues[2][i]) {
                System.out.print("?");
            } else {
                switch (Attributes.getUndefinedAttribute(i).getType()) {
                    case 0: {
                        System.out.print(this.nominalValues[2][i]);
                        break;
                    }
                    case 1: {
                        System.out.print((int)this.realValues[2][i]);
                        break;
                    }
                    case 2: {
                        System.out.print(this.realValues[2][i]);
                    }
                }
            }
            System.out.print("  ");
        }
    }

    public double[] getInputRealValues() {
        return this.realValues[0];
    }

    public String[] getInputNominalValues() {
        return this.nominalValues[0];
    }

    public boolean[] getInputMissingValues() {
        return this.missingValues[0];
    }

    public double[] getOutputRealValues() {
        return this.realValues[1];
    }

    public String[] getOutputNominalValues() {
        return this.nominalValues[1];
    }

    public boolean[] getOutputMissingValues() {
        return this.missingValues[1];
    }

    public double getInputRealValues(int pos) {
        return this.realValues[0][pos];
    }

    public String getInputNominalValues(int pos) {
        return this.nominalValues[0][pos];
    }

    public int getInputNominalValuesInt(int pos) {
        return this.intNominalValues[0][pos];
    }

    public int[] getInputNominalValuesInt() {
        return this.intNominalValues[0];
    }

    public boolean getInputMissingValues(int pos) {
        return this.missingValues[0][pos];
    }

    public double getOutputRealValues(int pos) {
        return this.realValues[1][pos];
    }

    public String getOutputNominalValues(int pos) {
        return this.nominalValues[1][pos];
    }

    public int getOutputNominalValuesInt(int pos) {
        return this.intNominalValues[1][pos];
    }

    public int[] getOutputNominalValuesInt() {
        return this.intNominalValues[1];
    }

    public boolean getOutputMissingValues(int pos) {
        return this.missingValues[1][pos];
    }

    public double[] getAllInputValues() {
        return this.realValues[0];
    }

    public double[] getNormalizedInputValues() {
        double[] norm = new double[this.realValues[0].length];
        for (int i = 0; i < norm.length; ++i) {
            norm[i] = !this.missingValues[0][i] ? Attributes.getInputAttribute(i).normalizeValue(this.realValues[0][i]) : -1.0;
        }
        return norm;
    }

    public double[] getNormalizedOutputValues() {
        double[] norm = new double[this.realValues[1].length];
        for (int i = 0; i < norm.length; ++i) {
            norm[i] = !this.missingValues[1][i] ? Attributes.getOutputAttribute(i).normalizeValue(this.realValues[1][i]) : -1.0;
        }
        return norm;
    }

    public double[] getAllOutputValues() {
        return this.realValues[1];
    }

    public boolean setInputNumericValue(int pos, double value) {
        Attribute at = Attributes.getInputAttribute(pos);
        if (at.getType() == 0) {
            return false;
        }
        if (at.isInBounds(value)) {
            this.realValues[0][pos] = value;
            this.missingValues[0][pos] = false;
            this.anyMissingValue[0] = false;
            for (int i = 0; i < this.missingValues[0].length; ++i) {
                this.anyMissingValue[0] = this.anyMissingValue[0] | this.missingValues[0][i];
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean setOutputNumericValue(int pos, double value) {
        Attribute at = Attributes.getOutputAttribute(pos);
        if (at.getType() == 0) {
            return false;
        }
        if (at.isInBounds(value)) {
            this.realValues[1][pos] = value;
            this.missingValues[1][pos] = false;
            this.anyMissingValue[1] = false;
            for (int i = 0; i < this.missingValues[1].length; ++i) {
                this.anyMissingValue[1] = this.anyMissingValue[1] | this.missingValues[1][i];
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean setInputNominalValue(int pos, String value) {
        Attribute at = Attributes.getInputAttribute(pos);
        if (at.getType() != 0) {
            return false;
        }
        if (at.convertNominalValue(value) != -1) {
            this.nominalValues[0][pos] = value;
            this.intNominalValues[0][pos] = at.convertNominalValue(value);
            this.realValues[0][pos] = this.intNominalValues[0][pos];
            this.missingValues[0][pos] = false;
            this.anyMissingValue[0] = false;
            for (int i = 0; i < this.missingValues[0].length; ++i) {
                this.anyMissingValue[0] = this.anyMissingValue[0] | this.missingValues[0][i];
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean setOutputNominalValue(int pos, String value) {
        Attribute at = Attributes.getOutputAttribute(pos);
        if (at.getType() != 0) {
            return false;
        }
        if (at.convertNominalValue(value) != -1) {
            this.nominalValues[1][pos] = value;
            this.intNominalValues[1][pos] = at.convertNominalValue(value);
            this.realValues[1][pos] = this.intNominalValues[0][pos];
            this.missingValues[1][pos] = false;
            this.anyMissingValue[1] = false;
            for (int i = 0; i < this.missingValues[1].length; ++i) {
                this.anyMissingValue[1] = this.anyMissingValue[1] | this.missingValues[1][i];
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean existsAnyMissingValue() {
        return this.anyMissingValue[0] || this.anyMissingValue[1];
    }

    public boolean existsInputMissingValues() {
        return this.anyMissingValue[0];
    }

    public boolean existsOutputMissingValues() {
        return this.anyMissingValue[1];
    }

    void removeAttribute(Attribute attToDel, boolean inputAtt, int whichAtt) {
        int i;
        int newSize;
        int index = 0;
        if (!inputAtt) {
            newSize = --this.numOutputAttributes;
            index = 1;
        } else {
            newSize = --this.numInputAttributes;
        }
        ++this.numUndefinedAttributes;
        int undefPosition = Attributes.searchUndefPosition(attToDel);
        String[] nominalValuesAux = new String[newSize];
        int[] intNominalValuesAux = new int[newSize];
        double[] realValuesAux = new double[newSize];
        boolean[] missingValuesAux = new boolean[newSize];
        String[] nominalValuesUndef = new String[this.numUndefinedAttributes];
        int[] intNominalValuesUndef = new int[this.numUndefinedAttributes];
        double[] realValuesUndef = new double[this.numUndefinedAttributes];
        boolean[] missingValuesUndef = new boolean[this.numUndefinedAttributes];
        int k = 0;
        this.anyMissingValue[index] = false;
        for (i = 0; i < newSize + 1; ++i) {
            if (i != whichAtt) {
                nominalValuesAux[k] = this.nominalValues[index][i];
                intNominalValuesAux[k] = this.intNominalValues[index][i];
                realValuesAux[k] = this.realValues[index][i];
                missingValuesAux[k] = this.missingValues[index][i];
                if (missingValuesAux[k]) {
                    this.anyMissingValue[index] = true;
                }
                ++k;
                continue;
            }
            nominalValuesUndef[undefPosition] = this.nominalValues[index][i];
            intNominalValuesUndef[undefPosition] = this.intNominalValues[index][i];
            realValuesUndef[undefPosition] = this.realValues[index][i];
            missingValuesUndef[undefPosition] = this.missingValues[index][i];
        }
        k = 0;
        for (i = 0; i < this.numUndefinedAttributes; ++i) {
            if (i == undefPosition) continue;
            nominalValuesUndef[i] = this.nominalValues[2][k];
            intNominalValuesUndef[i] = this.intNominalValues[2][k];
            realValuesUndef[i] = this.realValues[2][k];
            missingValuesUndef[i] = this.missingValues[2][k];
            ++k;
        }
        this.nominalValues[index] = nominalValuesAux;
        this.intNominalValues[index] = intNominalValuesAux;
        this.realValues[index] = realValuesAux;
        this.missingValues[index] = missingValuesAux;
        this.nominalValues[2] = nominalValuesUndef;
        this.intNominalValues[2] = intNominalValuesUndef;
        this.realValues[2] = realValuesUndef;
        this.missingValues[2] = missingValuesUndef;
    }

    public String toString() {
        int i;
        String aux = "";
        String ending = ",";
        for (i = 0; i < this.numInputAttributes; ++i) {
            if (i == this.numInputAttributes - 1 && this.numOutputAttributes == 0) {
                ending = "";
            }
            switch (Attributes.getInputAttribute(i).getType()) {
                case 0: {
                    aux = aux + this.nominalValues[0][i];
                    break;
                }
                case 1: {
                    aux = aux + new Integer((int)this.realValues[0][i]).toString();
                    break;
                }
                case 2: {
                    aux = aux + new Double(this.realValues[0][i]).toString();
                }
            }
            aux = aux + ending;
        }
        ending = ",";
        for (i = 0; i < this.numOutputAttributes; ++i) {
            if (i == this.numOutputAttributes - 1) {
                ending = "";
            }
            switch (Attributes.getOutputAttribute(i).getType()) {
                case 0: {
                    aux = aux + this.nominalValues[1][i];
                    break;
                }
                case 1: {
                    aux = aux + new Integer((int)this.realValues[1][i]).toString();
                    break;
                }
                case 2: {
                    aux = aux + new Double(this.realValues[1][i]).toString();
                }
            }
            aux = aux + ending;
        }
        return aux;
    }

    public void print(InstanceAttributes instAttributes, PrintWriter out) {
        int i;
        out.print("    > Inputs: ");
        block15: for (i = 0; i < this.numInputAttributes; ++i) {
            switch (instAttributes.getInputAttribute(i).getType()) {
                case 0: {
                    out.print(this.nominalValues[0][i]);
                    continue block15;
                }
                case 1: {
                    out.print(this.realValues[0][i]);
                    continue block15;
                }
                case 2: {
                    out.print(this.realValues[0][i]);
                }
            }
        }
        out.print("\n    > Outputs: ");
        block16: for (i = 0; i < this.numOutputAttributes; ++i) {
            switch (instAttributes.getOutputAttribute(i).getType()) {
                case 0: {
                    out.print(this.nominalValues[1][i]);
                    continue block16;
                }
                case 1: {
                    out.print(this.realValues[1][i]);
                    continue block16;
                }
                case 2: {
                    out.print(this.realValues[1][i]);
                }
            }
        }
        out.print("\n    > Undefined: ");
        block17: for (i = 0; i < this.numUndefinedAttributes; ++i) {
            switch (instAttributes.getOutputAttribute(i).getType()) {
                case 0: {
                    out.print(this.nominalValues[1][i]);
                    continue block17;
                }
                case 1: {
                    out.print(this.realValues[1][i]);
                    continue block17;
                }
                case 2: {
                    out.print(this.realValues[1][i]);
                }
            }
        }
    }

    public void printAsOriginal(InstanceAttributes instAttributes, PrintWriter out) {
        int inCount = 0;
        int outCount = 0;
        int undefCount = 0;
        int numAttributes = instAttributes.getNumAttributes();
        for (int count = 0; count < numAttributes; ++count) {
            Attribute at = instAttributes.getAttribute(count);
            switch (at.getDirectionAttribute()) {
                case 1: {
                    this.printAttribute(out, 0, inCount, at.getType());
                    ++inCount;
                    break;
                }
                case 2: {
                    this.printAttribute(out, 1, outCount, at.getType());
                    ++outCount;
                    break;
                }
                case -1: {
                    this.printAttribute(out, 2, undefCount, at.getType());
                    ++undefCount;
                }
            }
            if (count + 1 >= numAttributes) continue;
            out.print(",");
        }
    }

    public void print(InstanceAttributes instAttributes) {
        int i;
        System.out.print("  > Inputs (" + this.numInputAttributes + "): ");
        for (i = 0; i < this.numInputAttributes; ++i) {
            if (this.missingValues[0][i]) {
                System.out.print("?");
            } else {
                switch (instAttributes.getInputAttribute(i).getType()) {
                    case 0: {
                        System.out.print(this.nominalValues[0][i]);
                        break;
                    }
                    case 1: {
                        System.out.print((int)this.realValues[0][i]);
                        break;
                    }
                    case 2: {
                        System.out.print(this.realValues[0][i]);
                    }
                }
            }
            System.out.print("  ");
        }
        System.out.print("  > Outputs (" + this.numOutputAttributes + "): ");
        for (i = 0; i < this.numOutputAttributes; ++i) {
            if (this.missingValues[1][i]) {
                System.out.print("?");
            } else {
                switch (instAttributes.getOutputAttribute(i).getType()) {
                    case 0: {
                        System.out.print(this.nominalValues[1][i]);
                        break;
                    }
                    case 1: {
                        System.out.print((int)this.realValues[1][i]);
                        break;
                    }
                    case 2: {
                        System.out.print(this.realValues[1][i]);
                    }
                }
            }
            System.out.print("  ");
        }
        System.out.print("  > Undefined (" + this.numUndefinedAttributes + "): ");
        for (i = 0; i < this.numUndefinedAttributes; ++i) {
            if (this.missingValues[2][i]) {
                System.out.print("?");
            } else {
                switch (instAttributes.getUndefinedAttribute(i).getType()) {
                    case 0: {
                        System.out.print(this.nominalValues[2][i]);
                        break;
                    }
                    case 1: {
                        System.out.print((int)this.realValues[2][i]);
                        break;
                    }
                    case 2: {
                        System.out.print(this.realValues[2][i]);
                    }
                }
            }
            System.out.print("  ");
        }
    }

    public double[] getNormalizedInputValues(InstanceAttributes instAttributes) {
        double[] norm = new double[this.realValues[0].length];
        for (int i = 0; i < norm.length; ++i) {
            norm[i] = !this.missingValues[0][i] ? instAttributes.getInputAttribute(i).normalizeValue(this.realValues[0][i]) : -1.0;
        }
        return norm;
    }

    public double[] getNormalizedOutputValues(InstanceAttributes instAttributes) {
        double[] norm = new double[this.realValues[1].length];
        for (int i = 0; i < norm.length; ++i) {
            norm[i] = !this.missingValues[1][i] ? instAttributes.getOutputAttribute(i).normalizeValue(this.realValues[1][i]) : -1.0;
        }
        return norm;
    }

    public boolean setInputNumericValue(InstanceAttributes instAttributes, int pos, double value) {
        Attribute at = instAttributes.getInputAttribute(pos);
        if (at.getType() == 0) {
            return false;
        }
        if (at.isInBounds(value)) {
            this.realValues[0][pos] = value;
            this.missingValues[0][pos] = false;
            this.anyMissingValue[0] = false;
            for (int i = 0; i < this.missingValues[0].length; ++i) {
                this.anyMissingValue[0] = this.anyMissingValue[0] | this.missingValues[0][i];
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean setOutputNumericValue(InstanceAttributes instAttributes, int pos, double value) {
        Attribute at = instAttributes.getOutputAttribute(pos);
        if (at.getType() == 0) {
            return false;
        }
        if (at.isInBounds(value)) {
            this.realValues[1][pos] = value;
            this.missingValues[1][pos] = false;
            this.anyMissingValue[1] = false;
            for (int i = 0; i < this.missingValues[1].length; ++i) {
                this.anyMissingValue[1] = this.anyMissingValue[1] | this.missingValues[1][i];
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean setInputNominalValue(InstanceAttributes instAttributes, int pos, String value) {
        Attribute at = instAttributes.getInputAttribute(pos);
        if (at.getType() != 0) {
            return false;
        }
        if (at.convertNominalValue(value) != -1) {
            this.nominalValues[0][pos] = value;
            this.intNominalValues[0][pos] = at.convertNominalValue(value);
            this.realValues[0][pos] = this.intNominalValues[0][pos];
            this.missingValues[0][pos] = false;
            this.anyMissingValue[0] = false;
            for (int i = 0; i < this.missingValues[0].length; ++i) {
                this.anyMissingValue[0] = this.anyMissingValue[0] | this.missingValues[0][i];
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean setOutputNominalValue(InstanceAttributes instAttributes, int pos, String value) {
        Attribute at = instAttributes.getOutputAttribute(pos);
        if (at.getType() != 0) {
            return false;
        }
        if (at.convertNominalValue(value) != -1) {
            this.nominalValues[1][pos] = value;
            this.intNominalValues[1][pos] = at.convertNominalValue(value);
            this.realValues[1][pos] = this.intNominalValues[0][pos];
            this.missingValues[1][pos] = false;
            this.anyMissingValue[1] = false;
            for (int i = 0; i < this.missingValues[1].length; ++i) {
                this.anyMissingValue[1] = this.anyMissingValue[1] | this.missingValues[1][i];
            }
        } else {
            return false;
        }
        return true;
    }

    void removeAttribute(InstanceAttributes instAttributes, Attribute attToDel, boolean inputAtt, int whichAtt) {
        int i;
        int newSize;
        int index = 0;
        if (!inputAtt) {
            newSize = --this.numOutputAttributes;
            index = 1;
        } else {
            newSize = --this.numInputAttributes;
        }
        ++this.numUndefinedAttributes;
        int undefPosition = instAttributes.searchUndefPosition(attToDel);
        String[] nominalValuesAux = new String[newSize];
        int[] intNominalValuesAux = new int[newSize];
        double[] realValuesAux = new double[newSize];
        boolean[] missingValuesAux = new boolean[newSize];
        String[] nominalValuesUndef = new String[this.numUndefinedAttributes];
        int[] intNominalValuesUndef = new int[this.numUndefinedAttributes];
        double[] realValuesUndef = new double[this.numUndefinedAttributes];
        boolean[] missingValuesUndef = new boolean[this.numUndefinedAttributes];
        int k = 0;
        this.anyMissingValue[index] = false;
        for (i = 0; i < newSize + 1; ++i) {
            if (i != whichAtt) {
                nominalValuesAux[k] = this.nominalValues[index][i];
                intNominalValuesAux[k] = this.intNominalValues[index][i];
                realValuesAux[k] = this.realValues[index][i];
                missingValuesAux[k] = this.missingValues[index][i];
                if (missingValuesAux[k]) {
                    this.anyMissingValue[index] = true;
                }
                ++k;
                continue;
            }
            nominalValuesUndef[undefPosition] = this.nominalValues[index][i];
            intNominalValuesUndef[undefPosition] = this.intNominalValues[index][i];
            realValuesUndef[undefPosition] = this.realValues[index][i];
            missingValuesUndef[undefPosition] = this.missingValues[index][i];
        }
        k = 0;
        for (i = 0; i < this.numUndefinedAttributes; ++i) {
            if (i == undefPosition) continue;
            nominalValuesUndef[i] = this.nominalValues[2][k];
            intNominalValuesUndef[i] = this.intNominalValues[2][k];
            realValuesUndef[i] = this.realValues[2][k];
            missingValuesUndef[i] = this.missingValues[2][k];
            ++k;
        }
        this.nominalValues[index] = nominalValuesAux;
        this.intNominalValues[index] = intNominalValuesAux;
        this.realValues[index] = realValuesAux;
        this.missingValues[index] = missingValuesAux;
        this.nominalValues[2] = nominalValuesUndef;
        this.intNominalValues[2] = intNominalValuesUndef;
        this.realValues[2] = realValuesUndef;
        this.missingValues[2] = missingValuesUndef;
    }

    public String toString(InstanceAttributes instAttributes) {
        int i;
        String aux = "";
        String ending = ",";
        for (i = 0; i < this.numInputAttributes; ++i) {
            if (i == this.numInputAttributes - 1 && this.numOutputAttributes == 0) {
                ending = "";
            }
            switch (instAttributes.getInputAttribute(i).getType()) {
                case 0: {
                    aux = aux + this.nominalValues[0][i];
                    break;
                }
                case 1: {
                    aux = aux + new Integer((int)this.realValues[0][i]).toString();
                    break;
                }
                case 2: {
                    aux = aux + new Double(this.realValues[0][i]).toString();
                }
            }
            aux = aux + ending;
        }
        ending = ",";
        for (i = 0; i < this.numOutputAttributes; ++i) {
            if (i == this.numOutputAttributes - 1) {
                ending = "";
            }
            switch (instAttributes.getOutputAttribute(i).getType()) {
                case 0: {
                    aux = aux + this.nominalValues[1][i];
                    break;
                }
                case 1: {
                    aux = aux + new Integer((int)this.realValues[1][i]).toString();
                    break;
                }
                case 2: {
                    aux = aux + new Double(this.realValues[1][i]).toString();
                }
            }
            aux = aux + ending;
        }
        return aux;
    }
}

