/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Instance_Based_Learning.FuzzyKNN;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.FuzzyIBLAlgorithm;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.ReportTool;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.Timer;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.Util;
import org.core.Files;

public class FuzzyKNN
extends FuzzyIBLAlgorithm {
    private static final double MAX_NORM = 1.0E8;
    private int K;
    private double M;
    private int k;
    private double[][] membership;
    private double[][] referenceMembership;
    private double[][] testMembership;
    private int initialization;
    private static final int CRISP = 1;
    private static final int CLASS_MEAN = 2;
    private static final int KNN = 3;

    @Override
    protected void readParameters(String script) {
        String file = Files.readFile(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
        String line = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.K = Integer.parseInt(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.M = Double.parseDouble(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        String type = tokens.nextToken().substring(1);
        this.initialization = 1;
        if (type.equalsIgnoreCase("CLASS-MEAN")) {
            this.initialization = 2;
        }
        if (type.equalsIgnoreCase("KNN")) {
            this.initialization = 3;
            line = fileLines.nextToken();
            tokens = new StringTokenizer(line, "=");
            tokens.nextToken();
            this.k = Integer.parseInt(tokens.nextToken().substring(1));
        }
    }

    public FuzzyKNN(String script) {
        this.readDataFiles(script);
        this.name = "FuzzyKNN";
        this.membership = new double[this.trainData.length][this.nClasses];
        for (int i = 0; i < this.trainData.length; ++i) {
            Arrays.fill(this.membership[i], -1.0);
        }
        this.referenceMembership = new double[this.referenceData.length][this.nClasses];
        this.testMembership = new double[this.testData.length][this.nClasses];
        ReportTool.setOutputFile(this.outFile[2]);
    }

    public void generateModel() {
        Timer.resetTime();
        this.assignMembership();
        Timer.setModelTime();
        System.out.println(this.name + " " + this.relation + " Model " + Timer.getModelTime() + "s");
    }

    private void assignMembership() {
        switch (this.initialization) {
            case 2: {
                int j;
                int i;
                double[][] meanInstances = new double[this.nClasses][this.inputAtt];
                for (i = 0; i < this.nClasses; ++i) {
                    Arrays.fill(meanInstances[i], 0.0);
                }
                for (i = 0; i < this.trainData.length; ++i) {
                    for (j = 0; j < this.trainData[0].length; ++j) {
                        double[] dArray = meanInstances[this.trainOutput[i]];
                        int n = j;
                        dArray[n] = dArray[n] + this.trainData[i][j];
                    }
                }
                for (i = 0; i < this.nClasses; ++i) {
                    for (j = 0; j < this.trainData[0].length; ++j) {
                        if (this.nInstances[i] <= 0) continue;
                        double[] dArray = meanInstances[i];
                        int n = j;
                        dArray[n] = dArray[n] / (double)this.nInstances[i];
                    }
                }
                double[] distan = new double[this.nClasses];
                for (int i2 = 0; i2 < this.trainData.length; ++i2) {
                    int j2;
                    double sum = 0.0;
                    for (j2 = 0; j2 < this.nClasses; ++j2) {
                        distan[j2] = Util.euclideanDistance(this.trainData[i2], meanInstances[j2]);
                        sum += distan[j2];
                    }
                    double sum2 = 0.0;
                    for (j2 = 0; j2 < this.nClasses; ++j2) {
                        if (this.nInstances[j2] > 0) {
                            this.membership[i2][j2] = 1.0 - distan[j2] / sum;
                            sum2 += this.membership[i2][j2];
                            continue;
                        }
                        this.membership[i2][j2] = 0.0;
                    }
                    j2 = 0;
                    while (j2 < this.nClasses) {
                        double[] dArray = this.membership[i2];
                        int n = j2++;
                        dArray[n] = dArray[n] / sum2;
                    }
                }
                break;
            }
            case 3: {
                for (int instance = 0; instance < this.trainData.length; ++instance) {
                    int i;
                    int[] nearestN = new int[this.k];
                    double[] minDist = new double[this.k];
                    for (i = 0; i < this.k; ++i) {
                        nearestN[i] = 0;
                        minDist[i] = Double.MAX_VALUE;
                    }
                    for (i = 0; i < this.trainData.length; ++i) {
                        double dist = Util.euclideanDistance(this.trainData[i], this.trainData[instance]);
                        if (i == instance) continue;
                        boolean stop = false;
                        for (int j = 0; j < this.k && !stop; ++j) {
                            if (!(dist < minDist[j])) continue;
                            for (int l = this.k - 1; l >= j + 1; --l) {
                                minDist[l] = minDist[l - 1];
                                nearestN[l] = nearestN[l - 1];
                            }
                            minDist[j] = dist;
                            nearestN[j] = i;
                            stop = true;
                        }
                    }
                    int[] selectedClasses = new int[this.nClasses];
                    Arrays.fill(selectedClasses, 0);
                    for (i = 0; i < this.k; ++i) {
                        int n = this.trainOutput[nearestN[i]];
                        selectedClasses[n] = selectedClasses[n] + 1;
                    }
                    Arrays.fill(this.membership[instance], 0.0);
                    for (int i3 = 0; i3 < this.nClasses; ++i3) {
                        double term = (double)selectedClasses[i3] / (double)this.k;
                        this.membership[instance][i3] = this.trainOutput[instance] == i3 ? 0.51 + 0.49 * term : 0.49 * term;
                    }
                }
                break;
            }
            default: {
                for (int i = 0; i < this.trainData.length; ++i) {
                    Arrays.fill(this.membership[i], 0.0);
                    this.membership[i][this.trainOutput[i]] = 1.0;
                }
            }
        }
    }

    public void classifyTrain() {
        Timer.resetTime();
        this.classifyTrainSet();
        Timer.setTrainingTime();
        System.out.println(this.name + " " + this.relation + " Training " + Timer.getTrainingTime() + "s");
    }

    public void classifyTest() {
        Timer.resetTime();
        this.classifyTestSet();
        Timer.setTestTime();
        System.out.println(this.name + " " + this.relation + " Test " + Timer.getTestTime() + "s");
    }

    public void classifyTrainSet() {
        for (int i = 0; i < this.trainData.length; ++i) {
            this.computeTrainMembership(i, this.referenceData[i]);
            this.trainPrediction[i] = this.computeClass(this.referenceMembership[i]);
        }
    }

    public void classifyTestSet() {
        for (int i = 0; i < this.testData.length; ++i) {
            this.computeTestMembership(i, this.testData[i]);
            this.testPrediction[i] = this.computeClass(this.testMembership[i]);
        }
    }

    private int computeClass(double[] pertenence) {
        double max = Double.MIN_VALUE;
        int output = -1;
        for (int i = 0; i < pertenence.length; ++i) {
            if (!(max < pertenence[i])) continue;
            max = pertenence[i];
            output = i;
        }
        return output;
    }

    private void computeTrainMembership(int index, double[] example) {
        int i;
        int i2;
        int[] nearestN = new int[this.K];
        double[] minDist = new double[this.K];
        for (i2 = 0; i2 < this.K; ++i2) {
            nearestN[i2] = 0;
            minDist[i2] = Double.MAX_VALUE;
        }
        for (i2 = 0; i2 < this.trainData.length; ++i2) {
            if (i2 == index) continue;
            double dist = Util.euclideanDistance(this.trainData[i2], example);
            boolean stop = false;
            for (int j = 0; j < this.K && !stop; ++j) {
                if (!(dist < minDist[j])) continue;
                for (int l = this.K - 1; l >= j + 1; --l) {
                    minDist[l] = minDist[l - 1];
                    nearestN[l] = nearestN[l - 1];
                }
                minDist[j] = dist;
                nearestN[j] = i2;
                stop = true;
            }
        }
        double[] norm = new double[this.K];
        double sum = 0.0;
        for (i = 0; i < this.K; ++i) {
            if (minDist[i] == 0.0) {
                norm[i] = 1.0E8;
            }
            norm[i] = 1.0 / Math.pow(minDist[i], 2.0 / (this.M - 1.0));
            norm[i] = Math.min(norm[i], 1.0E8);
            sum += norm[i];
        }
        for (i = 0; i < this.K; ++i) {
            for (int c = 0; c < this.nClasses; ++c) {
                double[] dArray = this.referenceMembership[index];
                int n = c;
                dArray[n] = dArray[n] + this.membership[nearestN[i]][c] * (norm[i] / sum);
            }
        }
    }

    private void computeTestMembership(int index, double[] example) {
        int i;
        int i2;
        int[] nearestN = new int[this.K];
        double[] minDist = new double[this.K];
        for (i2 = 0; i2 < this.K; ++i2) {
            nearestN[i2] = 0;
            minDist[i2] = Double.MAX_VALUE;
        }
        for (i2 = 0; i2 < this.trainData.length; ++i2) {
            double dist = Util.euclideanDistance(this.trainData[i2], example);
            boolean stop = false;
            for (int j = 0; j < this.K && !stop; ++j) {
                if (!(dist < minDist[j])) continue;
                for (int l = this.K - 1; l >= j + 1; --l) {
                    minDist[l] = minDist[l - 1];
                    nearestN[l] = nearestN[l - 1];
                }
                minDist[j] = dist;
                nearestN[j] = i2;
                stop = true;
            }
        }
        double[] norm = new double[this.K];
        double sum = 0.0;
        for (i = 0; i < this.K; ++i) {
            if (minDist[i] == 0.0) {
                norm[i] = 1.0E8;
            }
            norm[i] = 1.0 / Math.pow(minDist[i], 2.0 / (this.M - 1.0));
            norm[i] = Math.min(norm[i], 1.0E8);
            sum += norm[i];
        }
        for (i = 0; i < this.K; ++i) {
            for (int c = 0; c < this.nClasses; ++c) {
                double[] dArray = this.testMembership[index];
                int n = c;
                dArray[n] = dArray[n] + this.membership[nearestN[i]][c] * (norm[i] / sum);
            }
        }
    }

    public void printReport() {
        this.writeOutput(this.outFile[0], this.trainOutput, this.trainPrediction);
        this.writeOutput(this.outFile[1], this.testOutput, this.testPrediction);
        ReportTool.setResults(this.trainOutput, this.trainPrediction, this.testOutput, this.testPrediction, this.nClasses);
        ReportTool.printReport();
    }
}

