/*
 * Decompiled with CFR 0.152.
 */
package keel.Dataset;

import java.util.Vector;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;

public final class InstanceAttributes {
    private Vector attributes;
    private Vector inputAttr;
    private Vector outputAttr;
    private Vector undefinedAttr;
    private boolean hasNominal;
    private boolean hasInteger;
    private boolean hasReal;
    private String relationName;

    public InstanceAttributes() {
        this.attributes = new Vector();
        this.inputAttr = new Vector();
        this.outputAttr = new Vector();
        this.undefinedAttr = new Vector();
        this.hasNominal = false;
        this.hasInteger = false;
        this.hasReal = false;
        String relationName = new String("");
    }

    public InstanceAttributes(InstanceAttributes ia) {
        this.attributes = new Vector(ia.attributes);
        this.inputAttr = new Vector(ia.inputAttr);
        this.outputAttr = new Vector(ia.outputAttr);
        this.undefinedAttr = new Vector(ia.undefinedAttr);
        this.hasInteger = ia.hasInteger;
        this.hasNominal = ia.hasNominal;
        this.hasReal = ia.hasReal;
        this.relationName = new String(ia.relationName);
    }

    public void copyStaticAttributes() {
        int i;
        this.attributes = new Vector();
        this.inputAttr = new Vector();
        this.outputAttr = new Vector();
        this.undefinedAttr = new Vector();
        for (i = 0; i < Attributes.attributes.size(); ++i) {
            this.attributes.add(Attributes.attributes.elementAt(i));
        }
        for (i = 0; i < Attributes.inputAttr.size(); ++i) {
            this.inputAttr.add(Attributes.inputAttr.elementAt(i));
        }
        for (i = 0; i < Attributes.outputAttr.size(); ++i) {
            this.outputAttr.add(Attributes.outputAttr.elementAt(i));
        }
        for (i = 0; i < Attributes.undefinedAttr.size(); ++i) {
            this.undefinedAttr.add(Attributes.undefinedAttr.elementAt(i));
        }
        this.hasNominal = Attributes.hasNominal;
        this.hasInteger = Attributes.hasInteger;
        this.hasReal = Attributes.hasReal;
        this.relationName = Attributes.relationName;
    }

    public void addAttribute(Attribute attr) {
        this.attributes.addElement(attr);
        if (attr.getDirectionAttribute() == 1) {
            this.inputAttr.add(attr);
        }
        if (attr.getDirectionAttribute() == 2) {
            this.outputAttr.add(attr);
        }
        if (attr.getDirectionAttribute() == -1) {
            this.undefinedAttr.add(attr);
        }
        if (attr.getType() == 0) {
            this.hasNominal = true;
        }
        if (attr.getType() == 1) {
            this.hasInteger = true;
        }
        if (attr.getType() == 2) {
            this.hasReal = true;
        }
    }

    public boolean hasNominalAttributes() {
        return this.hasNominal;
    }

    public boolean hasIntegerAttributes() {
        return this.hasInteger;
    }

    public boolean hasRealAttributes() {
        return this.hasReal;
    }

    public Attribute getAttribute(String _name) {
        int i;
        for (i = 0; i < this.attributes.size() && !((Attribute)this.attributes.elementAt(i)).getName().equals(_name); ++i) {
        }
        if (i == this.attributes.size()) {
            return null;
        }
        return (Attribute)this.attributes.elementAt(i);
    }

    public Attribute[] getAttributes() {
        if (this.attributes.size() == 0) {
            return null;
        }
        Attribute[] attr = new Attribute[this.attributes.size()];
        for (int i = 0; i < attr.length; ++i) {
            attr[i] = (Attribute)this.attributes.elementAt(i);
        }
        return attr;
    }

    public Attribute getInputAttribute(int pos) {
        if (pos < 0 || pos >= this.inputAttr.size()) {
            return null;
        }
        return (Attribute)this.inputAttr.elementAt(pos);
    }

    public Attribute[] getInputAttributes() {
        if (this.inputAttr.size() == 0) {
            return null;
        }
        Attribute[] attr = new Attribute[this.inputAttr.size()];
        for (int i = 0; i < attr.length; ++i) {
            attr[i] = (Attribute)this.inputAttr.elementAt(i);
        }
        return attr;
    }

    public String getInputHeader() {
        String aux = "@inputs ";
        String ending = ",";
        for (int i = 0; i < this.inputAttr.size(); ++i) {
            if (i == this.inputAttr.size() - 1) {
                ending = "";
            }
            aux = aux + ((Attribute)this.inputAttr.elementAt(i)).getName() + ending;
        }
        return aux;
    }

    public String getInputAttributesHeader() {
        String aux = "";
        for (int i = 0; i < this.inputAttr.size(); ++i) {
            aux = aux + ((Attribute)this.inputAttr.elementAt(i)).toString() + "\n";
        }
        return aux;
    }

    public Attribute[] getOutputAttributes() {
        if (this.outputAttr.size() == 0) {
            return null;
        }
        Attribute[] attr = new Attribute[this.outputAttr.size()];
        for (int i = 0; i < attr.length; ++i) {
            attr[i] = (Attribute)this.outputAttr.elementAt(i);
        }
        return attr;
    }

    public Attribute getOutputAttribute(int pos) {
        if (pos < 0 || pos >= this.outputAttr.size()) {
            return null;
        }
        return (Attribute)this.outputAttr.elementAt(pos);
    }

    public String getOutputHeader() {
        String aux = "@outputs ";
        String ending = ",";
        for (int i = 0; i < this.outputAttr.size(); ++i) {
            if (i == this.outputAttr.size() - 1) {
                ending = "";
            }
            aux = aux + ((Attribute)this.outputAttr.elementAt(i)).getName() + ending;
        }
        return aux;
    }

    public String getOutputAttributesHeader() {
        String aux = "";
        for (int i = 0; i < this.outputAttr.size(); ++i) {
            aux = aux + ((Attribute)this.outputAttr.elementAt(i)).toString() + "\n";
        }
        return aux;
    }

    public Attribute getUndefinedAttribute(int pos) {
        if (pos < 0 || pos >= this.undefinedAttr.size()) {
            return null;
        }
        return (Attribute)this.undefinedAttr.elementAt(pos);
    }

    public Attribute[] getUndefinedAttributes() {
        if (this.undefinedAttr.size() == 0) {
            return null;
        }
        Attribute[] attr = new Attribute[this.undefinedAttr.size()];
        for (int i = 0; i < attr.length; ++i) {
            attr[i] = (Attribute)this.undefinedAttr.elementAt(i);
        }
        return attr;
    }

    public String getUndefinedAttributesHeader() {
        String aux = "";
        for (int i = 0; i < this.undefinedAttr.size(); ++i) {
            aux = aux + ((Attribute)this.undefinedAttr.elementAt(i)).toString() + "\n";
        }
        return aux;
    }

    public Attribute getAttribute(int pos) {
        return (Attribute)this.attributes.elementAt(pos);
    }

    public int getNumAttributes() {
        return this.attributes.size();
    }

    public int getInputNumAttributes() {
        return this.inputAttr.size();
    }

    public int getOutputNumAttributes() {
        return this.outputAttr.size();
    }

    public int getUndefinedNumAttributes() {
        return this.undefinedAttr.size();
    }

    Vector getAttributesExcept(Vector v) {
        Vector<String> restAt = new Vector<String>();
        for (int i = 0; i < this.attributes.size(); ++i) {
            String attName = ((Attribute)this.attributes.get(i)).getName();
            if (v.contains(attName)) continue;
            restAt.add(attName);
        }
        return restAt;
    }

    void setOutputInputAttributes(Vector inAttNames, Vector outAttNames) {
        Attribute att;
        int i;
        for (i = 0; i < this.attributes.size(); ++i) {
            att = (Attribute)this.attributes.get(i);
            String attName = att.getName();
            if (inAttNames.contains(attName)) {
                att.setDirectionAttribute(1);
                this.inputAttr.add(this.attributes.get(i));
                continue;
            }
            if (outAttNames.contains(attName)) {
                att.setDirectionAttribute(2);
                this.outputAttr.add(this.attributes.get(i));
                continue;
            }
            this.undefinedAttr.add(this.attributes.get(i));
        }
        this.hasNominal = false;
        this.hasInteger = false;
        this.hasReal = false;
        for (int index = 0; index < 2; ++index) {
            int iterations = index == 0 ? this.inputAttr.size() : this.outputAttr.size();
            block7: for (i = 0; i < iterations; ++i) {
                att = index == 0 ? (Attribute)this.inputAttr.elementAt(i) : (Attribute)this.outputAttr.elementAt(i);
                switch (att.getType()) {
                    case 0: {
                        this.hasNominal = true;
                        continue block7;
                    }
                    case 1: {
                        this.hasInteger = true;
                        continue block7;
                    }
                    case 2: {
                        this.hasReal = true;
                    }
                }
            }
        }
    }

    boolean areAllDefinedAsInputs(Vector inputNames) {
        if (inputNames.size() != this.inputAttr.size()) {
            return false;
        }
        for (int i = 0; i < this.inputAttr.size(); ++i) {
            if (inputNames.contains(((Attribute)this.inputAttr.elementAt(i)).getName())) continue;
            return false;
        }
        return true;
    }

    public boolean areAllDefinedAsOutputs(Vector outputNames) {
        if (outputNames.size() != this.outputAttr.size()) {
            return false;
        }
        for (int i = 0; i < this.outputAttr.size(); ++i) {
            if (outputNames.contains(((Attribute)this.outputAttr.elementAt(i)).getName())) continue;
            return false;
        }
        return true;
    }

    public void setRelationName(String rel) {
        this.relationName = rel;
    }

    public String getRelationName() {
        return this.relationName;
    }

    public boolean removeAttribute(boolean inputAtt, int whichAtt) {
        Attribute atToDel = null;
        if (inputAtt && (whichAtt >= this.inputAttr.size() || whichAtt < 0)) {
            return false;
        }
        if (!(inputAtt || whichAtt < this.outputAttr.size() && whichAtt >= 0)) {
            return false;
        }
        if (inputAtt) {
            atToDel = (Attribute)this.inputAttr.elementAt(whichAtt);
            atToDel.setDirectionAttribute(-1);
            this.inputAttr.removeElementAt(whichAtt);
        } else {
            atToDel = (Attribute)this.outputAttr.elementAt(whichAtt);
            atToDel.setDirectionAttribute(-1);
            this.outputAttr.removeElementAt(whichAtt);
        }
        int undefPosition = this.searchUndefPosition(atToDel);
        this.undefinedAttr.insertElementAt(atToDel, undefPosition);
        this.hasNominal = false;
        this.hasInteger = false;
        this.hasReal = false;
        for (int index = 0; index < 2; ++index) {
            int iterations = index == 0 ? this.inputAttr.size() : this.outputAttr.size();
            block6: for (int i = 0; i < iterations; ++i) {
                Attribute att = index == 0 ? (Attribute)this.inputAttr.elementAt(i) : (Attribute)this.outputAttr.elementAt(i);
                switch (att.getType()) {
                    case 0: {
                        this.hasNominal = true;
                        continue block6;
                    }
                    case 1: {
                        this.hasInteger = true;
                        continue block6;
                    }
                    case 2: {
                        this.hasReal = true;
                    }
                }
            }
        }
        return true;
    }

    int searchUndefPosition(Attribute attToDel) {
        int undefCount = 0;
        int count = 0;
        Attribute att_aux = (Attribute)this.attributes.elementAt(count);
        while (attToDel != att_aux) {
            if (att_aux.getDirectionAttribute() == -1) {
                ++undefCount;
            }
            att_aux = (Attribute)this.attributes.elementAt(++count);
        }
        return undefCount;
    }

    void initStatistics() {
        if (this.outputAttr.size() != 1) {
            return;
        }
        int classNumber = ((Attribute)this.outputAttr.elementAt(0)).getNumNominalValues();
        if (classNumber <= 0) {
            return;
        }
        for (int i = 0; i < this.inputAttr.size(); ++i) {
            ((Attribute)this.inputAttr.elementAt(i)).initStatistics(classNumber);
        }
    }

    void finishStatistics() {
        if (this.outputAttr.size() != 1) {
            return;
        }
        for (int i = 0; i < this.inputAttr.size(); ++i) {
            ((Attribute)this.inputAttr.elementAt(i)).finishStatistics();
        }
    }

    void print() {
        System.out.println("@relation = " + this.relationName);
        System.out.println("Number of attributes: " + this.attributes.size());
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute att = (Attribute)this.attributes.elementAt(i);
            if (att.getDirectionAttribute() == 1) {
                System.out.println("  > INPUT ATTRIBUTE:     ");
            } else if (att.getDirectionAttribute() == 2) {
                System.out.println("  > OUTPUT ATTRIBUTE:    ");
            } else {
                System.out.println("  > UNDEFINED ATTRIBUTE: ");
            }
            att.print();
        }
    }
}

