/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD;

import java.util.ArrayList;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.Item;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.myDataset;

public class Itemset {
    ArrayList<Item> itemset;
    int clas;
    double support;
    double supportRule;

    public Itemset() {
    }

    public Itemset(int clas) {
        this.itemset = new ArrayList();
        this.clas = clas;
        this.support = 0.0;
        this.supportRule = 0.0;
    }

    public Itemset clone() {
        Itemset d = new Itemset(this.clas);
        for (int i = 0; i < this.itemset.size(); ++i) {
            d.add(this.itemset.get(i).clone());
        }
        d.clas = this.clas;
        d.support = this.support;
        d.supportRule = this.supportRule;
        return d;
    }

    public void add(Item item) {
        this.itemset.add(item);
    }

    public Item get(int pos) {
        return this.itemset.get(pos);
    }

    public Item remove(int pos) {
        return this.itemset.remove(pos);
    }

    public int size() {
        return this.itemset.size();
    }

    public double getSupport() {
        return this.support;
    }

    public double getSupportClass() {
        return this.supportRule;
    }

    public int getClas() {
        return this.clas;
    }

    public void setClas(int clas) {
        this.clas = clas;
    }

    public boolean isEqual(Itemset a) {
        if (this.itemset.size() != a.size()) {
            return false;
        }
        if (this.clas != a.getClas()) {
            return false;
        }
        for (int i = 0; i < this.itemset.size(); ++i) {
            Item item = this.itemset.get(i);
            if (item.isEqual(a.get(i))) continue;
            return false;
        }
        return true;
    }

    public void calculateSupports(DataBase dataBase, myDataset train) {
        this.support = 0.0;
        this.supportRule = 0.0;
        for (int i = 0; i < train.size(); ++i) {
            double degree = this.degree(dataBase, train.getExample(i));
            this.support += degree;
            if (train.getOutputAsInteger(i) != this.clas) continue;
            this.supportRule += degree;
        }
        this.support /= (double)train.getnData();
        this.supportRule /= (double)train.getnData();
    }

    public double degree(DataBase dataBase, double[] ejemplo) {
        return this.degreeProduct(dataBase, ejemplo);
    }

    private double degreeProduct(DataBase dataBase, double[] example) {
        Item item;
        double degree = 1.0;
        for (int i = 0; i < this.itemset.size() && degree > 0.0; degree *= dataBase.matching(item.getVariable(), item.getValue(), example[item.getVariable()]), ++i) {
            item = this.itemset.get(i);
        }
        return degree;
    }
}

