/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Prism;

import keel.Algorithms.Rule_Learning.Prism.Complejo;
import keel.Algorithms.Rule_Learning.Prism.ConjDatos;
import keel.Algorithms.Rule_Learning.Prism.ConjReglas;
import keel.Algorithms.Rule_Learning.Prism.Muestra;

public class EvaluaCalidadReglas {
    private int nClases;
    private int nDatos;
    private int[] contClases;
    private int tam;
    private double ant;
    private double cob;
    private double compl;
    private double rel;
    private double ati;
    private double porcAciertoTr;
    private double porcAciertoTst;
    private double muestCubiertas;
    private ConjDatos train;
    private ConjDatos test;
    private ConjReglas reglas;
    private String[] valorNombreClases;

    public EvaluaCalidadReglas(ConjReglas conjreg, ConjDatos conjTrn, ConjDatos conjTst, int[] muestPorClaseTrain, int[] muestPorClaseTest, String[] valorNombreClases) {
        this.reglas = conjreg;
        this.valorNombreClases = valorNombreClases;
        this.train = conjTrn.copiaConjDatos();
        this.test = conjTst.copiaConjDatos();
        this.nClases = conjreg.getUltimaRegla().getNClases();
        this.nDatos = conjTrn.size();
        this.calculaIndices(this.train, muestPorClaseTrain, 0);
        System.out.print("\n\nTrain Statistics: ");
        System.out.print("\n\n Size of the rule set: " + this.tam + "\nAverage number of attributes per rule: " + this.ant + "\nCoverage: " + this.cob);
        System.out.print("\nSupport: " + this.compl);
        System.out.print("\nRelevance: " + this.rel + "\nUnusualness: " + this.ati);
        System.out.print("\nAccuracy: " + this.porcAciertoTr);
        this.calculaIndices(this.test, muestPorClaseTest, 1);
        System.out.print("\n\nTest Statistics:");
        System.out.print("\n\n Size of the rule set: " + this.tam + "\nAverage number of attributes per rule: " + this.ant + "\nCoverage: " + this.cob);
        System.out.print("\nSupport: " + this.compl);
        System.out.print("\nRelevance: " + this.rel + "\nUnusualness: " + this.ati);
        System.out.print("\nAccuracy: " + this.porcAciertoTst);
    }

    public String printString() {
        String cad = "####Average results for test data####\n";
        cad = cad + "Avg. Rule length: " + this.tam + "\n";
        cad = cad + "Avg. Number of attributes by rule: " + this.ant + "\n";
        cad = cad + "Avg. Coverage: " + this.cob + "\n";
        cad = cad + "Avg. Support: " + this.compl + "\n";
        cad = cad + "Avg. Significance: " + this.rel + "\n";
        cad = cad + "Avg. Unusualness: " + this.ati + "\n\n";
        cad = cad + "Accuracy Training: " + this.porcAciertoTr + "\n";
        cad = cad + "Accuracy Test: " + this.porcAciertoTst;
        return cad;
    }

    private void calculaIndices(ConjDatos datos, int[] muestPorClase, int code) {
        int j;
        int i;
        this.nDatos = datos.size();
        this.contClases = new int[this.nClases];
        for (i = 0; i < this.nClases; ++i) {
            this.contClases[i] = muestPorClase[i];
        }
        this.tam = this.reglas.size();
        this.ant = 0.0;
        for (i = 0; i < this.reglas.size(); ++i) {
            this.ant += (double)this.reglas.getRegla(i).size();
        }
        this.ant /= (double)this.tam;
        this.muestCubiertas = 0.0;
        int muestBienCubiertas = 0;
        int[][] instCubiertas = new int[this.tam][this.nClases];
        for (j = 0; j < this.nDatos; ++j) {
            datos.getDato(j).setCubierta(0);
        }
        for (i = 0; i < this.reglas.size(); ++i) {
            for (j = 0; j < this.nClases; ++j) {
                instCubiertas[i][j] = 0;
            }
        }
        this.muestCubiertas = 0.0;
        for (i = 0; i < this.reglas.size(); ++i) {
            for (j = 0; j < this.nDatos; ++j) {
                Muestra m = datos.getDato(j);
                if (!this.reglas.getRegla(i).cubre(m)) continue;
                this.muestCubiertas += 1.0;
                int[] nArray = instCubiertas[i];
                int n = m.getClase();
                nArray[n] = nArray[n] + 1;
                if (this.reglas.getRegla(i).getClase() != m.getClase() || m.getCubierta() != 0) continue;
                ++muestBienCubiertas;
                m.incrementaCubierta();
            }
        }
        this.cob = this.muestCubiertas / (double)(this.tam * this.nDatos);
        this.compl = (double)muestBienCubiertas / (double)this.nDatos;
        double sigParcial = 0.0;
        double[] pCondi = new double[this.reglas.size()];
        i = 0;
        while (i < this.reglas.size()) {
            pCondi[i] = 0.0;
            for (j = 0; j < this.nClases; ++j) {
                int n = i;
                pCondi[n] = pCondi[n] + (double)instCubiertas[i][j];
            }
            int n = i++;
            pCondi[n] = pCondi[n] * (1.0 / (double)this.nDatos);
        }
        this.rel = 0.0;
        for (i = 0; i < this.reglas.size(); ++i) {
            sigParcial = 0.0;
            for (j = 0; j < this.nClases; ++j) {
                double logaritmo = (double)instCubiertas[i][j] / ((double)this.contClases[j] * pCondi[i]);
                if (logaritmo == 0.0 || Double.isNaN(logaritmo) || Double.isInfinite(logaritmo)) continue;
                logaritmo = Math.log(logaritmo);
                sigParcial += (logaritmo *= (double)instCubiertas[i][j]);
            }
            this.rel += sigParcial * 2.0;
        }
        this.rel /= (double)this.reglas.size();
        double aux = 0.0;
        for (i = 0; i < this.reglas.size(); ++i) {
            int cl = this.reglas.getRegla(i).getClase();
            double ncondi = 0.0;
            for (j = 0; j < this.nClases; ++j) {
                ncondi += (double)this.reglas.getRegla(i).getDistribucionClase(j);
            }
            double pcond = ncondi / (double)this.nDatos;
            double pclase = (double)this.contClases[cl] / (double)this.nDatos;
            double pcondclase = this.reglas.getRegla(i).getDistribucionClase(cl) / this.nDatos;
            aux += pcond * (pcondclase - pclase);
        }
        this.ati = aux / (double)this.reglas.size();
        int[] voto = new int[this.nClases];
        int aciertos = 0;
        int[] clases = this.contClases;
        int clasePorDefecto = 0;
        int clase = -1;
        for (i = 0; i < this.nClases; ++i) {
            if (clases[i] <= clase) continue;
            clasePorDefecto = i;
            clase = clases[i];
        }
        for (i = 0; i < datos.size(); ++i) {
            for (j = 0; j < this.nClases; ++j) {
                voto[j] = 0;
            }
            for (j = 0; j < this.reglas.size(); ++j) {
                if (!this.reglas.getRegla(j).cubre(datos.getDato(i))) continue;
                int[] distribucion = this.reglas.getRegla(j).getDistribucion();
                for (int k = 0; k < this.nClases; ++k) {
                    int n = k;
                    voto[n] = voto[n] + distribucion[k];
                }
            }
            int max = 0;
            int cl = 0;
            for (j = 0; j < this.nClases; ++j) {
                if (voto[j] <= max) continue;
                max = voto[j];
                cl = j;
            }
            if (max == 0) {
                cl = clasePorDefecto;
            }
            if (cl != datos.getDato(i).getClase()) continue;
            ++aciertos;
        }
        System.out.print("\n\n Accuracy: " + (double)aciertos / (double)datos.size() + " ... total data: " + datos.size());
        if (code == 0) {
            this.porcAciertoTr = (double)aciertos / (double)datos.size();
        } else {
            this.porcAciertoTst = (double)aciertos / (double)datos.size();
        }
    }

    public String salida(ConjDatos datos) {
        int i;
        String cadena = new String("");
        int[] voto = new int[this.nClases];
        int[] clases = new int[this.nClases];
        int clasePorDefecto = 0;
        for (i = 0; i < datos.size(); ++i) {
            int n = datos.getDato(i).getClase();
            clases[n] = clases[n] + 1;
        }
        int clase = -1;
        for (i = 0; i < this.nClases; ++i) {
            if (clases[i] <= clase) continue;
            clasePorDefecto = i;
            clase = clases[i];
        }
        for (i = 0; i < datos.size(); ++i) {
            int j;
            for (j = 0; j < this.nClases; ++j) {
                voto[j] = 0;
            }
            for (j = 0; j < this.reglas.size(); ++j) {
                if (!this.reglas.getRegla(j).cubre(datos.getDato(i))) continue;
                int[] distribucion = this.reglas.getRegla(j).getDistribucion();
                for (int k = 0; k < this.nClases; ++k) {
                    int n = k;
                    voto[n] = voto[n] + distribucion[k];
                }
            }
            int max = 0;
            int cl = 0;
            for (j = 0; j < this.nClases; ++j) {
                if (voto[j] <= max) continue;
                max = voto[j];
                cl = j;
            }
            if (max == 0) {
                cl = clasePorDefecto;
            }
            cadena = cadena + new String(this.valorNombreClases[datos.getDato(i).getClase()] + " " + this.valorNombreClases[cl] + "\n");
        }
        return cadena;
    }

    private void evaluarComplejo(Complejo c, ConjDatos e) {
        c.borraDistrib();
        for (int i = 0; i < e.size(); ++i) {
            int cl = e.getDato(i).getClase();
            if (!c.cubre(e.getDato(i))) continue;
            c.incrementaDistrib(cl);
        }
    }
}

