/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import java.io.PrintStream;
import javolution.JavolutionError;
import javolution.Perf_Lang;
import javolution.Perf_Realtime;
import javolution.Perf_Util;
import javolution.Perf_Xml;
import javolution.lang.Reflection;
import javolution.lang.TextBuilder;

public class Javolution {
    public static final String VERSION = "3.7.1 (J2SE 1.5+) January 14 2006";
    private static PrintStream Out = System.out;
    private static long _time;
    private static final Reflection.Method NANO_TIME_METHOD;

    protected Javolution() {
    }

    public static void main(String[] stringArray) throws Exception {
        Javolution.println("Javolution - Java(TM) Solution for Real-Time and Embedded Systems");
        Javolution.println("Version 3.7.1 (J2SE 1.5+) January 14 2006 (http://javolution.org)");
        Javolution.println("");
        if (stringArray.length > 0) {
            if (stringArray[0].equals("version")) {
                return;
            }
            if (stringArray[0].equals("test")) {
                Javolution.testing();
                return;
            }
            if (stringArray[0].equals("perf")) {
                Javolution.benchmark();
                return;
            }
        }
        Javolution.println("Usage: java -jar javolution.jar [arg]");
        Javolution.println("where arg is one of:");
        Javolution.println("    version (to show version information only)");
        Javolution.println("    test    (to perform self-tests)");
        Javolution.println("    perf    (to run benchmark)");
    }

    private static void testing() throws Exception {
        Javolution.print("Testing...");
        Javolution.println("");
        Javolution.println("Success");
    }

    private static void benchmark() throws Exception {
        Javolution.println("Benchmark...");
        Javolution.println("");
        Thread.currentThread().setPriority(10);
        new Perf_Lang().run();
        new Perf_Realtime().run();
        new Perf_Util().run();
        new Perf_Xml().run();
        Javolution.println("");
        Javolution.println("More performance analysis in future versions...");
    }

    public static void println(Object object) {
        if (Out == null) {
            return;
        }
        Out.println(object);
    }

    public static void print(Object object) {
        if (Out == null) {
            return;
        }
        Out.print(object);
    }

    public static void startTime() {
        System.gc();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            throw new JavolutionError(interruptedException);
        }
        _time = Javolution.nanoTime();
    }

    public static void setOutputStream(PrintStream printStream) {
        Out = printStream;
    }

    public static String endTime(int n) {
        long l;
        String string;
        long l2 = Javolution.nanoTime() - _time;
        long l3 = l2 * 1000L / (long)n;
        if (l3 > 1000000000000L) {
            string = " s";
            l = 1000000000000L;
        } else if (l3 > 1000000000L) {
            string = " ms";
            l = 1000000000L;
        } else if (l3 > 1000000L) {
            string = " us";
            l = 1000000L;
        } else {
            string = " ns";
            l = 1000L;
        }
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(l3 / l);
        int n2 = 4 - textBuilder.length();
        textBuilder.append(".");
        int n3 = 0;
        int n4 = 10;
        while (n3 < n2) {
            textBuilder.append(l3 * (long)n4 / l % 10L);
            ++n3;
            n4 *= 10;
        }
        return textBuilder.append(string).toString();
    }

    private static long nanoTime() {
        if (NANO_TIME_METHOD != null) {
            Long l = (Long)NANO_TIME_METHOD.invoke(null);
            return l;
        }
        return System.currentTimeMillis() * 1000000L;
    }

    static {
        NANO_TIME_METHOD = Reflection.getMethod("java.lang.System.nanoTime()");
    }
}

