/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.AbstractSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.DatabaseConnection;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.IncrementalConverter;

public class DatabaseSaver
extends AbstractSaver
implements BatchConverter,
IncrementalConverter,
DatabaseConverter,
OptionHandler {
    static final long serialVersionUID = 863971733782624956L;
    private DatabaseConnection m_DataBaseConnection;
    private String m_tableName;
    private String m_inputFile;
    private String m_createText;
    private String m_createDouble;
    private String m_createInt;
    private String m_idColumn;
    private int m_count;
    private boolean m_id;
    private boolean m_tabName;
    protected static String PROPERTY_FILE = "weka/experiment/DatabaseUtils.props";
    protected static Properties PROPERTIES;

    public DatabaseSaver() throws Exception {
        this.resetOptions();
        this.m_createText = PROPERTIES.getProperty("CREATE_STRING");
        this.m_createDouble = PROPERTIES.getProperty("CREATE_DOUBLE");
        this.m_createInt = PROPERTIES.getProperty("CREATE_INT");
        this.m_idColumn = PROPERTIES.getProperty("idColumn");
    }

    public void resetOptions() {
        super.resetOptions();
        this.setRetrieval(0);
        this.m_tableName = "";
        this.m_count = 1;
        this.m_id = false;
        this.m_tabName = true;
        try {
            if (this.m_DataBaseConnection != null && this.m_DataBaseConnection.isConnected()) {
                this.m_DataBaseConnection.disconnectFromDatabase();
            }
            this.m_DataBaseConnection = new DatabaseConnection();
        }
        catch (Exception exception) {
            this.printException(exception);
        }
    }

    public void cancel() {
        if (this.getWriteMode() == 2) {
            try {
                this.m_DataBaseConnection.update("DROP TABLE " + this.m_tableName);
                if (this.m_DataBaseConnection.tableExists(this.m_tableName)) {
                    System.err.println("Table cannot be dropped.");
                }
            }
            catch (Exception exception) {
                this.printException(exception);
            }
            this.resetOptions();
        }
    }

    public String globalInfo() {
        return "Writes to a database (tested with MySQL, InstantDB, HSQLDB).";
    }

    public void setTableName(String string) {
        this.m_tableName = string;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public String tableNameTipText() {
        return "Sets the name of the table.";
    }

    public void setAutoKeyGeneration(boolean bl) {
        this.m_id = bl;
    }

    public boolean getAutoKeyGeneration() {
        return this.m_id;
    }

    public String autoKeyGenerationTipText() {
        return "If set to true, a primary key column is generated automatically (containing the row number as INTEGER). The name of the key is read from DatabaseUtils (idColumn) This primary key can be used for incremental loading (requires an unique key). This primary key will not be loaded as an attribute.";
    }

    public void setRelationForTableName(boolean bl) {
        this.m_tabName = bl;
    }

    public boolean getRelationForTableName() {
        return this.m_tabName;
    }

    public String relationForTableNameTipText() {
        return "If set to true, the relation name will be used as name for the database table. Otherwise the user has to provide a table name.";
    }

    public void setUrl(String string) {
        this.m_DataBaseConnection.setDatabaseURL(string);
    }

    public String getUrl() {
        return this.m_DataBaseConnection.getDatabaseURL();
    }

    public String urlTipText() {
        return "The URL of the database";
    }

    public void setUser(String string) {
        this.m_DataBaseConnection.setUsername(string);
    }

    public String getUser() {
        return this.m_DataBaseConnection.getUsername();
    }

    public String userTipText() {
        return "The user name for the database";
    }

    public void setPassword(String string) {
        this.m_DataBaseConnection.setPassword(string);
    }

    public String getPassword() {
        return this.m_DataBaseConnection.getPassword();
    }

    public String passwordTipText() {
        return "The database password";
    }

    public void setDestination(String string, String string2, String string3) {
        try {
            this.m_DataBaseConnection = new DatabaseConnection();
            this.m_DataBaseConnection.setDatabaseURL(string);
            this.m_DataBaseConnection.setUsername(string2);
            this.m_DataBaseConnection.setPassword(string3);
        }
        catch (Exception exception) {
            this.printException(exception);
        }
    }

    public void setDestination(String string) {
        try {
            this.m_DataBaseConnection = new DatabaseConnection();
            this.m_DataBaseConnection.setDatabaseURL(string);
        }
        catch (Exception exception) {
            this.printException(exception);
        }
    }

    public void setDestination() {
        try {
            this.m_DataBaseConnection = new DatabaseConnection();
        }
        catch (Exception exception) {
            this.printException(exception);
        }
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void connectToDatabase() {
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.m_DataBaseConnection.connectToDatabase();
            }
        }
        catch (Exception exception) {
            this.printException(exception);
        }
    }

    private void writeStructure() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Instances instances = this.getInstances();
        stringBuffer.append("CREATE TABLE ");
        if (this.m_tabName || this.m_tableName.equals("")) {
            this.m_tableName = instances.relationName();
        }
        if (this.m_DataBaseConnection.getUpperCase()) {
            this.m_tableName = this.m_tableName.toUpperCase();
            this.m_createInt = this.m_createInt.toUpperCase();
            this.m_createDouble = this.m_createDouble.toUpperCase();
            this.m_createText = this.m_createText.toUpperCase();
        }
        this.m_tableName = this.m_tableName.replaceAll("[^\\w]", "_");
        stringBuffer.append(this.m_tableName);
        if (instances.numAttributes() == 0) {
            throw new Exception("Instances have no attribute.");
        }
        stringBuffer.append(" ( ");
        if (this.m_id) {
            if (this.m_DataBaseConnection.getUpperCase()) {
                this.m_idColumn = this.m_idColumn.toUpperCase();
            }
            stringBuffer.append(this.m_idColumn);
            stringBuffer.append(" ");
            stringBuffer.append(this.m_createInt);
            stringBuffer.append(" PRIMARY KEY,");
        }
        for (int i = 0; i < instances.numAttributes(); ++i) {
            Attribute attribute = instances.attribute(i);
            String string = attribute.name();
            string = string.replaceAll("[^\\w]", "_");
            if (this.m_DataBaseConnection.getUpperCase()) {
                stringBuffer.append(string.toUpperCase());
            } else {
                stringBuffer.append(string);
            }
            if (attribute.isDate()) {
                stringBuffer.append(" DATE");
            } else if (attribute.isNumeric()) {
                stringBuffer.append(" " + this.m_createDouble);
            } else {
                stringBuffer.append(" " + this.m_createText);
            }
            if (i == instances.numAttributes() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" )");
        this.m_DataBaseConnection.update(stringBuffer.toString());
        this.m_DataBaseConnection.close();
        if (!this.m_DataBaseConnection.tableExists(this.m_tableName)) {
            throw new IOException("Table cannot be built.");
        }
    }

    private void writeInstance(Instance instance) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.m_tableName);
        stringBuffer.append(" VALUES ( ");
        if (this.m_id) {
            stringBuffer.append(this.m_count);
            stringBuffer.append(", ");
            ++this.m_count;
        }
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (instance.isMissing(i)) {
                stringBuffer.append("NULL");
            } else if (instance.attribute(i).isNumeric()) {
                stringBuffer.append(instance.value(i));
            } else {
                String string = "'" + instance.stringValue(i) + "'";
                string = string.replaceAll("''", "'");
                stringBuffer.append(string);
            }
            if (i == instance.numAttributes() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" )");
        if (this.m_DataBaseConnection.update(stringBuffer.toString()) < 1) {
            throw new IOException("Tuple cannot be inserted.");
        }
        this.m_DataBaseConnection.close();
    }

    public void writeIncremental(Instance instance) throws IOException {
        int n = this.getWriteMode();
        Instances instances = this.getInstances();
        if (this.m_DataBaseConnection == null) {
            throw new IOException("No database has been set up.");
        }
        if (this.getRetrieval() == 1) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(2);
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.connectToDatabase();
            }
            if (n == 1) {
                if (instances == null) {
                    this.setWriteMode(2);
                    if (instance != null) {
                        throw new Exception("Structure(Header Information) has to be set in advance");
                    }
                } else {
                    this.setWriteMode(3);
                }
                n = this.getWriteMode();
            }
            if (n == 2) {
                this.cancel();
            }
            if (n == 3) {
                this.setWriteMode(0);
                this.writeStructure();
                n = this.getWriteMode();
            }
            if (n == 0) {
                if (instances == null) {
                    throw new IOException("No instances information available.");
                }
                if (instance != null) {
                    this.writeInstance(instance);
                } else {
                    this.m_DataBaseConnection.disconnectFromDatabase();
                    this.resetStructure();
                    this.m_count = 1;
                }
            }
        }
        catch (Exception exception) {
            this.printException(exception);
        }
    }

    public void writeBatch() throws IOException {
        Instances instances = this.getInstances();
        if (instances == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.m_DataBaseConnection == null) {
            throw new IOException("No database has been set up.");
        }
        this.setRetrieval(1);
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.connectToDatabase();
            }
            this.setWriteMode(0);
            this.writeStructure();
            for (int i = 0; i < instances.numInstances(); ++i) {
                this.writeInstance(instances.instance(i));
            }
            this.m_DataBaseConnection.disconnectFromDatabase();
            this.setWriteMode(1);
            this.resetStructure();
            this.m_count = 1;
        }
        catch (Exception exception) {
            this.printException(exception);
        }
    }

    private void printException(Exception exception) {
        System.out.println("\n--- Exception caught ---\n");
        while (exception != null) {
            System.out.println("Message:   " + exception.getMessage());
            if (exception instanceof SQLException) {
                System.out.println("SQLState:  " + ((SQLException)exception).getSQLState());
                System.out.println("ErrorCode: " + ((SQLException)exception).getErrorCode());
                exception = ((SQLException)exception).getNextException();
            } else {
                exception = null;
            }
            System.out.println("");
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getUrl() != null && this.getUrl().length() != 0) {
            vector.add("-url");
            vector.add(this.getUrl());
        }
        if (this.getUser() != null && this.getUser().length() != 0) {
            vector.add("-user");
            vector.add(this.getUser());
        }
        if (this.getPassword() != null && this.getPassword().length() != 0) {
            vector.add("-password");
            vector.add(this.getPassword());
        }
        if (this.m_tableName != null && this.m_tableName.length() != 0) {
            vector.add("-T");
            vector.add(this.m_tableName);
        }
        if (this.m_id) {
            vector.add("-P");
        }
        if (this.m_inputFile != null && this.m_inputFile.length() != 0) {
            vector.add("-i");
            vector.add(this.m_inputFile);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public Enumeration listOptions() {
        FastVector fastVector = new FastVector();
        fastVector.addElement(new Option("\tThe JDBC URL to connect to.\n\t(default: from DatabaseUtils.props file)", "url", 1, "-url <JDBC URL>"));
        fastVector.addElement(new Option("\tThe user to connect with to the database.\n\t(default: none)", "user", 1, "-user <name>"));
        fastVector.addElement(new Option("\tThe password to connect with to the database.\n\t(default: none)", "password", 1, "-password <password>"));
        fastVector.addElement(new Option("\tThe name of the table.\n\t(default: the relation name)", "T", 1, "-T <table name>"));
        fastVector.addElement(new Option("\tAdd an ID column as primary key. The name is specified\n\tin the DatabaseUtils file ('idColumn'). The DatabaseLoader\n\twon't load this column.", "P", 0, "-P"));
        fastVector.addElement(new Option("\tInput file in arff format that should be saved in database.", "i", 1, "-i <input file name>"));
        return fastVector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption("url", stringArray);
        if (string.length() != 0) {
            this.setUrl(string);
        }
        if ((string = Utils.getOption("user", stringArray)).length() != 0) {
            this.setUser(string);
        }
        if ((string = Utils.getOption("password", stringArray)).length() != 0) {
            this.setPassword(string);
        }
        String string2 = Utils.getOption('T', stringArray);
        String string3 = Utils.getOption('i', stringArray);
        if (string2.length() != 0) {
            this.m_tableName = string2;
            this.m_tabName = false;
        }
        this.m_id = Utils.getFlag('P', stringArray);
        if (string3.length() != 0) {
            try {
                this.m_inputFile = string3;
                ArffLoader arffLoader = new ArffLoader();
                File file = new File(string3);
                arffLoader.setSource(file);
                this.setInstances(arffLoader.getDataSet());
                if (string2.length() == 0) {
                    this.m_tableName = this.getInstances().relationName();
                }
            }
            catch (Exception exception) {
                this.printException(exception);
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\nDatabaseSaver options:\n");
        try {
            DatabaseSaver databaseSaver = new DatabaseSaver();
            try {
                Enumeration enumeration = databaseSaver.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    stringBuffer.append(option.synopsis() + '\n');
                    stringBuffer.append(option.description() + '\n');
                }
                databaseSaver.setOptions(stringArray);
                databaseSaver.setDestination();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            databaseSaver.writeBatch();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(stringBuffer);
        }
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
        }
        catch (Exception exception) {
            System.err.println("Problem reading properties. Fix before continuing.");
            System.err.println(exception);
        }
    }
}

