/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.local;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.local.HillClimber;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public class RepeatedHillClimber
extends HillClimber {
    static final long serialVersionUID = -6574084564213041174L;
    int m_nRuns = 10;
    int m_nSeed = 1;
    Random m_random;

    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        this.m_random = new Random(this.getSeed());
        double d = 0.0;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            d += this.calcNodeScore(i);
        }
        double d2 = d;
        BayesNet bayesNet2 = new BayesNet();
        bayesNet2.m_Instances = instances;
        bayesNet2.initStructure();
        this.copyParentSets(bayesNet2, bayesNet);
        for (int i = 0; i < this.m_nRuns; ++i) {
            this.generateRandomNet(bayesNet, instances);
            super.search(bayesNet, instances);
            d = 0.0;
            for (int j = 0; j < instances.numAttributes(); ++j) {
                d += this.calcNodeScore(j);
            }
            if (!(d > d2)) continue;
            d2 = d;
            this.copyParentSets(bayesNet2, bayesNet);
        }
        this.copyParentSets(bayesNet, bayesNet2);
        bayesNet2 = null;
        this.m_Cache = null;
    }

    void generateRandomNet(BayesNet bayesNet, Instances instances) {
        int n;
        int n2 = instances.numAttributes();
        for (n = 0; n < n2; ++n) {
            ParentSet parentSet = bayesNet.getParentSet(n);
            while (parentSet.getNrOfParents() > 0) {
                parentSet.deleteLastParent(instances);
            }
        }
        if (this.getInitAsNaiveBayes()) {
            n = instances.classIndex();
            for (int i = 0; i < n2; ++i) {
                if (i == n) continue;
                bayesNet.getParentSet(i).addParent(n, instances);
            }
        }
        n = this.m_random.nextInt(n2 * n2);
        for (int i = 0; i < n; ++i) {
            int n3 = this.m_random.nextInt(n2);
            int n4 = this.m_random.nextInt(n2);
            if (bayesNet.getParentSet(n4).getNrOfParents() >= this.getMaxNrOfParents() || !this.addArcMakesSense(bayesNet, instances, n4, n3)) continue;
            bayesNet.getParentSet(n4).addParent(n3, instances);
        }
    }

    void copyParentSets(BayesNet bayesNet, BayesNet bayesNet2) {
        int n = bayesNet2.getNrOfNodes();
        for (int i = 0; i < n; ++i) {
            bayesNet.getParentSet(i).copy(bayesNet2.getParentSet(i));
        }
    }

    public int getRuns() {
        return this.m_nRuns;
    }

    public void setRuns(int n) {
        this.m_nRuns = n;
    }

    public int getSeed() {
        return this.m_nSeed;
    }

    public void setSeed(int n) {
        this.m_nSeed = n;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tNumber of runs", "U", 1, "-U <integer>"));
        vector.addElement(new Option("\tRandom number seed", "A", 1, "-A <seed>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String string2 = Utils.getOption('U', stringArray);
        if (string2.length() != 0) {
            this.setRuns(Integer.parseInt(string2));
        }
        if ((string = Utils.getOption('A', stringArray)).length() != 0) {
            this.setSeed(Integer.parseInt(string));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[7 + stringArray.length];
        int n = 0;
        stringArray2[n++] = "-U";
        stringArray2[n++] = "" + this.getRuns();
        stringArray2[n++] = "-A";
        stringArray2[n++] = "" + this.getSeed();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[n++] = stringArray[i];
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String globalInfo() {
        return "This Bayes Network learning algorithm repeatedly uses hill climbing starting with a randomly generated network structure and return the best structure of the various runs.";
    }

    public String runsTipText() {
        return "Sets the number of times hill climbing is performed.";
    }

    public String seedTipText() {
        return "Initialization value for random number generator. Setting the seed allows replicability of experiments.";
    }
}

