/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.Month;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.List;

public class PeriodicDummies
implements ITsVariable {
    private final int period;
    private final Day start;

    public PeriodicDummies(int period) {
        this.period = period;
        this.start = new Day(1970, Month.January, 0);
    }

    public PeriodicDummies(int period, Day start) {
        this.period = period;
        this.start = start;
    }

    @Override
    public void data(TsDomain domain, List<DataBlock> data) {
        TsPeriod dstart = domain.getStart();
        TsPeriod rstart = new TsPeriod(dstart.getFrequency(), this.start);
        int pos = dstart.minus(rstart) % this.period;
        for (int i = 0; i < this.period; ++i) {
            int cur = i + pos;
            if (cur >= this.period) {
                cur -= this.period;
            }
            data.get(i).extract(cur, -1, this.period).set(1.0);
        }
    }

    @Override
    public TsDomain getDefinitionDomain() {
        return null;
    }

    @Override
    public TsFrequency getDefinitionFrequency() {
        return TsFrequency.Undefined;
    }

    @Override
    public String getDescription(TsFrequency context) {
        return "Periodic dummies";
    }

    @Override
    public int getDim() {
        return this.period;
    }

    @Override
    public String getItemDescription(int idx, TsFrequency context) {
        StringBuilder builder = new StringBuilder();
        builder.append("Periodic dummy [").append(idx + 1).append(']');
        return builder.toString();
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        return true;
    }

    @Override
    public String getName() {
        return "periodic#" + this.getDim();
    }
}

