/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.calendars;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.DayOfWeek;
import ec.tstoolkit.timeseries.Month;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class Utilities {
    public static final double LUNARY = 29.53059;
    public static final double DEC_LUNARY = 0.53059;
    static final int CYCLE = 532;
    static final int TWOCYCLE = 1064;
    static final int[] PROB = new int[]{4, 8, 8, 12, 16, 16, 20, 16, 16, 20, 16, 16, 20, 16, 20, 20, 16, 20, 16, 16, 20, 16, 16, 20, 16, 20, 16, 16, 20, 16, 12, 12, 8, 8, 4};
    private static final int[] JD = new int[]{1, 1, 3, 9, 15, 11, 14, 27, 36, 28, 24, 32, 40, 39, 33, 31, 34, 36, 42, 39, 33, 31, 33, 42, 38, 33, 30, 32, 39, 40, 33, 29, 26, 31, 33, 22, 7, 15, 12, 7, 1, 1, 1};

    public static int[] daysCount(TsDomain domain) {
        int i;
        int n = domain.getLength();
        int[] rslt = new int[n];
        int[] start = new int[n + 1];
        TsPeriod d0 = domain.getStart();
        int conv = 12 / d0.getFrequency().intValue();
        TsPeriod month = new TsPeriod(TsFrequency.Monthly);
        month.set(d0.getYear(), d0.getPosition() * conv);
        for (i = 0; i < start.length; ++i) {
            start[i] = Day.calc(month.getYear(), month.getPosition(), 0);
            month.move(conv);
        }
        for (i = 0; i < n; ++i) {
            int ni;
            rslt[i] = ni = start[i + 1] - start[i];
        }
        return rslt;
    }

    public static int[] daysCount(TsDomain domain, DayOfWeek day) {
        int i;
        int n = domain.getLength();
        int[] rslt = new int[n];
        int[] start = new int[n + 1];
        TsPeriod d0 = domain.getStart();
        int conv = 12 / d0.getFrequency().intValue();
        TsPeriod month = new TsPeriod(TsFrequency.Monthly);
        month.set(d0.getYear(), d0.getPosition() * conv);
        for (i = 0; i < start.length; ++i) {
            start[i] = Day.calc(month.getYear(), month.getPosition(), 0);
            month.move(conv);
        }
        for (i = 0; i < n; ++i) {
            int j;
            int j0;
            int dw0 = (start[i] - 4) % 7;
            int ni = start[i + 1] - start[i];
            if (dw0 < 0) {
                dw0 += 7;
            }
            if ((j0 = (j = day.intValue()) - dw0) < 0) {
                j0 += 7;
            }
            rslt[i] = 1 + (ni - 1 - j0) / 7;
        }
        return rslt;
    }

    public static Day easter(int y) {
        int a = y % 19;
        int b = y / 100;
        int c = y % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int m = (a + 11 * h + 22 * l) / 451;
        int month = (h + l - 7 * m + 114) / 31;
        int day = (h + l - 7 * m + 114) % 31 + 1;
        return new Day(y, Month.valueOf(month - 1), day - 1);
    }

    public static Day easter2(int y) {
        int td;
        int te;
        int d;
        int firstdig = y / 100;
        int remain19 = y % 19;
        int temp = (firstdig - 15) / 2 + 202 - 11 * remain19;
        if (firstdig == 21 || firstdig == 24 || firstdig == 25 || firstdig >= 27 && firstdig <= 32 || firstdig == 34 || firstdig == 35 || firstdig == 38) {
            --temp;
        } else if (firstdig == 33 || firstdig == 36 || firstdig == 37 || firstdig == 39 || firstdig == 40) {
            temp -= 2;
        }
        int ta = (temp %= 30) + 21;
        if (temp == 29) {
            --ta;
        }
        if (temp == 28 && remain19 > 10) {
            --ta;
        }
        int tb = (ta - 19) % 7;
        int tc = (40 - firstdig) % 4;
        if (tc == 3) {
            ++tc;
        }
        if (tc > 1) {
            ++tc;
        }
        if ((d = ta + (te = (20 - tb - tc - (td = ((temp = y % 100) + temp / 4) % 7)) % 7 + 1)) > 31) {
            return new Day(y, Month.April, d - 32);
        }
        return new Day(y, Month.March, d - 1);
    }

    @Deprecated
    public static Day julianEaster(int year, boolean gregorian) {
        int day;
        int month;
        int a = year % 19;
        int b = year % 4;
        int c = year % 7;
        int d = (19 * a + 15) % 30;
        int e = (2 * b + 4 * c + 6 * d + 6) % 7;
        int z = 4 + d + e;
        int de = d + e;
        if (de < 10) {
            month = 3;
            day = 22 + de;
        } else {
            month = 4;
            day = de - 9;
        }
        Day easter = new Day(year, Month.valueOf(month - 1), day - 1);
        if (gregorian) {
            return easter.plus(13);
        }
        return easter;
    }

    @Deprecated
    public static Day julianEaster2(int year, boolean gregorian) {
        int g = year % 19;
        int i = (19 * g + 15) % 30;
        int j = (year + year / 4 + i) % 7;
        int l = i - j;
        int month = 3 + (l + 40) / 44;
        int day = l + 28 - 31 * (month / 4);
        Day easter = new Day(year, Month.valueOf(month - 1), day - 1);
        if (gregorian) {
            return easter.plus(13);
        }
        return easter;
    }

    public static int julianDate2JDN(int year, int month, int day) {
        int a = (14 - month) / 12;
        int y = year + 4800 - a;
        int m = month + 12 * a - 3;
        return day + (153 * m + 2) / 5 + 365 * y + y / 4 - 32083;
    }

    public static int gregorianDate2JDN(int year, int month, int day) {
        int a = (14 - month) / 12;
        int y = year + 4800 - a;
        int m = month + 12 * a - 3;
        return day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
    }

    public static Day JDN2GregorianDate(int jdn) {
        int y = 4716;
        int v = 3;
        int j = 1401;
        int u = 5;
        int m = 2;
        int s = 153;
        int n = 12;
        int w = 2;
        int r = 4;
        int B = 274277;
        int p = 1461;
        int C = -38;
        int f = jdn + 1401 + (4 * jdn + 274277) / 146097 * 3 / 4 + -38;
        int e = 4 * f + 3;
        int g = e % 1461 / 4;
        int h = 5 * g + 2;
        int D = h % 153 / 5;
        int M = (h / 153 + 2) % 12;
        int Y = e / 1461 - 4716 + (14 - M) / 12;
        return new Day(Y, Month.valueOf(M), D);
    }

    public static Day julianEaster3(int year, boolean gregorian) {
        int a = year % 19;
        int b = year % 4;
        int c = year % 7;
        int d = (19 * a + 15) % 30;
        int e = (2 * b + 4 * c - d + 34) % 7;
        int f = d + e + 114;
        int month = f / 31;
        int day = f % 31 + 1;
        Day easterJ = new Day(year, Month.valueOf(month - 1), day - 1);
        if (gregorian) {
            return Utilities.JDN2GregorianDate(Utilities.julianDate2JDN(year, month, day));
        }
        return easterJ;
    }

    public static Day firstWeekDay(DayOfWeek day, int year, Month month) {
        TsPeriod m = new TsPeriod(TsFrequency.Monthly);
        m.set(year, month.intValue());
        Day start = m.firstday();
        int iday = day.intValue();
        int istart = start.getDayOfWeek().intValue();
        int n = iday - istart;
        if (n < 0) {
            n += 7;
        }
        if (n != 0) {
            start = start.plus(n);
        }
        return start;
    }

    public static int[] lastDay(TsDomain domain) {
        int n = domain.getLength();
        int[] rslt = new int[n];
        TsPeriod d1 = domain.getStart();
        d1.move(1);
        int conv = 12 / d1.getFrequency().intValue();
        TsPeriod month = new TsPeriod(TsFrequency.Monthly);
        month.set(d1.getYear(), d1.getPosition() * conv);
        for (int i = 0; i < rslt.length; ++i) {
            int id = Day.calc(month.getYear(), month.getPosition(), 0);
            if ((id = (id - 5) % 7) < 0) {
                id += 7;
            }
            rslt[i] = id;
            month.move(conv);
        }
        return rslt;
    }

    public static void leapYear(TsPeriod start, DataBlock buffer) {
        int idx;
        buffer.set(0.0);
        TsDomain domain = new TsDomain(start, buffer.getLength());
        int period = 0;
        int freq = start.getFrequency().intValue();
        if (freq == 12) {
            period = 1;
        }
        if ((idx = period - start.getPosition()) < 0) {
            idx += freq;
        }
        while (idx < buffer.getLength()) {
            if (Day.isLeap(domain.get(idx).getYear())) {
                buffer.set(idx, 0.75);
            } else {
                buffer.set(idx, -0.25);
            }
            idx += freq;
        }
    }

    public static void lengthofPeriod(TsPeriod start, DataBlock buffer) {
        int[] ndays = Utilities.daysCount(new TsDomain(start, buffer.getLength()));
        double m = 365.25 / (double)start.getFrequency().intValue();
        buffer.set(i -> (double)ndays[i] - m);
    }

    public static double logJacobian(LengthOfPeriodType kind, TsDomain domain, boolean back) {
        double lj = 0.0;
        if (kind == LengthOfPeriodType.LengthOfPeriod) {
            int[] ndays = Utilities.daysCount(domain);
            double m = 365.25 / (double)domain.getFrequency().intValue();
            if (back) {
                for (int i = 0; i < ndays.length; ++i) {
                    double c = (double)ndays[i] / m;
                    lj += Math.log(c);
                }
            } else {
                for (int i = 0; i < ndays.length; ++i) {
                    double c = m / (double)ndays[i];
                    lj += Math.log(c);
                }
            }
        } else {
            int idx;
            int period = 0;
            int freq = domain.getFrequency().intValue();
            if (freq == 12) {
                period = 1;
            }
            if ((idx = period - domain.getStart().getPosition()) < 0) {
                idx += freq;
            }
            int ndays = 0;
            if (freq == 12) {
                ndays = 28;
            } else {
                int nm = 12 / freq;
                for (int i = 0; i < nm; ++i) {
                    ndays += Day.getMonthDays(i);
                }
            }
            double leap = (double)(ndays + 1) / ((double)ndays + 0.25);
            double nleap = (double)ndays / ((double)ndays + 0.25);
            double lleap = Math.log(leap);
            double lnleap = Math.log(nleap);
            if (back) {
                while (idx < domain.getLength()) {
                    lj = Day.isLeap(domain.get(idx).getYear()) ? (lj += lleap) : (lj += lnleap);
                    idx += freq;
                }
            } else {
                while (idx < domain.getLength()) {
                    lj = Day.isLeap(domain.get(idx).getYear()) ? (lj -= lleap) : (lj -= lnleap);
                    idx += freq;
                }
            }
        }
        return lj;
    }

    @Deprecated
    public static int[][] tradingDays(TsDomain domain) {
        int i;
        int[][] rslt = new int[7][];
        int n = domain.getLength();
        int[] start = new int[n + 1];
        TsPeriod d0 = domain.getStart();
        int conv = 12 / d0.getFrequency().intValue();
        TsPeriod month = new TsPeriod(TsFrequency.Monthly);
        month.set(d0.getYear(), d0.getPosition() * conv);
        for (i = 0; i < start.length; ++i) {
            start[i] = Day.calc(month.getYear(), month.getPosition(), 0);
            month.move(conv);
        }
        for (int j = 0; j < 7; ++j) {
            rslt[j] = new int[n];
        }
        for (i = 0; i < n; ++i) {
            int dw0 = (start[i] - 4) % 7;
            int ni = start[i + 1] - start[i];
            if (dw0 < 0) {
                dw0 += 7;
            }
            for (int j = 0; j < 7; ++j) {
                int j0 = j - dw0;
                if (j0 < 0) {
                    j0 += 7;
                }
                rslt[j][i] = 1 + (ni - 1 - j0) / 7;
            }
        }
        return rslt;
    }

    public static int[][] tdCount(TsDomain domain) {
        int i;
        int[][] rslt = new int[7][];
        int n = domain.getLength();
        int[] start = new int[n + 1];
        TsPeriod d0 = domain.getStart();
        int conv = 12 / d0.getFrequency().intValue();
        TsPeriod month = new TsPeriod(TsFrequency.Monthly);
        month.set(d0.getYear(), d0.getPosition() * conv);
        for (i = 0; i < start.length; ++i) {
            start[i] = Day.calc(month.getYear(), month.getPosition(), 0);
            month.move(conv);
        }
        for (int j = 0; j < 7; ++j) {
            rslt[j] = new int[n];
        }
        for (i = 0; i < n; ++i) {
            int ni = start[i + 1] - start[i];
            int dw0 = (start[i] - 3) % 7;
            if (dw0 < 0) {
                dw0 += 7;
            }
            for (int j = 0; j < 7; ++j) {
                int j0 = j - dw0;
                if (j0 < 0) {
                    j0 += 7;
                }
                rslt[j][i] = 1 + (ni - 1 - j0) / 7;
            }
        }
        return rslt;
    }

    public static void transform(LengthOfPeriodType kind, TsData tsdata, boolean back) {
        if (kind == LengthOfPeriodType.LengthOfPeriod) {
            int[] ndays = Utilities.daysCount(tsdata.getDomain());
            double m = 365.25 / (double)tsdata.getFrequency().intValue();
            double[] data = tsdata.internalStorage();
            if (back) {
                for (int i = 0; i < ndays.length; ++i) {
                    int n = i;
                    data[n] = data[n] * ((double)ndays[i] / m);
                }
            } else {
                for (int i = 0; i < ndays.length; ++i) {
                    int n = i;
                    data[n] = data[n] * (m / (double)ndays[i]);
                }
            }
        } else {
            int idx;
            TsDomain domain = tsdata.getDomain();
            int period = 0;
            int freq = tsdata.getFrequency().intValue();
            if (freq == 12) {
                period = 1;
            }
            if ((idx = period - domain.getStart().getPosition()) < 0) {
                idx += freq;
            }
            int ndays = 0;
            if (freq == 12) {
                ndays = 28;
            } else {
                int nm = 12 / freq;
                for (int i = 0; i < nm; ++i) {
                    ndays += Day.getMonthDays(i);
                }
            }
            double leap = (double)(ndays + 1) / ((double)ndays + 0.25);
            double nleap = (double)ndays / ((double)ndays + 0.25);
            double[] data = tsdata.internalStorage();
            if (back) {
                while (idx < domain.getLength()) {
                    if (Day.isLeap(domain.get(idx).getYear())) {
                        int n = idx;
                        data[n] = data[n] * leap;
                    } else {
                        int n = idx;
                        data[n] = data[n] * nleap;
                    }
                    idx += freq;
                }
            } else {
                while (idx < domain.getLength()) {
                    if (Day.isLeap(domain.get(idx).getYear())) {
                        int n = idx;
                        data[n] = data[n] / leap;
                    } else {
                        int n = idx;
                        data[n] = data[n] / nleap;
                    }
                    idx += freq;
                }
            }
        }
    }

    public static double probJulianEaster(int pos) {
        if (pos < 0 || pos >= 43) {
            return 0.0;
        }
        double denom = 1064.0;
        return (double)JD[pos] / denom;
    }

    public static double probEaster(int pos) {
        if (pos < 0 || pos >= 35) {
            return 0.0;
        }
        if (pos < 6) {
            return (double)(pos + 1) / 206.71413;
        }
        if (pos < 28) {
            return 0.03386319067786996;
        }
        return ((double)(35 - pos) + 0.53059) / 206.71413;
    }
}

