/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.IArmaFilter;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.Determinant;
import ec.tstoolkit.maths.polynomials.Polynomial;

public class KalmanFilter
implements IArmaFilter {
    private double[] m_C;
    private double[] m_s;
    private boolean m_multiuse;
    private double m_var;
    private Polynomial m_phi;
    private int m_dim;
    private int m_n;
    private double m_ldet = Double.NaN;
    private double m_h0;
    private double[] m_C0;
    private static final double m_eps = -12.0;

    public KalmanFilter() {
    }

    public KalmanFilter(boolean multiuse) {
        this.m_multiuse = multiuse;
    }

    @Override
    public KalmanFilter exemplar() {
        return new KalmanFilter(this.m_multiuse);
    }

    private void calcC() {
        Determinant det = new Determinant();
        double[] L = (double[])this.m_C0.clone();
        this.m_C = new double[this.m_dim * this.m_n];
        for (int i = 0; i < this.m_dim; ++i) {
            this.m_C[i] = L[i];
        }
        this.m_s = new double[this.m_n];
        double h = this.m_h0;
        det.add(h);
        this.m_s[0] = Math.sqrt(h);
        int pos = 0;
        int cpos = 0;
        int ilast = this.m_dim - 1;
        boolean bfast = false;
        while (++pos < this.m_n) {
            if (Double.isNaN(h) || h < 0.0) {
                throw new ArimaException("arima_err_invalid");
            }
            if (!bfast) {
                double zl = L[0];
                double zlv = zl / h;
                double llast = this.tlast(L);
                int i = 0;
                while (i < ilast) {
                    double li = L[i + 1];
                    double ci = this.m_C[cpos];
                    if (zlv != 0.0) {
                        L[i] = li - ci * zlv;
                        this.m_C[cpos + this.m_dim] = ci - zlv * li;
                    } else {
                        L[i] = li;
                        this.m_C[cpos + this.m_dim] = ci;
                    }
                    ++i;
                    ++cpos;
                }
                double clast = this.m_C[cpos];
                L[ilast] = llast - zlv * clast;
                this.m_C[cpos + this.m_dim] = clast - zlv * llast;
                ++cpos;
                if ((h -= zl * zlv) < this.m_var) {
                    h = this.m_var;
                }
                if (h - this.m_var <= -12.0) {
                    bfast = true;
                }
            }
            det.add(h);
            this.m_s[pos] = Math.sqrt(h);
        }
        this.m_ldet = det.getLogDeterminant();
    }

    private void calcdet() {
        Determinant det = new Determinant();
        double[] C = (double[])this.m_C0.clone();
        double[] L = (double[])C.clone();
        double h = this.m_h0;
        int pos = 0;
        int ilast = this.m_dim - 1;
        boolean bfast = false;
        do {
            if (Double.isNaN(h) || h < 0.0) {
                throw new ArimaException("arima_err_invalid");
            }
            det.add(h);
            if (!bfast) {
                double zl = L[0];
                double zlv = zl / h;
                double llast = this.tlast(L);
                double clast = C[ilast];
                for (int i = 0; i < ilast; ++i) {
                    double li = L[i + 1];
                    if (zlv != 0.0) {
                        L[i] = li - C[i] * zlv;
                        int n = i;
                        C[n] = C[n] - zlv * li;
                        continue;
                    }
                    L[i] = li;
                }
                L[ilast] = llast - zlv * clast;
                int n = ilast;
                C[n] = C[n] - zlv * llast;
                if ((h -= zl * zlv) < this.m_var) {
                    h = this.m_var;
                }
                if (!(h - this.m_var <= -12.0)) continue;
                bfast = true;
                continue;
            }
            if (h == 1.0) break;
        } while (++pos < this.m_n);
        this.m_ldet = det.getLogDeterminant();
    }

    @Override
    public void filter(IReadDataBlock y, DataBlock outrc) {
        if (this.m_multiuse) {
            this.mfilter(y, outrc);
        } else {
            this.sfilter(y, outrc);
        }
    }

    @Override
    public double getLogDeterminant() {
        if (Double.isNaN(this.m_ldet)) {
            this.calcdet();
        }
        return this.m_ldet;
    }

    @Override
    public int initialize(IArimaModel model, int length) {
        this.m_var = model.getInnovationVariance();
        this.m_ldet = Double.NaN;
        this.m_phi = model.getAR().getPolynomial();
        this.m_dim = Math.max(this.m_phi.getDegree(), model.getMA().getLength());
        this.m_C0 = model.getAutoCovarianceFunction().values(this.m_dim);
        this.m_h0 = this.m_C0[0];
        this.m_n = length;
        this.tx(this.m_C0);
        if (this.m_multiuse) {
            this.calcC();
        }
        return length;
    }

    private void mfilter(IReadDataBlock y, DataBlock yf) {
        double[] a = new double[this.m_dim];
        int pos = 0;
        int cpos = 0;
        int ilast = this.m_dim - 1;
        double s = this.m_s[pos];
        double e = y.get(pos) / s;
        yf.set(pos, e);
        while (++pos < this.m_n) {
            double la = this.tlast(a);
            double v = e / s;
            for (int i = 0; i < ilast; ++i) {
                a[i] = a[i + 1] + this.m_C[cpos++] * v;
            }
            a[ilast] = la + this.m_C[cpos++] * v;
            s = this.m_s[pos];
            e = (y.get(pos) - a[0]) / s;
            yf.set(pos, e);
        }
    }

    private void sfilter(IReadDataBlock y, DataBlock outrc) {
        Determinant det = new Determinant();
        double[] C = (double[])this.m_C0.clone();
        double[] L = (double[])C.clone();
        double h = this.m_h0;
        double[] a = new double[this.m_dim];
        double[] yf = new double[this.m_n];
        int pos = 0;
        int ilast = this.m_dim - 1;
        boolean bfast = false;
        do {
            double e;
            int i;
            if (Double.isNaN(h) || h < 0.0) {
                throw new ArimaException("arima_err_invalid");
            }
            if (pos > 0 && !bfast) {
                double zl = L[0];
                double zlv = zl / h;
                double llast = this.tlast(L);
                double clast = C[ilast];
                for (i = 0; i < ilast; ++i) {
                    double li = L[i + 1];
                    if (zlv != 0.0) {
                        L[i] = li - C[i] * zlv;
                        int n = i;
                        C[n] = C[n] - zlv * li;
                        continue;
                    }
                    L[i] = li;
                }
                L[ilast] = llast - zlv * clast;
                int n = ilast;
                C[n] = C[n] - zlv * llast;
                if ((h -= zl * zlv) < this.m_var) {
                    h = this.m_var;
                }
                if (h - this.m_var <= -12.0) {
                    bfast = true;
                }
            }
            det.add(h);
            double s = Math.sqrt(h);
            yf[pos] = e = (y.get(pos) - a[0]) / s;
            double la = this.tlast(a);
            double v = e / s;
            for (i = 0; i < ilast; ++i) {
                a[i] = a[i + 1] + C[i] * v;
            }
            a[ilast] = la + C[ilast] * v;
        } while (++pos < this.m_n);
        this.m_ldet = det.getLogDeterminant();
        outrc.copy(new DataBlock(yf));
    }

    private double tlast(double[] x) {
        double last = 0.0;
        for (int i = 1; i <= this.m_phi.getDegree(); ++i) {
            last -= this.m_phi.get(i) * x[this.m_dim - i];
        }
        return last;
    }

    private void tx(double[] x) {
        int i;
        double last = 0.0;
        for (i = 1; i <= this.m_phi.getDegree(); ++i) {
            last -= this.m_phi.get(i) * x[this.m_dim - i];
        }
        for (i = 1; i < this.m_dim; ++i) {
            x[i - 1] = x[i];
        }
        x[this.m_dim - 1] = last;
    }
}

