/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.IntIntObjectFunction;
import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.WrapperObjectMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DiagonalObjectMatrix2D
extends WrapperObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected Object[] elements;
    protected int dlength;
    protected int dindex;

    public DiagonalObjectMatrix2D(Object[][] objectArray, int n) {
        this(objectArray.length, objectArray.length == 0 ? 0 : objectArray[0].length, n);
        this.assign(objectArray);
    }

    public DiagonalObjectMatrix2D(int n, int n2, int n3) {
        int n4;
        int n5;
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        if (n3 < -n + 1 || n3 > n2 - 1) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        this.dindex = n3;
        this.dlength = n3 == 0 ? Math.min(n, n2) : (n3 > 0 ? (n >= n2 ? n2 - n3 : (n3 <= (n5 = n2 - n) ? n : n - (n3 - n5))) : (n >= n2 ? (-n3 <= (n4 = n - n2) ? n2 : n2 + n3 + n4) : n + n3));
        this.elements = new Object[this.dlength];
    }

    public ObjectMatrix2D assign(ObjectFunction objectFunction) {
        int n = this.dlength;
        while (--n >= 0) {
            this.elements[n] = objectFunction.apply(this.elements[n]);
        }
        return this;
    }

    public ObjectMatrix2D assign(Object object) {
        int n = this.dlength;
        while (--n >= 0) {
            this.elements[n] = object;
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object[] objectArray) {
        if (objectArray.length != this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + objectArray.length + " dlength=" + this.dlength);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.dlength);
            Future[] futureArray = new Future[n];
            int n2 = this.dlength / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.dlength : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DiagonalObjectMatrix2D.this.elements[i] = objectArray[i];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.dlength;
            while (--n5 >= 0) {
                this.elements[n5] = objectArray[n5];
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(Object[][] objectArray) {
        int n;
        int n2;
        if (objectArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + objectArray.length + "rows()=" + this.rows());
        }
        if (this.dindex >= 0) {
            n2 = 0;
            n = this.dindex;
        } else {
            n2 = -this.dindex;
            n = 0;
        }
        for (int i = 0; i < this.dlength; ++i) {
            if (objectArray[i].length != this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray[n2].length + "columns()=" + this.columns());
            }
            this.elements[i] = objectArray[n2++][n++];
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D == this) {
            return this;
        }
        this.checkShape(objectMatrix2D);
        if (objectMatrix2D instanceof DiagonalObjectMatrix2D) {
            DiagonalObjectMatrix2D diagonalObjectMatrix2D = (DiagonalObjectMatrix2D)objectMatrix2D;
            if (this.dindex != diagonalObjectMatrix2D.dindex || this.dlength != diagonalObjectMatrix2D.dlength) {
                throw new IllegalArgumentException("source is DiagonalObjectMatrix2D with different diagonal stored.");
            }
            System.arraycopy(diagonalObjectMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(objectMatrix2D);
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D, final ObjectObjectFunction objectObjectFunction) {
        this.checkShape(objectMatrix2D);
        if (objectMatrix2D instanceof DiagonalObjectMatrix2D) {
            DiagonalObjectMatrix2D diagonalObjectMatrix2D = (DiagonalObjectMatrix2D)objectMatrix2D;
            if (this.dindex != diagonalObjectMatrix2D.dindex || this.dlength != diagonalObjectMatrix2D.dlength) {
                throw new IllegalArgumentException("y is DiagonalObjectMatrix2D with different diagonal stored.");
            }
            final Object[] objectArray = diagonalObjectMatrix2D.elements;
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.dlength);
                Future[] futureArray = new Future[n];
                int n2 = this.dlength / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.dlength : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n3; i < n4; ++i) {
                                DiagonalObjectMatrix2D.this.elements[i] = objectObjectFunction.apply(DiagonalObjectMatrix2D.this.elements[i], objectArray[i]);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = this.dlength;
                while (--n5 >= 0) {
                    this.elements[n5] = objectObjectFunction.apply(this.elements[n5], objectArray[n5]);
                }
            }
            return this;
        }
        return super.assign(objectMatrix2D, objectObjectFunction);
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.dlength);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.dlength / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.dlength : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            if (DiagonalObjectMatrix2D.this.elements[i] == null) continue;
                            ++n;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                if (this.elements[i] == null) continue;
                ++n;
            }
        }
        return n;
    }

    public Object[] elements() {
        return this.elements;
    }

    public boolean equals(Object object) {
        if (object instanceof DiagonalObjectMatrix2D) {
            DiagonalObjectMatrix2D diagonalObjectMatrix2D = (DiagonalObjectMatrix2D)object;
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            int n = this.rows();
            int n2 = this.columns();
            if (n2 != diagonalObjectMatrix2D.columns() || n != diagonalObjectMatrix2D.rows()) {
                return false;
            }
            if (this.dindex != diagonalObjectMatrix2D.dindex || this.dlength != diagonalObjectMatrix2D.dlength) {
                return false;
            }
            Object[] objectArray = diagonalObjectMatrix2D.elements;
            for (int i = 0; i < this.dlength; ++i) {
                Object object2 = this.elements[i];
                Object object3 = objectArray[i];
                if (object2.equals(object3)) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public ObjectMatrix2D forEachNonZero(IntIntObjectFunction intIntObjectFunction) {
        int n = this.dlength;
        while (--n >= 0) {
            Object object = this.elements[n];
            if (object == null) continue;
            this.elements[n] = intIntObjectFunction.apply(n, n, object);
        }
        return this;
    }

    public int diagonalLength() {
        return this.dlength;
    }

    public int diagonalIndex() {
        return this.dindex;
    }

    public Object getQuick(int n, int n2) {
        if (this.dindex >= 0) {
            if (n2 < this.dindex) {
                return 0;
            }
            if (n < this.dlength && n + this.dindex == n2) {
                return this.elements[n];
            }
            return 0;
        }
        if (n < -this.dindex) {
            return 0;
        }
        if (n2 < this.dlength && n + this.dindex == n2) {
            return this.elements[n2];
        }
        return 0;
    }

    public ObjectMatrix2D like(int n, int n2) {
        return new SparseObjectMatrix2D(n, n2);
    }

    public ObjectMatrix1D like1D(int n) {
        return new SparseObjectMatrix1D(n);
    }

    public void setQuick(int n, int n2, Object object) {
        if (this.dindex >= 0) {
            if (n2 >= this.dindex && n < this.dlength && n + this.dindex == n2) {
                this.elements[n] = object;
            }
        } else if (n >= -this.dindex && n2 < this.dlength && n + this.dindex == n2) {
            this.elements[n2] = object;
        }
    }

    protected ObjectMatrix2D getContent() {
        return this;
    }
}

