/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.LongLongFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DelegateLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DiagonalLongMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class WrapperLongMatrix2D
extends LongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected LongMatrix2D content;

    public WrapperLongMatrix2D(LongMatrix2D longMatrix2D) {
        block3: {
            if (longMatrix2D != null) {
                try {
                    this.setUp(longMatrix2D.rows(), longMatrix2D.columns());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                    throw illegalArgumentException;
                }
            }
        }
        this.content = longMatrix2D;
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D, LongLongFunction longLongFunction) {
        this.checkShape(longMatrix2D);
        if (longMatrix2D instanceof WrapperLongMatrix2D) {
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            LongArrayList longArrayList = new LongArrayList();
            longMatrix2D.getNonZeros(intArrayList, intArrayList2, longArrayList);
            this.assign(longMatrix2D, longLongFunction, intArrayList, intArrayList2);
        } else {
            super.assign(longMatrix2D, longLongFunction);
        }
        return this;
    }

    public LongMatrix2D assign(final int[] nArray) {
        if (this.content instanceof DiagonalLongMatrix2D) {
            int n = ((DiagonalLongMatrix2D)this.content).dlength;
            final long[] lArray = ((DiagonalLongMatrix2D)this.content).elements;
            if (nArray.length != n) {
                throw new IllegalArgumentException("Must have same length: length=" + nArray.length + " dlength=" + n);
            }
            int n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n2 = Math.min(n2, n);
                Future[] futureArray = new Future[n2];
                int n3 = n / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? n : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n5; ++i) {
                                lArray[i] = nArray[i];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < n; ++i) {
                    lArray[i] = nArray[i];
                }
            }
            return this;
        }
        return super.assign(nArray);
    }

    public LongMatrix2D assign(final long[] lArray) {
        if (this.content instanceof DiagonalLongMatrix2D) {
            int n = ((DiagonalLongMatrix2D)this.content).dlength;
            final long[] lArray2 = ((DiagonalLongMatrix2D)this.content).elements;
            if (lArray.length != n) {
                throw new IllegalArgumentException("Must have same length: length=" + lArray.length + " dlength=" + n);
            }
            int n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n2 = Math.min(n2, n);
                Future[] futureArray = new Future[n2];
                int n3 = n / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? n : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n5; ++i) {
                                lArray2[i] = lArray[i];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < n; ++i) {
                    lArray2[i] = lArray[i];
                }
            }
            return this;
        }
        return super.assign(lArray);
    }

    public Object elements() {
        return this.content.elements();
    }

    public synchronized long getQuick(int n, int n2) {
        return this.content.getQuick(n, n2);
    }

    public boolean equals(long l) {
        if (this.content instanceof DiagonalLongMatrix2D) {
            long[] lArray = (long[])this.content.elements();
            for (int i = 0; i < lArray.length; ++i) {
                long l2 = lArray[i];
                long l3 = l - l2;
                if (l3 == 0L) continue;
                return false;
            }
            return true;
        }
        return super.equals(l);
    }

    public boolean equals(Object object) {
        if (this.content instanceof DiagonalLongMatrix2D && object instanceof DiagonalLongMatrix2D) {
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            DiagonalLongMatrix2D diagonalLongMatrix2D = (DiagonalLongMatrix2D)this.content;
            DiagonalLongMatrix2D diagonalLongMatrix2D2 = (DiagonalLongMatrix2D)object;
            if (diagonalLongMatrix2D.columns() != diagonalLongMatrix2D2.columns() || diagonalLongMatrix2D.rows() != diagonalLongMatrix2D2.rows() || diagonalLongMatrix2D.diagonalIndex() != diagonalLongMatrix2D2.diagonalIndex() || diagonalLongMatrix2D.diagonalLength() != diagonalLongMatrix2D2.diagonalLength()) {
                return false;
            }
            long[] lArray = diagonalLongMatrix2D.elements();
            long[] lArray2 = diagonalLongMatrix2D2.elements();
            for (int i = 0; i < lArray.length; ++i) {
                long l = lArray2[i];
                long l2 = lArray[i];
                long l3 = l - l2;
                if (l3 == 0L) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public LongMatrix2D like(int n, int n2) {
        return this.content.like(n, n2);
    }

    public LongMatrix1D like1D(int n) {
        return this.content.like1D(n);
    }

    public synchronized void setQuick(int n, int n2, long l) {
        this.content.setQuick(n, n2, l);
    }

    public LongMatrix1D vectorize() {
        final DenseLongMatrix1D denseLongMatrix1D = new DenseLongMatrix1D((int)this.size());
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                final int n5 = i * n2 * this.rows;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n5;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperLongMatrix2D.this.rows; ++j) {
                                denseLongMatrix1D.setQuick(n++, WrapperLongMatrix2D.this.getQuick(j, i));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    denseLongMatrix1D.setQuick(n6++, this.getQuick(j, i));
                }
            }
        }
        return denseLongMatrix1D;
    }

    public LongMatrix1D viewColumn(int n) {
        return this.viewDice().viewRow(n);
    }

    public LongMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperLongMatrix2D wrapperLongMatrix2D = new WrapperLongMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n, int n2) {
                return this.content.getQuick(n, this.columns - 1 - n2);
            }

            public synchronized void setQuick(int n, int n2, long l) {
                this.content.setQuick(n, this.columns - 1 - n2, l);
            }

            public synchronized long get(int n, int n2) {
                return this.content.get(n, this.columns - 1 - n2);
            }

            public synchronized void set(int n, int n2, long l) {
                this.content.set(n, this.columns - 1 - n2, l);
            }
        };
        wrapperLongMatrix2D.isNoView = false;
        return wrapperLongMatrix2D;
    }

    public LongMatrix2D viewDice() {
        WrapperLongMatrix2D wrapperLongMatrix2D = new WrapperLongMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n, int n2) {
                return this.content.getQuick(n2, n);
            }

            public synchronized void setQuick(int n, int n2, long l) {
                this.content.setQuick(n2, n, l);
            }

            public synchronized long get(int n, int n2) {
                return this.content.get(n2, n);
            }

            public synchronized void set(int n, int n2, long l) {
                this.content.set(n2, n, l);
            }
        };
        wrapperLongMatrix2D.rows = this.columns;
        wrapperLongMatrix2D.columns = this.rows;
        wrapperLongMatrix2D.isNoView = false;
        return wrapperLongMatrix2D;
    }

    public LongMatrix2D viewPart(final int n, final int n2, int n3, int n4) {
        this.checkBox(n, n2, n3, n4);
        WrapperLongMatrix2D wrapperLongMatrix2D = new WrapperLongMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n3, int n22) {
                return this.content.getQuick(n + n3, n2 + n22);
            }

            public synchronized void setQuick(int n3, int n22, long l) {
                this.content.setQuick(n + n3, n2 + n22, l);
            }

            public synchronized long get(int n3, int n22) {
                return this.content.get(n + n3, n2 + n22);
            }

            public synchronized void set(int n3, int n22, long l) {
                this.content.set(n + n3, n2 + n22, l);
            }
        };
        wrapperLongMatrix2D.rows = n3;
        wrapperLongMatrix2D.columns = n4;
        wrapperLongMatrix2D.isNoView = false;
        return wrapperLongMatrix2D;
    }

    public LongMatrix1D viewRow(int n) {
        this.checkRow(n);
        return new DelegateLongMatrix1D(this, n);
    }

    public LongMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperLongMatrix2D wrapperLongMatrix2D = new WrapperLongMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n, int n2) {
                return this.content.getQuick(this.rows - 1 - n, n2);
            }

            public synchronized void setQuick(int n, int n2, long l) {
                this.content.setQuick(this.rows - 1 - n, n2, l);
            }

            public synchronized long get(int n, int n2) {
                return this.content.get(this.rows - 1 - n, n2);
            }

            public synchronized void set(int n, int n2, long l) {
                this.content.set(this.rows - 1 - n, n2, l);
            }
        };
        wrapperLongMatrix2D.isNoView = false;
        return wrapperLongMatrix2D;
    }

    public LongMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        final int[] nArray3 = nArray;
        final int[] nArray4 = nArray2;
        WrapperLongMatrix2D wrapperLongMatrix2D = new WrapperLongMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n, int n2) {
                return this.content.getQuick(nArray3[n], nArray4[n2]);
            }

            public synchronized void setQuick(int n, int n2, long l) {
                this.content.setQuick(nArray3[n], nArray4[n2], l);
            }

            public synchronized long get(int n, int n2) {
                return this.content.get(nArray3[n], nArray4[n2]);
            }

            public synchronized void set(int n, int n2, long l) {
                this.content.set(nArray3[n], nArray4[n2], l);
            }
        };
        wrapperLongMatrix2D.rows = nArray.length;
        wrapperLongMatrix2D.columns = nArray2.length;
        wrapperLongMatrix2D.isNoView = false;
        return wrapperLongMatrix2D;
    }

    public LongMatrix2D viewStrides(final int n, final int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperLongMatrix2D wrapperLongMatrix2D = new WrapperLongMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized long getQuick(int n3, int n22) {
                return this.content.getQuick(n * n3, n2 * n22);
            }

            public synchronized void setQuick(int n3, int n22, long l) {
                this.content.setQuick(n * n3, n2 * n22, l);
            }

            public synchronized long get(int n3, int n22) {
                return this.content.get(n * n3, n2 * n22);
            }

            public synchronized void set(int n3, int n22, long l) {
                this.content.set(n * n3, n2 * n22, l);
            }
        };
        if (this.rows != 0) {
            wrapperLongMatrix2D.rows = (this.rows - 1) / n + 1;
        }
        if (this.columns != 0) {
            wrapperLongMatrix2D.columns = (this.columns - 1) / n2 + 1;
        }
        wrapperLongMatrix2D.isNoView = false;
        return wrapperLongMatrix2D;
    }

    protected LongMatrix2D getContent() {
        return this.content;
    }

    protected LongMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected LongMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }
}

