/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone;

import com.nexagis.jawbone.PartOfSpeech;
import com.nexagis.jawbone.Pointer;
import com.nexagis.jawbone.Synset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexTerm
implements Comparable<IndexTerm> {
    private String lemma = null;
    private PartOfSpeech partOfSpeech;
    private int synsetCount = 0;
    private int pointerCount = 0;
    private String[] pointers;
    private int tagSenseCount = 0;
    private Synset[] synsets;

    protected IndexTerm() {
    }

    public String getLemma() {
        return this.lemma;
    }

    protected void setLemma(String string) {
        this.lemma = string == null || string.indexOf(95) < 0 ? string : string.replace('_', ' ');
    }

    public PartOfSpeech getPartOfSpeech() {
        return this.partOfSpeech;
    }

    protected void setPartOfSpeech(char c) {
        this.partOfSpeech = PartOfSpeech.getInstance(c);
    }

    public int getPointerCount() {
        return this.pointerCount;
    }

    protected void setPointerCount(int n) {
        this.pointerCount = n;
        if (this.pointerCount > 0) {
            this.pointers = new String[this.pointerCount];
        }
    }

    public String[] getPointers() {
        if (this.pointers == null) {
            return null;
        }
        String[] stringArray = new String[this.pointers.length];
        System.arraycopy(this.pointers, 0, stringArray, 0, this.pointers.length);
        return stringArray;
    }

    protected void setPointerSymbol(int n, String string) {
        this.pointers[n] = string;
    }

    public int getSynsetCount() {
        return this.synsetCount;
    }

    protected void setSynsetCount(int n) {
        this.synsetCount = n;
        if (this.synsetCount > 0) {
            this.synsets = new Synset[this.synsetCount];
        }
    }

    public Synset[] getSynsets() {
        if (this.synsets == null) {
            return null;
        }
        Synset[] synsetArray = new Synset[this.synsets.length];
        System.arraycopy(this.synsets, 0, synsetArray, 0, this.synsets.length);
        return synsetArray;
    }

    protected void setSynsetOffset(int n, long l) {
        this.synsets[n] = new Synset(l, this.partOfSpeech);
    }

    public int getTagSenseCount() {
        return this.tagSenseCount;
    }

    protected void setTagSenseCount(int n) {
        this.tagSenseCount = n;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.lemma = null;
        this.pointers = null;
        this.synsets = null;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append("Lemma: ").append(this.lemma).append("  POS: ").append(this.partOfSpeech).append("  Tag-Sense-Count: ").append(this.tagSenseCount);
        stringBuffer.append("\nList of Synsets (").append(this.synsetCount).append(")");
        for (n = 0; n < this.synsetCount; ++n) {
            stringBuffer.append("\n  #").append(n + 1).append(": ").append(Long.toString(this.synsets[n].getSynsetOffset()));
        }
        stringBuffer.append("\nList of Pointers (").append(this.pointerCount).append(")");
        for (n = 0; n < this.pointerCount; ++n) {
            stringBuffer.append("\n  #").append(n + 1).append(": ").append(this.pointers[n]).append(" (").append(Pointer.getPointerDescription(this.partOfSpeech, this.pointers[n])).append(")");
        }
        return stringBuffer.toString();
    }

    @Override
    public int compareTo(IndexTerm indexTerm) {
        if (indexTerm == null) {
            return -1;
        }
        String string = indexTerm.getLemma();
        if (this.lemma == null && string == null) {
            return 0;
        }
        if (this.lemma == null) {
            return 1;
        }
        if (string == null) {
            return -1;
        }
        return this.lemma.compareTo(string);
    }
}

