/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.target;

import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.vikamine.kernel.Describer;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.subgroup.target.SGTarget;
import org.vikamine.kernel.util.IdentityLongDescriber;

public class NumericMultiAttributeTarget
implements SGTarget {
    private final List<Attribute> attributes;

    public NumericMultiAttributeTarget(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public String getId() {
        StringBuffer buffy = new StringBuffer();
        buffy.append("NumericMultiAttributeTarget ={");
        LinkedList<Attribute> sortedAttributes = new LinkedList<Attribute>(this.getAttributes());
        Collections.sort(sortedAttributes, new Comparator<Attribute>(){

            @Override
            public int compare(Attribute o1, Attribute o2) {
                return Collator.getInstance().compare(o1.getId(), o2.getId());
            }
        });
        Iterator iter = sortedAttributes.iterator();
        while (iter.hasNext()) {
            Attribute a = (Attribute)iter.next();
            buffy.append(a.getId());
            if (!iter.hasNext()) continue;
            buffy.append(", ");
        }
        buffy.append("}");
        return buffy.toString();
    }

    @Override
    public String getDescription() {
        return this.getDescription(new IdentityLongDescriber());
    }

    @Override
    public String getDescription(Describer d) {
        StringBuffer buffer = new StringBuffer();
        Iterator<Attribute> attributeIterator = this.getAttributes().iterator();
        while (attributeIterator.hasNext()) {
            Attribute a = attributeIterator.next();
            buffer.append(d.createDescription(a));
            if (!attributeIterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    @Override
    public Collection<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }
}

