/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.chunck;

import org.chocosolver.memory.trailing.StoredInt;
import org.chocosolver.memory.trailing.trail.IStoredIntTrail;
import org.chocosolver.memory.trailing.trail.chunck.ChunckedTrail;
import org.chocosolver.memory.trailing.trail.chunck.IntWorld;

public class ChunckedIntTrail
extends ChunckedTrail<IntWorld>
implements IStoredIntTrail {
    private final int ws;
    private final double loadfactor;

    public ChunckedIntTrail(int ws, int nbWorlds, double loadfactor) {
        this.worlds = new IntWorld[nbWorlds];
        this.ws = ws;
        this.loadfactor = loadfactor;
        this.current = new IntWorld(ws, loadfactor);
        ((IntWorld[])this.worlds)[0] = this.current;
    }

    @Override
    public void worldPush(int worldIndex) {
        if (((IntWorld[])this.worlds)[worldIndex] == null) {
            this.current = new IntWorld(this.ws, this.loadfactor);
            ((IntWorld[])this.worlds)[worldIndex] = (IntWorld)this.current;
        } else {
            this.current = ((IntWorld[])this.worlds)[worldIndex];
            ((IntWorld)this.current).clear();
        }
        if (worldIndex == ((IntWorld[])this.worlds).length - 1) {
            this.resizeWorlds();
        }
    }

    private void resizeWorlds() {
        int newCapacity = (int)((double)((IntWorld[])this.worlds).length * this.loadfactor);
        IntWorld[] tmp = new IntWorld[newCapacity];
        System.arraycopy(this.worlds, 0, tmp, 0, ((IntWorld[])this.worlds).length);
        this.worlds = tmp;
    }

    @Override
    public void savePreviousState(StoredInt v, int oldValue, int oldStamp) {
        ((IntWorld)this.current).savePreviousState(v, oldValue, oldStamp);
    }
}

