/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.continuous.arithmetic;

import java.util.List;
import java.util.TreeSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.expression.continuous.arithmetic.BiCArExpression;
import org.chocosolver.solver.expression.continuous.arithmetic.UnCArExpression;
import org.chocosolver.solver.expression.continuous.relational.BiCReExpression;
import org.chocosolver.solver.expression.continuous.relational.CReExpression;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.util.objects.RealInterval;
import org.chocosolver.util.tools.RealUtils;

public interface CArExpression
extends RealInterval {
    public Model getModel();

    public void tighten();

    public void project(ICause var1) throws ContradictionException;

    public void collectVariables(TreeSet<RealVar> var1);

    public void subExps(List<CArExpression> var1);

    public boolean isolate(RealVar var1, List<CArExpression> var2, List<CArExpression> var3);

    public void init();

    public RealVar realVar(double var1);

    default public CArExpression neg() {
        return new UnCArExpression(Operator.NEG, this);
    }

    default public CArExpression abs() {
        return new UnCArExpression(Operator.ABS, this);
    }

    default public CArExpression add(double y) {
        return new BiCArExpression(Operator.ADD, this, this.getModel().realVar(y));
    }

    default public CArExpression add(CArExpression y) {
        return new BiCArExpression(Operator.ADD, this, y);
    }

    default public CArExpression sub(double y) {
        return new BiCArExpression(Operator.SUB, this, this.getModel().realVar(y));
    }

    default public CArExpression sub(CArExpression y) {
        return new BiCArExpression(Operator.SUB, this, y);
    }

    default public CArExpression mul(double y) {
        return new BiCArExpression(Operator.MUL, this, this.getModel().realVar(y));
    }

    default public CArExpression mul(CArExpression y) {
        return new BiCArExpression(Operator.MUL, this, y);
    }

    default public CArExpression div(double y) {
        return new BiCArExpression(Operator.DIV, this, this.getModel().realVar(y));
    }

    default public CArExpression div(CArExpression y) {
        return new BiCArExpression(Operator.DIV, this, y);
    }

    default public CArExpression pow(double y) {
        return new BiCArExpression(Operator.POW, this, this.getModel().realVar(y));
    }

    default public CArExpression pow(CArExpression y) {
        return new BiCArExpression(Operator.POW, this, y);
    }

    default public CArExpression min(double y) {
        return new BiCArExpression(Operator.MIN, this, this.getModel().realVar(y));
    }

    default public CArExpression min(CArExpression y) {
        return new BiCArExpression(Operator.MIN, this, y);
    }

    default public CArExpression max(double y) {
        return new BiCArExpression(Operator.MAX, this, this.getModel().realVar(y));
    }

    default public CArExpression max(CArExpression y) {
        return new BiCArExpression(Operator.MAX, this, y);
    }

    default public CArExpression atan2(CArExpression y) {
        return new BiCArExpression(Operator.ATAN2, this, y);
    }

    default public CArExpression atan2(double y) {
        return new BiCArExpression(Operator.ATAN2, this, this.getModel().realVar(y));
    }

    default public CArExpression exp() {
        return new UnCArExpression(Operator.EXP, this);
    }

    default public CArExpression ln() {
        return new UnCArExpression(Operator.LN, this);
    }

    default public CArExpression sqr() {
        return new UnCArExpression(Operator.SQR, this);
    }

    default public CArExpression sqrt() {
        return new UnCArExpression(Operator.SQRT, this);
    }

    default public CArExpression cub() {
        return new UnCArExpression(Operator.CUB, this);
    }

    default public CArExpression cbrt() {
        return new UnCArExpression(Operator.CBRT, this);
    }

    default public CArExpression cos() {
        return new UnCArExpression(Operator.COS, this);
    }

    default public CArExpression sin() {
        return new UnCArExpression(Operator.SIN, this);
    }

    default public CArExpression tan() {
        return new UnCArExpression(Operator.TAN, this);
    }

    default public CArExpression acos() {
        return new UnCArExpression(Operator.ACOS, this);
    }

    default public CArExpression asin() {
        return new UnCArExpression(Operator.ASIN, this);
    }

    default public CArExpression atan() {
        return new UnCArExpression(Operator.ATAN, this);
    }

    default public CArExpression cosh() {
        return new UnCArExpression(Operator.COSH, this);
    }

    default public CArExpression sinh() {
        return new UnCArExpression(Operator.SINH, this);
    }

    default public CArExpression tanh() {
        return new UnCArExpression(Operator.TANH, this);
    }

    default public CArExpression acosh() {
        return new UnCArExpression(Operator.ACOSH, this);
    }

    default public CArExpression asinh() {
        return new UnCArExpression(Operator.ASINH, this);
    }

    default public CArExpression atanh() {
        return new UnCArExpression(Operator.ATANH, this);
    }

    default public CReExpression lt(double y) {
        return new BiCReExpression(CReExpression.Operator.LT, this, this.getModel().realVar(y));
    }

    default public CReExpression lt(CArExpression y) {
        return new BiCReExpression(CReExpression.Operator.LT, this, y);
    }

    default public CReExpression le(double y) {
        if (y == 0.0) {
            y = RealUtils.prevFloat(0.0);
        }
        return new BiCReExpression(CReExpression.Operator.LE, this, this.getModel().realVar(y));
    }

    default public CReExpression le(CArExpression y) {
        return new BiCReExpression(CReExpression.Operator.LE, this, y);
    }

    default public CReExpression gt(double y) {
        return new BiCReExpression(CReExpression.Operator.GT, this, this.getModel().realVar(y));
    }

    default public CReExpression gt(CArExpression y) {
        return new BiCReExpression(CReExpression.Operator.GT, this, y);
    }

    default public CReExpression ge(double y) {
        if (y == 0.0) {
            y = RealUtils.nextFloat(0.0);
        }
        return new BiCReExpression(CReExpression.Operator.GE, this, this.getModel().realVar(y));
    }

    default public CReExpression ge(CArExpression y) {
        return new BiCReExpression(CReExpression.Operator.GE, this, y);
    }

    default public CReExpression eq(double y) {
        return new BiCReExpression(CReExpression.Operator.EQ, this, this.getModel().realVar(y));
    }

    default public CReExpression eq(CArExpression y) {
        return new BiCReExpression(CReExpression.Operator.EQ, this, y);
    }

    public static enum Operator {
        NEG{}
        ,
        ABS{}
        ,
        ADD{}
        ,
        SUB{}
        ,
        MUL{}
        ,
        DIV{}
        ,
        SQR{}
        ,
        CUB{}
        ,
        POW{}
        ,
        MIN{}
        ,
        MAX{}
        ,
        ATAN2{}
        ,
        EXP{}
        ,
        LN{}
        ,
        SQRT{}
        ,
        CBRT{}
        ,
        COS{}
        ,
        SIN{}
        ,
        TAN{}
        ,
        ACOS{}
        ,
        ASIN{}
        ,
        ATAN{}
        ,
        COSH{}
        ,
        SINH{}
        ,
        TANH{}
        ,
        ACOSH{}
        ,
        ASINH{}
        ,
        ATANH{};

    }
}

