/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import org.chocosolver.sat.Literalizer;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.sat.SatDecorator;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.nary.cnf.ILogical;
import org.chocosolver.solver.constraints.nary.cnf.LogOp;
import org.chocosolver.solver.constraints.nary.cnf.LogicTreeToolBox;
import org.chocosolver.solver.constraints.nary.sat.PropSat;
import org.chocosolver.solver.constraints.reification.LocalConstructiveDisjunction;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public interface ISatFactory
extends ISelf<Model> {
    default public int satVar(Variable var, Literalizer ltz) {
        PropSat psat = ((Model)this.ref()).getMinisat().getPropSat();
        SatDecorator msat = (SatDecorator)psat.getMiniSat();
        return msat.bind(var, ltz, psat::lazyAddVar);
    }

    default public int lit(int svar) {
        return MiniSat.makeLiteral(svar, true);
    }

    default public int neg(int svar) {
        return MiniSat.makeLiteral(svar, false);
    }

    default public boolean addClause(int ... lits) {
        PropSat psat = ((Model)this.ref()).getMinisat().getPropSat();
        SatDecorator msat = (SatDecorator)psat.getMiniSat();
        TIntArrayList mlits = new TIntArrayList(lits);
        return msat.addClause(mlits);
    }

    default public boolean addClauses(LogOp TREE) {
        ILogical tree = LogicTreeToolBox.toCNF(TREE, (Model)this.ref());
        boolean ret = true;
        if (((Model)this.ref()).boolVar(true).equals(tree)) {
            ret = this.addClauseTrue(((Model)this.ref()).boolVar(true));
        } else if (((Model)this.ref()).boolVar(false).equals(tree)) {
            ret = this.addClauseTrue(((Model)this.ref()).boolVar(false));
        } else {
            ILogical[] clauses = !tree.isLit() && ((LogOp)tree).is(LogOp.Operator.AND) ? ((LogOp)tree).getChildren() : new ILogical[]{tree};
            for (int i = 0; i < clauses.length; ++i) {
                ILogical clause = clauses[i];
                if (clause.isLit()) {
                    BoolVar bv = (BoolVar)clause;
                    ret &= this.addClauseTrue(bv);
                    continue;
                }
                LogOp n = (LogOp)clause;
                BoolVar[] bvars = n.flattenBoolVar();
                if (((Model)this.ref()).getSettings().enableSAT()) {
                    TIntArrayList lits = new TIntArrayList(bvars.length);
                    PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
                    sat.beforeAddingClauses();
                    for (int j = 0; j < bvars.length; ++j) {
                        lits.add(MiniSat.makeLiteral(sat.makeBool(bvars[j]), true));
                    }
                    ret &= sat.addClause(lits);
                    sat.afterAddingClauses();
                    continue;
                }
                ((Model)this.ref()).sum(bvars, ">", 0).post();
            }
        }
        return ret;
    }

    default public boolean addClauses(BoolVar[] POSLITS, BoolVar[] NEGLITS) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] pos = new int[POSLITS.length];
            for (int i = 0; i < POSLITS.length; ++i) {
                pos[i] = sat.makeBool(POSLITS[i]);
            }
            int[] neg = new int[NEGLITS.length];
            for (int i = 0; i < NEGLITS.length; ++i) {
                neg[i] = sat.makeBool(NEGLITS[i]);
            }
            boolean add = sat.getMiniSat().addClause(pos, neg);
            sat.afterAddingClauses();
            return add;
        }
        int PL = POSLITS.length;
        int NL = NEGLITS.length;
        BoolVar[] LITS = new BoolVar[PL + NL];
        System.arraycopy(POSLITS, 0, LITS, 0, PL);
        for (int i = 0; i < NL; ++i) {
            LITS[i + PL] = NEGLITS[i].not();
        }
        ((Model)this.ref()).sum(LITS, ">", 0).post();
        return true;
    }

    default public boolean addClauseTrue(BoolVar BOOLVAR) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getMiniSat().addTrue(sat.makeBool(BOOLVAR));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)BOOLVAR, "=", 1).post();
        return true;
    }

    default public boolean addClauseFalse(BoolVar BOOLVAR) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getMiniSat().addFalse(sat.makeBool(BOOLVAR));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)BOOLVAR, "=", 0).post();
        return true;
    }

    default public boolean addClausesBoolEq(BoolVar LEFT, BoolVar RIGHT) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getMiniSat().addBoolEq(sat.makeBool(LEFT), sat.makeBool(RIGHT));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)LEFT, "=", RIGHT).post();
        return true;
    }

    default public boolean addClausesBoolLe(BoolVar LEFT, BoolVar RIGHT) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getMiniSat().addBoolLe(sat.makeBool(LEFT), sat.makeBool(RIGHT));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)LEFT, "<=", RIGHT).post();
        return true;
    }

    default public boolean addClausesBoolLt(BoolVar LEFT, BoolVar RIGHT) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getMiniSat().addBoolLt(sat.makeBool(LEFT), sat.makeBool(RIGHT));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)LEFT, "<", RIGHT).post();
        return true;
    }

    default public boolean addClausesBoolNot(BoolVar LEFT, BoolVar RIGHT) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getMiniSat().addBoolNot(sat.makeBool(LEFT), sat.makeBool(RIGHT));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)LEFT, "!=", RIGHT).post();
        return true;
    }

    default public boolean addClausesBoolOrArrayEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeBool(BOOLVARS[i]);
            }
            boolean add = sat.getMiniSat().addBoolOrArrayEqVar(vars, sat.makeBool(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).max(TARGET, BOOLVARS).post();
        return true;
    }

    default public boolean addClausesBoolAndArrayEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeBool(BOOLVARS[i]);
            }
            boolean add = sat.getMiniSat().addBoolAndArrayEqVar(vars, sat.makeBool(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).min(TARGET, BOOLVARS).post();
        return true;
    }

    default public boolean addClausesBoolOrEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getMiniSat().addBoolOrEqVar(sat.makeBool(LEFT), sat.makeBool(RIGHT), sat.makeBool(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)LEFT, "+", (IntVar)RIGHT, ">", 0).reifyWith(TARGET);
        return true;
    }

    default public boolean addClausesBoolAndEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getMiniSat().addBoolAndEqVar(sat.makeBool(LEFT), sat.makeBool(RIGHT), sat.makeBool(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)LEFT, "+", (IntVar)RIGHT, "=", 2).reifyWith(TARGET);
        return true;
    }

    default public boolean addClausesBoolXorEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        return this.addClausesBoolIsNeqVar(LEFT, RIGHT, TARGET);
    }

    default public boolean addClausesBoolIsEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getMiniSat().addBoolIsEqVar(sat.makeBool(LEFT), sat.makeBool(RIGHT), sat.makeBool(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).reifyXeqY(LEFT, RIGHT, TARGET);
        return true;
    }

    default public boolean addClausesBoolIsNeqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getMiniSat().addBoolIsNeqVar(sat.makeBool(LEFT), sat.makeBool(RIGHT), sat.makeBool(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).reifyXneY(LEFT, RIGHT, TARGET);
        return true;
    }

    default public boolean addClausesBoolIsLeVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getMiniSat().addBoolIsLeVar(sat.makeBool(LEFT), sat.makeBool(RIGHT), sat.makeBool(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).reifyXleY(LEFT, RIGHT, TARGET);
        return true;
    }

    default public boolean addClausesBoolIsLtVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getMiniSat().addBoolIsLtVar(sat.makeBool(LEFT), sat.makeBool(RIGHT), sat.makeBool(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).reifyXltY(LEFT, RIGHT, TARGET);
        return true;
    }

    default public boolean addClausesBoolOrArrayEqualTrue(BoolVar[] BOOLVARS) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeBool(BOOLVARS[i]);
            }
            boolean add = sat.getMiniSat().addBoolOrArrayEqualTrue(vars);
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).sum(BOOLVARS, ">", 0).post();
        return true;
    }

    default public boolean addClausesBoolAndArrayEqualFalse(BoolVar[] BOOLVARS) {
        return this.addClausesAtMostNMinusOne(BOOLVARS);
    }

    default public boolean addClausesAtMostOne(BoolVar[] BOOLVARS) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeBool(BOOLVARS[i]);
            }
            boolean add = sat.getMiniSat().addAtMostOne(vars);
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).sum(BOOLVARS, "<", 2).post();
        return true;
    }

    default public boolean addClausesAtMostNMinusOne(BoolVar[] BOOLVARS) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeBool(BOOLVARS[i]);
            }
            boolean add = sat.getMiniSat().addAtMostNMinusOne(vars);
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).sum(BOOLVARS, "<", BOOLVARS.length).post();
        return true;
    }

    default public boolean addClausesSumBoolArrayGreaterEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeBool(BOOLVARS[i]);
            }
            boolean add = sat.getMiniSat().addSumBoolArrayGreaterEqVar(vars, sat.makeBool(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).sum(BOOLVARS, ">=", (IntVar)TARGET).post();
        return true;
    }

    default public boolean addClausesMaxBoolArrayLessEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeBool(BOOLVARS[i]);
            }
            boolean add = sat.getMiniSat().addMaxBoolArrayLessEqVar(vars, sat.makeBool(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        BoolVar max = ((Model)this.ref()).boolVar(((Model)this.ref()).generateName("bool_max"));
        ((Model)this.ref()).max(max, BOOLVARS).post();
        max.le(TARGET).post();
        return true;
    }

    default public boolean addClausesSumBoolArrayLessEqKVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this.ref()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this.ref()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = false;
            if (BOOLVARS.length == 1) {
                add = this.addClausesBoolLe(BOOLVARS[0], TARGET);
            }
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeBool(BOOLVARS[i]);
            }
            sat.afterAddingClauses();
            return add |= sat.getMiniSat().addSumBoolArrayLessEqKVar(vars, sat.makeBool(TARGET));
        }
        int[] coeffs = new int[BOOLVARS.length + 1];
        Arrays.fill(coeffs, 1);
        coeffs[BOOLVARS.length] = -BOOLVARS.length;
        IntVar[] nBOOLVARS = new BoolVar[BOOLVARS.length + 1];
        System.arraycopy(BOOLVARS, 0, nBOOLVARS, 0, BOOLVARS.length);
        nBOOLVARS[BOOLVARS.length] = TARGET;
        ((Model)this.ref()).scalar(nBOOLVARS, coeffs, "<=", 0).post();
        return true;
    }

    default public boolean addConstructiveDisjunction(Constraint ... cstrs) {
        new LocalConstructiveDisjunction(cstrs).post();
        return true;
    }
}

