/*
 * Decompiled with CFR 0.152.
 */
package io.github.dan2097.jnainchi;

import io.github.dan2097.jnainchi.InchiAtom;
import io.github.dan2097.jnainchi.InchiBondStereo;
import io.github.dan2097.jnainchi.InchiBondType;

public class InchiBond {
    private final InchiAtom start;
    private final InchiAtom end;
    private final InchiBondType type;
    private final InchiBondStereo stereo;

    public InchiBond(InchiAtom start, InchiAtom end, InchiBondType type) {
        this(start, end, type, InchiBondStereo.NONE);
    }

    public InchiBond(InchiAtom start, InchiAtom end, InchiBondType type, InchiBondStereo stereo) {
        if (start.equals(end)) {
            throw new IllegalArgumentException("start and end must be different atoms");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (stereo == null) {
            throw new IllegalArgumentException("stereo must not be null, use InchiBondStereo.NONE");
        }
        this.start = start;
        this.end = end;
        this.type = type;
        this.stereo = stereo;
    }

    public InchiAtom getStart() {
        return this.start;
    }

    public InchiAtom getEnd() {
        return this.end;
    }

    public InchiBondType getType() {
        return this.type;
    }

    public InchiBondStereo getStereo() {
        return this.stereo;
    }

    public InchiAtom getOther(InchiAtom atom) {
        if (this.start == atom) {
            return this.end;
        }
        if (this.end == atom) {
            return this.start;
        }
        return null;
    }
}

