/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.optimization.cmaes;

import fr.inria.optimization.cmaes.ISolutionPoint;
import java.io.Serializable;

public class CMASolution
implements ISolutionPoint,
Serializable {
    private static final long serialVersionUID = 6257830429350615236L;
    private double functionValue = Double.NaN;
    private double[] x;
    private long evaluation = 0L;

    public CMASolution() {
    }

    public CMASolution(double[] x, double fitnessValue, long evaluation) {
        this.functionValue = fitnessValue;
        this.x = (double[])x.clone();
        this.evaluation = evaluation;
    }

    public CMASolution deepCopy() {
        return new CMASolution(this.x, this.functionValue, this.evaluation);
    }

    public CMASolution(double[] x) {
        this.x = x;
    }

    @Override
    public double getFitness() {
        return this.functionValue;
    }

    @Override
    public long getEvaluationNumber() {
        return this.evaluation;
    }

    @Override
    public double[] getX() {
        return (double[])this.x.clone();
    }

    @Override
    public void setFitness(double f) {
        this.functionValue = f;
    }

    @Override
    public void setEvaluationNumber(long e) {
        this.evaluation = e;
    }

    @Override
    public void setX(double[] x_in) {
        this.x = new double[x_in.length];
        int i = 0;
        while (i < this.x.length) {
            this.x[i] = x_in[i];
            ++i;
        }
    }
}

