/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.global;

import choco.IPretty;
import choco.kernel.common.util.tools.IteratorUtils;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.branch.Extension;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.constraints.global.scheduling.IResource;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MetaSConstraint
implements SConstraint,
IResource<TaskVar> {
    private static final TaskVar[] EMPTY_TASK_ARRAY = new TaskVar[0];
    private static final IntDomainVar[] EMPTY_INTVAR_ARRAY = new IntDomainVar[0];
    public final IntDomainVar[] vars;
    public final TaskVar[] tasks;
    public final SConstraint[] constraints;
    public final SConstraintType type;
    protected String name;

    public MetaSConstraint(String name, SConstraint[] constraints, TaskVar[] tasks, IntDomainVar[] vars) {
        this(constraints, tasks, vars);
        this.name = name;
    }

    public MetaSConstraint(SConstraint[] constraints, TaskVar[] tasks, IntDomainVar[] vars) {
        if (constraints == null || constraints.length == 0) {
            throw new SolverException("Empty MetaConstraint !?");
        }
        this.constraints = constraints;
        this.vars = vars == null ? EMPTY_INTVAR_ARRAY : vars;
        this.tasks = tasks == null ? EMPTY_TASK_ARRAY : tasks;
        this.type = MetaSConstraint.computeType(constraints);
    }

    private static SConstraintType computeType(SConstraint[] constraints) {
        SConstraintType type = constraints[0].getConstraintType();
        if (SConstraintType.EXPRESSION.equals((Object)type)) {
            return SConstraintType.EXPRESSION;
        }
        for (int i = 1; i < constraints.length; ++i) {
            if (SConstraintType.EXPRESSION.equals((Object)type)) {
                return SConstraintType.EXPRESSION;
            }
            if (constraints[i].getConstraintType().equals((Object)type)) continue;
            type = SConstraintType.MIXED;
        }
        return type;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public void addListener(boolean dynamicAddition) {
    }

    @Override
    public final int getConstraintIdx(int idx) {
        return -1;
    }

    @Override
    public final int getNbVars() {
        return this.vars.length + this.tasks.length;
    }

    public final Var getVar(int i) {
        return i < this.tasks.length ? this.tasks[i] : this.vars[i];
    }

    public final Var getVarQuick(int i) {
        return this.getVar(i);
    }

    @Override
    public final TaskVar getTask(int i) {
        return this.tasks[i];
    }

    public final int getNbSubConstraints() {
        return this.constraints.length;
    }

    public final SConstraint getSubConstraints(int i) {
        return this.constraints[i];
    }

    @Override
    public boolean isSatisfied() {
        for (SConstraint c : this.constraints) {
            if (c.isSatisfied()) continue;
            return false;
        }
        return true;
    }

    public AbstractSConstraint opposite(Solver solver) {
        throw new UnsupportedOperationException("opposite is not supported");
    }

    @Override
    public final void setConstraintIndex(int i, int idx) {
        throw new UnsupportedOperationException("index is useless");
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final void setVar(int i, Var v) {
        throw new UnsupportedOperationException("cant change the scope of a meta constraint.");
    }

    @Override
    public String pretty() {
        return "intvars" + StringUtils.pretty((IPretty[])this.vars) + "\ntasks" + StringUtils.pretty((IPretty[])this.tasks) + "\nsubconstraints" + StringUtils.pretty((IPretty[])this.constraints);
    }

    @Override
    public List<TaskVar> asTaskList() {
        return Arrays.asList(this.tasks);
    }

    @Override
    public int getNbTasks() {
        return this.tasks.length;
    }

    @Override
    public String getRscName() {
        return this.name;
    }

    @Override
    public IRTask getRTask(int idx) {
        return null;
    }

    @Override
    public List<IRTask> asRTaskList() {
        return Collections.emptyList();
    }

    @Override
    public Iterator<IRTask> getRTaskIterator() {
        return this.asRTaskList().iterator();
    }

    @Override
    public Iterator<TaskVar> getTaskIterator() {
        return IteratorUtils.iterator(this.tasks);
    }

    @Override
    public SConstraintType getConstraintType() {
        return this.type;
    }

    @Override
    public int getNbOptionalTasks() {
        return 0;
    }

    @Override
    public int getNbRegularTasks() {
        return this.getNbTasks();
    }

    @Override
    public Extension getExtension(int extensionNumber) {
        return null;
    }

    @Override
    public void addExtension(int extensionNumber) {
    }

    @Override
    public int getFineDegree(int idx) {
        return this.constraints.length;
    }
}

