/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.copy;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IStateLongVector;
import choco.kernel.memory.copy.EnvironmentCopying;
import choco.kernel.memory.copy.RcInt;
import choco.kernel.memory.copy.RecomputableElement;

public class RcLongVector
implements IStateLongVector,
RecomputableElement {
    public static final int MIN_CAPACITY = 8;
    private long[] elementData;
    private RcInt size;
    private final EnvironmentCopying environment;
    private int timeStamp;

    public RcLongVector(EnvironmentCopying env, int initialSize, long initialValue) {
        int initialCapacity = 8;
        int w = env.getWorldIndex();
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.timeStamp = this.environment.getWorldIndex();
        this.elementData = new long[initialCapacity];
        for (int i = 0; i < initialSize; ++i) {
            this.elementData[i] = initialValue;
        }
        this.size = new RcInt(env, initialSize);
        env.add(this);
    }

    public RcLongVector(EnvironmentCopying env, long[] entries) {
        int initialCapacity = 8;
        int w = env.getWorldIndex();
        int initialSize = entries.length;
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.elementData = new long[initialCapacity];
        for (int i = 0; i < initialSize; ++i) {
            this.elementData[i] = entries[i];
        }
        this.size = new RcInt(env, initialSize);
        env.add(this);
        this.timeStamp = this.environment.getWorldIndex();
    }

    public RcLongVector(EnvironmentCopying env) {
        this(env, 0, 0L);
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            long[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new long[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size.get());
        }
    }

    @Override
    public void add(long i) {
        this.timeStamp = this.environment.getWorldIndex();
        int newsize = this.size.get() + 1;
        this.ensureCapacity(newsize);
        this.size.set(newsize);
        this.elementData[newsize - 1] = i;
    }

    @Override
    public void removeLast() {
        this.timeStamp = this.environment.getWorldIndex();
        int newsize = this.size.get() - 1;
        if (newsize >= 0) {
            this.size.set(newsize);
        }
    }

    @Override
    public long get(int index) {
        if (index < this.size.get() && index >= 0) {
            return this.elementData[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public long quickGet(int index) {
        return this.elementData[index];
    }

    @Override
    public boolean contain(long val) {
        int ssize = this.size.get();
        for (int i = 0; i < ssize; ++i) {
            if (val != this.elementData[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public long set(int index, long val) {
        if (index < this.size.get() && index >= 0) {
            long oldValue = this.elementData[index];
            if (val != oldValue) {
                this.elementData[index] = val;
            }
            this.timeStamp = this.environment.getWorldIndex();
            return oldValue;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public long quickSet(int index, long val) {
        long oldValue = this.elementData[index];
        if (val != oldValue) {
            this.elementData[index] = val;
        }
        this.timeStamp = this.environment.getWorldIndex();
        return oldValue;
    }

    public int[] toArray(int[] tab) {
        return new int[0];
    }

    @Override
    public void remove(int i) {
    }

    public void _set(long[] vals) {
        this.timeStamp = this.environment.getWorldIndex();
        System.arraycopy(vals, 0, this.elementData, 0, vals.length);
    }

    public void _set(long[] vals, int timeStamp) {
        this.timeStamp = timeStamp;
        System.arraycopy(vals, 0, this.elementData, 0, vals.length);
    }

    public long[] deepCopy() {
        long[] ret = new long[this.size.get()];
        System.arraycopy(this.elementData, 0, ret, 0, this.size.get());
        return ret;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public int getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public DisposableIntIterator getIterator() {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

