/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.KolmogorovSmirnovDist;
import umontreal.iro.lecuyer.probdist.KolmogorovSmirnovPlusDist;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class KolmogorovSmirnovDistQuick
extends KolmogorovSmirnovDist {
    private static final int NKOLMO = 100000;

    public KolmogorovSmirnovDistQuick(int n) {
        super(n);
    }

    public double density(double x) {
        return KolmogorovSmirnovDistQuick.density(this.n, x);
    }

    public double cdf(double x) {
        return KolmogorovSmirnovDistQuick.cdf(this.n, x);
    }

    public double barF(double x) {
        return KolmogorovSmirnovDistQuick.barF(this.n, x);
    }

    public double inverseF(double u) {
        return KolmogorovSmirnovDistQuick.inverseF(this.n, u);
    }

    public static double density(int n, double x) {
        double Res = KolmogorovSmirnovDistQuick.densConnue(n, x);
        if (Res != -1.0) {
            return Res;
        }
        double EPS = 1.0 / Num.TWOEXP[6];
        Res = (KolmogorovSmirnovDistQuick.cdf(n, x + EPS) - KolmogorovSmirnovDistQuick.cdf(n, x - EPS)) / (2.0 * EPS);
        if (Res <= 0.0) {
            return 0.0;
        }
        return Res;
    }

    private static double Pelz(int n, double x) {
        double ti;
        int j;
        int JMAX = 20;
        double EPS = 1.0E-10;
        double RACN = Math.sqrt(n);
        double z = RACN * x;
        double z2 = z * z;
        double z4 = z2 * z2;
        double z6 = z4 * z2;
        double C2PI = 2.506628274631001;
        double DPI2 = 1.2533141373155001;
        double PI2 = Math.PI * Math.PI;
        double PI4 = 97.40909103400243;
        double w = Math.PI * Math.PI / (2.0 * z * z);
        double term = 1.0;
        double sum = 0.0;
        for (j = 0; j <= 20 && term > 1.0E-10 * sum; ++j) {
            ti = (double)j + 0.5;
            term = Math.exp(-ti * ti * w);
            sum += term;
        }
        sum *= 2.506628274631001 / z;
        term = 1.0;
        double tom = 0.0;
        for (j = 0; j <= 20 && Math.abs(term) > 1.0E-10 * Math.abs(tom); ++j) {
            ti = (double)j + 0.5;
            term = (Math.PI * Math.PI * ti * ti - z2) * Math.exp(-ti * ti * w);
            tom += term;
        }
        sum += tom * 1.2533141373155001 / (RACN * 3.0 * z4);
        term = 1.0;
        tom = 0.0;
        for (j = 0; j <= 20 && Math.abs(term) > 1.0E-10 * Math.abs(tom); ++j) {
            ti = (double)j + 0.5;
            term = 6.0 * z6 + 2.0 * z4 + Math.PI * Math.PI * (2.0 * z4 - 5.0 * z2) * ti * ti + 97.40909103400243 * (1.0 - 2.0 * z2) * ti * ti * ti * ti;
            tom += (term *= Math.exp(-ti * ti * w));
        }
        sum += tom * 1.2533141373155001 / ((double)n * 36.0 * z * z6);
        term = 1.0;
        tom = 0.0;
        for (j = 1; j <= 20 && term > 1.0E-10 * tom; ++j) {
            ti = j;
            term = Math.PI * Math.PI * ti * ti * Math.exp(-ti * ti * w);
            tom += term;
        }
        sum -= tom * 1.2533141373155001 / ((double)n * 18.0 * z * z2);
        term = 1.0;
        tom = 0.0;
        for (j = 0; j <= 20 && Math.abs(term) > 1.0E-10 * Math.abs(tom); ++j) {
            ti = (double)j + 0.5;
            ti *= ti;
            term = -30.0 * z6 - 90.0 * z6 * z2 + Math.PI * Math.PI * (135.0 * z4 - 96.0 * z6) * ti + 97.40909103400243 * (212.0 * z4 - 60.0 * z2) * ti * ti + 961.3891935753043 * ti * ti * ti * (5.0 - 30.0 * z2);
            tom += (term *= Math.exp(-ti * w));
        }
        sum += tom * 1.2533141373155001 / (RACN * (double)n * 3240.0 * z4 * z6);
        term = 1.0;
        tom = 0.0;
        for (j = 1; j <= 20 && Math.abs(term) > 1.0E-10 * Math.abs(tom); ++j) {
            ti = j * j;
            term = (29.608813203268074 * ti * z2 - 97.40909103400243 * ti * ti) * Math.exp(-ti * w);
            tom += term;
        }
        return sum += tom * 1.2533141373155001 / (RACN * (double)n * 108.0 * z6);
    }

    private static void CalcFloorCeil(int n, double t, double[] A, double[] Atflo, double[] Atcei) {
        int i;
        int ell = (int)t;
        double z = t - (double)ell;
        double w = Math.ceil(t) - t;
        if (z > 0.5) {
            for (i = 2; i <= 2 * n + 2; i += 2) {
                Atflo[i] = i / 2 - 2 - ell;
            }
            for (i = 1; i <= 2 * n + 2; i += 2) {
                Atflo[i] = i / 2 - 1 - ell;
            }
            for (i = 2; i <= 2 * n + 2; i += 2) {
                Atcei[i] = i / 2 + ell;
            }
            for (i = 1; i <= 2 * n + 2; i += 2) {
                Atcei[i] = i / 2 + 1 + ell;
            }
        } else if (z > 0.0) {
            for (i = 1; i <= 2 * n + 2; ++i) {
                Atflo[i] = i / 2 - 1 - ell;
            }
            for (i = 2; i <= 2 * n + 2; ++i) {
                Atcei[i] = i / 2 + ell;
            }
            Atcei[1] = 1 + ell;
        } else {
            for (i = 2; i <= 2 * n + 2; i += 2) {
                Atflo[i] = i / 2 - 1 - ell;
            }
            for (i = 1; i <= 2 * n + 2; i += 2) {
                Atflo[i] = i / 2 - ell;
            }
            for (i = 2; i <= 2 * n + 2; i += 2) {
                Atcei[i] = i / 2 - 1 + ell;
            }
            for (i = 1; i <= 2 * n + 2; i += 2) {
                Atcei[i] = i / 2 + ell;
            }
        }
        if (w < z) {
            z = w;
        }
        A[1] = 0.0;
        A[0] = 0.0;
        A[2] = z;
        A[3] = 1.0 - A[2];
        for (i = 4; i <= 2 * n + 1; ++i) {
            A[i] = A[i - 2] + 1.0;
        }
        A[2 * n + 2] = n;
    }

    private static double Pomeranz(int n, double x) {
        double sum;
        int j;
        double EPS = 1.0E-15;
        int ENO = 350;
        double RENO = Math.scalb(1.0, 350);
        double t = (double)n * x;
        double[] A = new double[2 * n + 3];
        double[] Atflo = new double[2 * n + 3];
        double[] Atcei = new double[2 * n + 3];
        double[][] V = new double[2][n + 2];
        double[][] H = new double[4][n + 2];
        KolmogorovSmirnovDistQuick.CalcFloorCeil(n, t, A, Atflo, Atcei);
        for (j = 1; j <= n + 1; ++j) {
            V[0][j] = 0.0;
        }
        for (j = 2; j <= n + 1; ++j) {
            V[1][j] = 0.0;
        }
        V[1][1] = RENO;
        int coreno = 1;
        H[0][0] = 1.0;
        double w = 2.0 * A[2] / (double)n;
        for (j = 1; j <= n + 1; ++j) {
            H[0][j] = w * H[0][j - 1] / (double)j;
        }
        H[1][0] = 1.0;
        w = (1.0 - 2.0 * A[2]) / (double)n;
        for (j = 1; j <= n + 1; ++j) {
            H[1][j] = w * H[1][j - 1] / (double)j;
        }
        H[2][0] = 1.0;
        w = A[2] / (double)n;
        for (j = 1; j <= n + 1; ++j) {
            H[2][j] = w * H[2][j - 1] / (double)j;
        }
        H[3][0] = 1.0;
        for (j = 1; j <= n + 1; ++j) {
            H[3][j] = 0.0;
        }
        int r1 = 0;
        int r2 = 1;
        for (int i = 2; i <= 2 * n + 2; ++i) {
            int klow;
            int jup;
            int jlow = (int)(2.0 + Atflo[i]);
            if (jlow < 1) {
                jlow = 1;
            }
            if ((jup = (int)Atcei[i]) > n + 1) {
                jup = n + 1;
            }
            if ((klow = (int)(2.0 + Atflo[i - 1])) < 1) {
                klow = 1;
            }
            int kup0 = (int)Atcei[i - 1];
            w = (A[i] - A[i - 1]) / (double)n;
            int s = -1;
            for (j = 0; j < 4; ++j) {
                if (!(Math.abs(w - H[j][1]) <= 1.0E-15)) continue;
                s = j;
                break;
            }
            double minsum = RENO;
            r1 = r1 + 1 & 1;
            r2 = r2 + 1 & 1;
            for (j = jlow; j <= jup; ++j) {
                int kup = kup0;
                if (kup > j) {
                    kup = j;
                }
                sum = 0.0;
                for (int k = kup; k >= klow; --k) {
                    sum += V[r1][k] * H[s][j - k];
                }
                V[r2][j] = sum;
                if (!(sum < minsum)) continue;
                minsum = sum;
            }
            if (!(minsum < 1.0E-280)) continue;
            j = jlow;
            while (j <= jup) {
                double[] dArray = V[r2];
                int n2 = j++;
                dArray[n2] = dArray[n2] * RENO;
            }
            ++coreno;
        }
        sum = V[r2][n + 1];
        w = Num.lnFactorial(n) - (double)(coreno * 350) * 0.6931471805599453 + Math.log(sum);
        if (w >= 0.0) {
            return 1.0;
        }
        return Math.exp(w);
    }

    public static double cdf(int n, double x) {
        double u = KolmogorovSmirnovDistQuick.cdfConnu(n, x);
        if (u >= 0.0) {
            return u;
        }
        double w = (double)n * x * x;
        if (n <= 500) {
            if (w < 0.754693) {
                return KolmogorovSmirnovDistQuick.DurbinMatrix(n, x);
            }
            if (w < 4.0) {
                return KolmogorovSmirnovDistQuick.Pomeranz(n, x);
            }
            return 1.0 - KolmogorovSmirnovDistQuick.barF(n, x);
        }
        if (w * x * (double)n <= 7.0 && n <= 100000) {
            return KolmogorovSmirnovDistQuick.DurbinMatrix(n, x);
        }
        return KolmogorovSmirnovDistQuick.Pelz(n, x);
    }

    public static double barF(int n, double x) {
        double v = KolmogorovSmirnovDistQuick.barFConnu(n, x);
        if (v >= 0.0) {
            return v;
        }
        double w = (double)n * x * x;
        if (n <= 500) {
            if (w < 4.0) {
                return 1.0 - KolmogorovSmirnovDistQuick.cdf(n, x);
            }
            return 2.0 * KolmogorovSmirnovPlusDist.KSPlusbarUpper(n, x);
        }
        if (w >= 2.65) {
            return 2.0 * KolmogorovSmirnovPlusDist.KSPlusbarUpper(n, x);
        }
        return 1.0 - KolmogorovSmirnovDistQuick.cdf(n, x);
    }

    public static double inverseF(int n, double u) {
        double Res = KolmogorovSmirnovDistQuick.inverseConnue(n, u);
        if (Res != -1.0) {
            return Res;
        }
        Function f = new Function(n, u);
        return RootFinder.brentDekker(0.5 / (double)n, 1.0, f, 1.0E-5);
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double u;

        public Function(int n, double u) {
            this.n = n;
            this.u = u;
        }

        public double evaluate(double x) {
            return this.u - KolmogorovSmirnovDistQuick.cdf(this.n, x);
        }
    }
}

