// SPDX-License-Identifier: Apache-2.0
//
// Copyright 2008-2016 Conrad Sanderson (http://conradsanderson.id.au)
// Copyright 2008-2016 National ICT Australia (NICTA)
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// ------------------------------------------------------------------------

//! \addtogroup OpCube
//! @{

template <typename T1, typename op_type>
OpCube<T1, op_type>::OpCube(const BaseCube<typename T1::elem_type, T1>& in_m)
    : m(in_m.get_ref()) {
  arma_extra_debug_sigprint();
}

template <typename T1, typename op_type>
OpCube<T1, op_type>::OpCube(const BaseCube<typename T1::elem_type, T1>& in_m,
                            const typename T1::elem_type in_aux)
    : m(in_m.get_ref()), aux(in_aux) {
  arma_extra_debug_sigprint();
}

template <typename T1, typename op_type>
OpCube<T1, op_type>::OpCube(const BaseCube<typename T1::elem_type, T1>& in_m,
                            const typename T1::elem_type in_aux,
                            const uword in_aux_uword_a, const uword in_aux_uword_b,
                            const uword in_aux_uword_c)
    : m(in_m.get_ref()),
      aux(in_aux),
      aux_uword_a(in_aux_uword_a),
      aux_uword_b(in_aux_uword_b),
      aux_uword_c(in_aux_uword_c) {
  arma_extra_debug_sigprint();
}

template <typename T1, typename op_type>
OpCube<T1, op_type>::OpCube(const BaseCube<typename T1::elem_type, T1>& in_m,
                            const uword in_aux_uword_a, const uword in_aux_uword_b)
    : m(in_m.get_ref()), aux_uword_a(in_aux_uword_a), aux_uword_b(in_aux_uword_b) {
  arma_extra_debug_sigprint();
}

template <typename T1, typename op_type>
OpCube<T1, op_type>::OpCube(const BaseCube<typename T1::elem_type, T1>& in_m,
                            const uword in_aux_uword_a, const uword in_aux_uword_b,
                            const uword in_aux_uword_c)
    : m(in_m.get_ref()),
      aux_uword_a(in_aux_uword_a),
      aux_uword_b(in_aux_uword_b),
      aux_uword_c(in_aux_uword_c) {
  arma_extra_debug_sigprint();
}

template <typename T1, typename op_type>
OpCube<T1, op_type>::~OpCube() {
  arma_extra_debug_sigprint();
}

//! @}
