/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JFrame;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.converters.ArffSaver;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.DatabaseSaver;
import weka.gui.beans.AbstractDataSink;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSink;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.StreamThroughput;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.ThresholdDataEvent;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.WekaWrapper;

public class Saver
extends AbstractDataSink
implements WekaWrapper,
EnvironmentHandler {
    private static final long serialVersionUID = 5371716690308950755L;
    private Instances m_dataSet;
    private Instances m_structure;
    protected String m_globalInfo;
    private transient SaveBatchThread m_ioThread;
    private weka.core.converters.Saver m_Saver;
    private weka.core.converters.Saver m_SaverTemplate;
    private String m_fileName;
    private boolean m_isDBSaver;
    private boolean m_relationNameForFilename;
    private int m_count;
    protected transient Environment m_env;
    protected transient StreamThroughput m_throughput;

    private weka.core.converters.Saver makeCopy() throws Exception {
        return (weka.core.converters.Saver)new SerializedObject(this.m_SaverTemplate).getObject();
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_ioThread.isAlive()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    @Override
    public boolean isBusy() {
        return this.m_ioThread != null;
    }

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Saver() {
        this.m_SaverTemplate = this.m_Saver = new ArffSaver();
        this.m_relationNameForFilename = true;
        this.setSaverTemplate(this.m_Saver);
        this.m_fileName = "";
        this.m_dataSet = null;
        this.m_count = 0;
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    private void passEnvOnToSaver() {
        if (this.m_SaverTemplate instanceof EnvironmentHandler && this.m_env != null) {
            ((EnvironmentHandler)((Object)this.m_Saver)).setEnvironment(this.m_env);
        }
    }

    public void setSaverTemplate(weka.core.converters.Saver saver) {
        boolean loadImages = true;
        if (saver.getClass().getName().compareTo(this.m_SaverTemplate.getClass().getName()) == 0) {
            loadImages = false;
        }
        this.m_SaverTemplate = saver;
        String saverName = saver.getClass().toString();
        saverName = saverName.substring(saverName.lastIndexOf(46) + 1, saverName.length());
        if (loadImages && !this.m_visual.loadIcons("weka/gui/beans/icons/" + saverName + ".gif", "weka/gui/beans/icons/" + saverName + "_animated.gif")) {
            this.useDefaultVisual();
        }
        this.m_visual.setText(saverName);
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_SaverTemplate);
        this.m_isDBSaver = this.m_SaverTemplate instanceof DatabaseConverter;
    }

    protected String sanitizeFilename(String filename) {
        filename = filename.replaceAll("\\\\", "_").replaceAll(":", "_").replaceAll("/", "_");
        filename = Utils.removeSubstring(filename, "weka.filters.supervised.instance.");
        filename = Utils.removeSubstring(filename, "weka.filters.supervised.attribute.");
        filename = Utils.removeSubstring(filename, "weka.filters.unsupervised.instance.");
        filename = Utils.removeSubstring(filename, "weka.filters.unsupervised.attribute.");
        filename = Utils.removeSubstring(filename, "weka.clusterers.");
        filename = Utils.removeSubstring(filename, "weka.associations.");
        filename = Utils.removeSubstring(filename, "weka.attributeSelection.");
        filename = Utils.removeSubstring(filename, "weka.estimators.");
        filename = Utils.removeSubstring(filename, "weka.datagenerators.");
        if (!this.m_isDBSaver && !this.m_relationNameForFilename) {
            filename = "";
            try {
                if (this.m_Saver.filePrefix().equals("")) {
                    this.m_Saver.setFilePrefix("no-name");
                }
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        return filename;
    }

    @Override
    public synchronized void acceptDataSet(DataSetEvent e) {
        block7: {
            try {
                this.m_Saver = this.makeCopy();
            }
            catch (Exception ex) {
                if (this.m_logger == null) break block7;
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
                this.m_logger.logMessage("[Saver] " + this.statusMessagePrefix() + " unable to copy saver. " + ex.getMessage());
            }
        }
        this.passEnvOnToSaver();
        this.m_fileName = this.sanitizeFilename(e.getDataSet().relationName());
        this.m_dataSet = e.getDataSet();
        if (e.isStructureOnly() && this.m_isDBSaver && ((DatabaseSaver)this.m_SaverTemplate).getRelationForTableName()) {
            ((DatabaseSaver)this.m_Saver).setTableName(this.m_fileName);
        }
        if (!e.isStructureOnly()) {
            if (!this.m_isDBSaver) {
                try {
                    this.m_Saver.setDirAndPrefix(this.m_fileName, "");
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            }
            this.saveBatch();
            System.out.println("...relation " + this.m_fileName + " saved.");
        }
    }

    @Override
    public synchronized void acceptDataSet(ThresholdDataEvent e) {
        block6: {
            try {
                this.m_Saver = this.makeCopy();
            }
            catch (Exception ex) {
                if (this.m_logger == null) break block6;
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
                this.m_logger.logMessage("[Saver] " + this.statusMessagePrefix() + " unable to copy saver. " + ex.getMessage());
            }
        }
        this.passEnvOnToSaver();
        this.m_fileName = this.sanitizeFilename(e.getDataSet().getPlotInstances().relationName());
        this.m_dataSet = e.getDataSet().getPlotInstances();
        if (this.m_isDBSaver && ((DatabaseSaver)this.m_SaverTemplate).getRelationForTableName()) {
            ((DatabaseSaver)this.m_Saver).setTableName(this.m_fileName);
            ((DatabaseSaver)this.m_Saver).setRelationForTableName(false);
        }
        if (!this.m_isDBSaver) {
            try {
                this.m_Saver.setDirAndPrefix(this.m_fileName, "");
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
        this.saveBatch();
        System.out.println("...relation " + this.m_fileName + " saved.");
    }

    @Override
    public synchronized void acceptTestSet(TestSetEvent e) {
        block8: {
            try {
                this.m_Saver = this.makeCopy();
            }
            catch (Exception ex) {
                if (this.m_logger == null) break block8;
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
                this.m_logger.logMessage("[Saver] " + this.statusMessagePrefix() + " unable to copy saver. " + ex.getMessage());
            }
        }
        this.passEnvOnToSaver();
        this.m_fileName = this.sanitizeFilename(e.getTestSet().relationName());
        this.m_dataSet = e.getTestSet();
        if (e.isStructureOnly() && this.m_isDBSaver && ((DatabaseSaver)this.m_SaverTemplate).getRelationForTableName()) {
            ((DatabaseSaver)this.m_Saver).setTableName(this.m_fileName);
        }
        if (!e.isStructureOnly()) {
            if (!this.m_isDBSaver) {
                try {
                    this.m_Saver.setDirAndPrefix(this.m_fileName, "_test_" + e.getSetNumber() + "_of_" + e.getMaxSetNumber());
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            } else {
                ((DatabaseSaver)this.m_Saver).setRelationForTableName(false);
                String setName = ((DatabaseSaver)this.m_Saver).getTableName();
                setName = setName.replaceFirst("_[tT][eE][sS][tT]_[0-9]+_[oO][fF]_[0-9]+", "");
                ((DatabaseSaver)this.m_Saver).setTableName(setName + "_test_" + e.getSetNumber() + "_of_" + e.getMaxSetNumber());
            }
            this.saveBatch();
            System.out.println("... test set " + e.getSetNumber() + " of " + e.getMaxSetNumber() + " for relation " + this.m_fileName + " saved.");
        }
    }

    @Override
    public synchronized void acceptTrainingSet(TrainingSetEvent e) {
        block8: {
            try {
                this.m_Saver = this.makeCopy();
            }
            catch (Exception ex) {
                if (this.m_logger == null) break block8;
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
                this.m_logger.logMessage("[Saver] " + this.statusMessagePrefix() + " unable to copy saver. " + ex.getMessage());
            }
        }
        this.passEnvOnToSaver();
        this.m_fileName = this.sanitizeFilename(e.getTrainingSet().relationName());
        this.m_dataSet = e.getTrainingSet();
        if (e.isStructureOnly() && this.m_isDBSaver && ((DatabaseSaver)this.m_SaverTemplate).getRelationForTableName()) {
            ((DatabaseSaver)this.m_Saver).setTableName(this.m_fileName);
        }
        if (!e.isStructureOnly()) {
            if (!this.m_isDBSaver) {
                try {
                    this.m_Saver.setDirAndPrefix(this.m_fileName, "_training_" + e.getSetNumber() + "_of_" + e.getMaxSetNumber());
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            } else {
                ((DatabaseSaver)this.m_Saver).setRelationForTableName(false);
                String setName = ((DatabaseSaver)this.m_Saver).getTableName();
                setName = setName.replaceFirst("_[tT][rR][aA][iI][nN][iI][nN][gG]_[0-9]+_[oO][fF]_[0-9]+", "");
                ((DatabaseSaver)this.m_Saver).setTableName(setName + "_training_" + e.getSetNumber() + "_of_" + e.getMaxSetNumber());
            }
            this.saveBatch();
            System.out.println("... training set " + e.getSetNumber() + " of " + e.getMaxSetNumber() + " for relation " + this.m_fileName + " saved.");
        }
    }

    public synchronized void saveBatch() {
        this.m_Saver.setRetrieval(1);
        this.m_ioThread = new SaveBatchThread(this);
        this.m_ioThread.setPriority(1);
        this.m_ioThread.start();
        this.block(true);
    }

    @Override
    public synchronized void acceptInstance(InstanceEvent e) {
        if (e.getStatus() == 0) {
            block19: {
                this.m_throughput = new StreamThroughput(this.statusMessagePrefix());
                try {
                    this.m_Saver = this.makeCopy();
                }
                catch (Exception ex) {
                    if (this.m_logger == null) break block19;
                    this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
                    this.m_logger.logMessage("[Saver] " + this.statusMessagePrefix() + " unable to copy saver. " + ex.getMessage());
                }
            }
            this.m_Saver.setRetrieval(2);
            this.m_structure = e.getStructure();
            this.m_fileName = this.sanitizeFilename(this.m_structure.relationName());
            this.m_Saver.setInstances(this.m_structure);
            if (this.m_isDBSaver && ((DatabaseSaver)this.m_SaverTemplate).getRelationForTableName()) {
                ((DatabaseSaver)this.m_Saver).setTableName(this.m_fileName);
                ((DatabaseSaver)this.m_Saver).setRelationForTableName(false);
            }
        }
        if (e.getStatus() == 1) {
            this.m_visual.setAnimated();
            this.m_throughput.updateStart();
            if (this.m_count == 0) {
                this.passEnvOnToSaver();
                if (!this.m_isDBSaver) {
                    try {
                        this.m_Saver.setDirAndPrefix(this.m_fileName, "");
                    }
                    catch (Exception ex) {
                        System.out.println(ex);
                        this.m_visual.setStatic();
                    }
                }
                ++this.m_count;
            }
            try {
                this.m_Saver.writeIncremental(e.getInstance());
                this.m_throughput.updateEnd(this.m_logger);
            }
            catch (Exception ex) {
                this.m_visual.setStatic();
                System.err.println("Instance " + e.getInstance() + " could not been saved");
                ex.printStackTrace();
            }
        }
        if (e.getStatus() == 2) {
            try {
                if (this.m_count == 0) {
                    this.passEnvOnToSaver();
                    if (!this.m_isDBSaver) {
                        try {
                            this.m_Saver.setDirAndPrefix(this.m_fileName, "");
                        }
                        catch (Exception ex) {
                            System.out.println(ex);
                            this.m_visual.setStatic();
                        }
                    }
                    ++this.m_count;
                }
                this.m_Saver.writeIncremental(e.getInstance());
                if (e.getInstance() != null) {
                    this.m_throughput.updateStart();
                    this.m_Saver.writeIncremental(null);
                    this.m_throughput.updateEnd(this.m_logger);
                }
                this.m_visual.setStatic();
                this.m_count = 0;
                this.m_throughput.finished(this.m_logger);
            }
            catch (Exception ex) {
                this.m_visual.setStatic();
                System.err.println("File could not have been closed.");
                ex.printStackTrace();
            }
        }
    }

    public weka.core.converters.Saver getSaverTemplate() {
        return this.m_SaverTemplate;
    }

    @Override
    public void setWrappedAlgorithm(Object algorithm) {
        if (!(algorithm instanceof weka.core.converters.Saver)) {
            throw new IllegalArgumentException(algorithm.getClass() + " : incorrect type of algorithm (Loader)");
        }
        this.setSaverTemplate((weka.core.converters.Saver)algorithm);
    }

    @Override
    public Object getWrappedAlgorithm() {
        return this.getSaverTemplate();
    }

    public void setRelationNameForFilename(boolean r) {
        this.m_relationNameForFilename = r;
    }

    public boolean getRelationNameForFilename() {
        return this.m_relationNameForFilename;
    }

    @Override
    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_ioThread != null) {
            this.m_ioThread.interrupt();
            this.m_ioThread.stop();
            this.m_ioThread = null;
        }
        this.m_count = 0;
        this.m_visual.setStatic();
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|" + (this.m_Saver instanceof OptionHandler ? Utils.joinOptions(((OptionHandler)((Object)this.m_Saver)).getOptions()) + "|" : "");
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        aStream.defaultReadObject();
        this.m_env = Environment.getSystemWide();
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            Saver tv = new Saver();
            jf.getContentPane().add((Component)tv, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class SaveBatchThread
    extends Thread {
        public SaveBatchThread(DataSink ds) {
        }

        @Override
        public void run() {
            try {
                Saver.this.m_visual.setAnimated();
                Saver.this.m_Saver.setInstances(Saver.this.m_dataSet);
                if (Saver.this.m_logger != null) {
                    Saver.this.m_logger.statusMessage(Saver.this.statusMessagePrefix() + "Saving " + Saver.this.m_dataSet.relationName() + "...");
                }
                Saver.this.m_Saver.writeBatch();
                if (Saver.this.m_logger != null) {
                    Saver.this.m_logger.logMessage("[Saver] " + Saver.this.statusMessagePrefix() + "Save successful.");
                }
            }
            catch (Exception ex) {
                if (Saver.this.m_logger != null) {
                    Saver.this.m_logger.statusMessage(Saver.this.statusMessagePrefix() + "ERROR (See log for details)");
                    Saver.this.m_logger.logMessage("[Saver] " + Saver.this.statusMessagePrefix() + " problem saving. " + ex.getMessage());
                }
                ex.printStackTrace();
            }
            finally {
                if (Thread.currentThread().isInterrupted() && Saver.this.m_logger != null) {
                    Saver.this.m_logger.logMessage("[Saver] " + Saver.this.statusMessagePrefix() + " Saving interrupted!!");
                }
                if (Saver.this.m_logger != null) {
                    Saver.this.m_logger.statusMessage(Saver.this.statusMessagePrefix() + "Finished.");
                }
                Saver.this.block(false);
                Saver.this.m_visual.setStatic();
                Saver.this.m_ioThread = null;
            }
        }
    }
}

